/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import net.sourceforge.sqlexplorer.ApplicationFiles;
import net.sourceforge.sqlexplorer.URLUtil;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.squirrel_sql.fw.id.IHasIdentifier;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.persist.ValidationException;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.SQLAlias;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverManager;
import net.sourceforge.squirrel_sql.fw.util.DuplicateObjectException;
import net.sourceforge.squirrel_sql.fw.util.IObjectCacheChangeListener;
import net.sourceforge.squirrel_sql.fw.xml.XMLException;
import net.sourceforge.squirrel_sql.fw.xml.XMLObjectCache;

public class DataCache {
    private static final Class SQL_ALIAS_IMPL;
    private static final Class SQL_DRIVER_IMPL;
    private SQLDriverManager _driverMgr;
    private XMLObjectCache _cache = new XMLObjectCache();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.squirrel_sql.fw.sql.SQLAlias");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SQL_ALIAS_IMPL = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("net.sourceforge.squirrel_sql.fw.sql.SQLDriver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SQL_DRIVER_IMPL = clazz2;
    }

    public DataCache(SQLDriverManager dm) throws IllegalArgumentException {
        this._driverMgr = dm;
        this.loadDrivers();
        this.loadAliases();
    }

    public void save() {
        try {
            this._cache.saveAllForClass(ApplicationFiles.USER_DRIVER_FILE_NAME, SQL_DRIVER_IMPL);
        }
        catch (IOException ex) {
            SQLExplorerPlugin.error("Error occured saving drivers", ex);
        }
        catch (XMLException ex) {
            SQLExplorerPlugin.error("Error occured saving drivers", ex);
        }
        try {
            this._cache.saveAllForClass(ApplicationFiles.USER_ALIAS_FILE_NAME, SQL_ALIAS_IMPL);
        }
        catch (Exception ex) {
            SQLExplorerPlugin.error("Error occured saving aliases", ex);
        }
    }

    public ISQLDriver getDriver(IIdentifier id) {
        return (ISQLDriver)this._cache.get(SQL_DRIVER_IMPL, id);
    }

    public void addDriver(ISQLDriver sqlDriver) throws ClassNotFoundException, IllegalAccessException, InstantiationException, DuplicateObjectException, MalformedURLException {
        this._driverMgr.registerSQLDriver(sqlDriver);
        this._cache.add((IHasIdentifier)sqlDriver);
    }

    public void removeDriver(ISQLDriver sqlDriver) {
        this._cache.remove(SQL_DRIVER_IMPL, sqlDriver.getIdentifier());
        try {
            this._driverMgr.unregisterSQLDriver(sqlDriver);
        }
        catch (Exception ex) {
            SQLExplorerPlugin.error("Error occured removing driver", ex);
        }
    }

    public Iterator drivers() {
        return this._cache.getAllForClass(SQL_DRIVER_IMPL);
    }

    public void addDriversListener(IObjectCacheChangeListener lis) {
        this._cache.addChangesListener(lis, SQL_DRIVER_IMPL);
    }

    public void removeDriversListener(IObjectCacheChangeListener lis) {
        this._cache.removeChangesListener(lis, SQL_DRIVER_IMPL);
    }

    public ISQLAlias getAlias(IIdentifier id) {
        return (ISQLAlias)this._cache.get(SQL_ALIAS_IMPL, id);
    }

    public Iterator aliases() {
        return this._cache.getAllForClass(SQL_ALIAS_IMPL);
    }

    public void addAlias(ISQLAlias alias) throws DuplicateObjectException {
        this._cache.add((IHasIdentifier)alias);
    }

    public void removeAlias(ISQLAlias alias) {
        this._cache.remove(SQL_ALIAS_IMPL, alias.getIdentifier());
    }

    public Iterator getAliasesForDriver(ISQLDriver driver) {
        ArrayList<ISQLAlias> data = new ArrayList<ISQLAlias>();
        Iterator it = this.aliases();
        while (it.hasNext()) {
            ISQLAlias alias = (ISQLAlias)it.next();
            if (!driver.equals(this.getDriver(alias.getDriverIdentifier()))) continue;
            data.add(alias);
        }
        return data.iterator();
    }

    public void addAliasesListener(IObjectCacheChangeListener lis) {
        this._cache.addChangesListener(lis, SQL_ALIAS_IMPL);
    }

    public void removeAliasesListener(IObjectCacheChangeListener lis) {
        this._cache.removeChangesListener(lis, SQL_ALIAS_IMPL);
    }

    private void loadDrivers() {
        try {
            this._cache.load(ApplicationFiles.USER_DRIVER_FILE_NAME);
            if (!this.drivers().hasNext()) {
                this.loadDefaultDrivers();
            } else {
                this.fixupDrivers();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.loadDefaultDrivers();
        }
        catch (Exception exception) {
            this.loadDefaultDrivers();
        }
        this.registerDrivers();
    }

    public ISQLAlias createAlias(IIdentifier id) {
        return new SQLAlias(id);
    }

    public ISQLDriver createDriver(IIdentifier id) {
        return new SQLDriver(id);
    }

    private void fixupDrivers() {
        Iterator it = this.drivers();
        while (it.hasNext()) {
            ISQLDriver driver = (ISQLDriver)it.next();
            String[] fileNames = driver.getJarFileNames();
            if (fileNames != null && fileNames.length != 0) continue;
            String[] fileNameArray = driver.getJarFileNames();
            if (fileNameArray == null || fileNameArray.length <= 0) continue;
            driver.setJarFileNames(fileNameArray);
            try {
                driver.setJarFileName(null);
            }
            catch (ValidationException validationException) {}
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadDefaultDrivers() {
        URL url = URLUtil.getResourceURL("default_drivers.xml");
        try {
            InputStreamReader isr = new InputStreamReader(url.openStream());
            try {
                this._cache.load((Reader)isr);
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                isr.close();
                throw throwable;
            }
            {
                Object var3_6 = null;
                isr.close();
                return;
            }
        }
        catch (Exception ex) {
            SQLExplorerPlugin.error("Error loading default driver file", ex);
        }
    }

    private void registerDrivers() {
        SQLDriverManager driverMgr = this._driverMgr;
        Iterator it = this.drivers();
        while (it.hasNext()) {
            ISQLDriver sqlDriver = (ISQLDriver)it.next();
            try {
                driverMgr.registerSQLDriver(sqlDriver);
            }
            catch (Throwable throwable) {}
        }
    }

    private void loadAliases() {
        try {
            this._cache.load(ApplicationFiles.USER_ALIAS_FILE_NAME);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (XMLException ex) {
            SQLExplorerPlugin.error("Error loading aliases file ", ex);
        }
        catch (DuplicateObjectException ex) {
            SQLExplorerPlugin.error("Error loading aliases file ", ex);
        }
    }
}

