/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.Blob;
import java.sql.SQLException;
import javax.sql.rowset.serial.SerialException;

public class SerialBlob
implements Blob,
Serializable,
Cloneable {
    byte[] buf;
    long len;
    long origLen;

    public SerialBlob(Blob blob) throws SerialException, SQLException {
        this.origLen = this.len = blob.length();
        this.buf = blob.getBytes(0L, (int)this.len);
    }

    public byte[] getBytes(long l, int n) throws SerialException {
        if ((long)n > this.len) {
            n = (int)this.len;
        }
        if (l < 0L || (long)n - l < 0L) {
            throw new SerialException("Invalid Arguments");
        }
        Class<?> clazz = this.buf.getClass();
        Class<?> clazz2 = clazz.getComponentType();
        Object object = Array.newInstance(clazz2, (int)((long)n - l));
        System.arraycopy(this.buf, (int)l, object, 0, (int)((long)n - l));
        return (byte[])object;
    }

    public long length() throws SerialException {
        return this.len;
    }

    public InputStream getBinaryStream() throws SerialException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.buf);
        return byteArrayInputStream;
    }

    /*
     * Unable to fully structure code
     */
    public long position(byte[] var1_1, long var2_2) throws SerialException {
        var4_3 = (int)(var2_2 - 1L);
        var7_4 = 0;
        var8_5 = var1_1.length;
        if (var2_2 >= 0L && var2_2 <= this.len) ** GOTO lbl11
        return -1L;
lbl-1000:
        // 1 sources

        {
            var7_4 = 0;
            var5_6 = var4_3 + 1;
            while (var1_1[var7_4++] == this.buf[var4_3++]) {
                if ((long)var7_4 != var8_5) continue;
                return var5_6;
            }
lbl11:
            // 2 sources

            ** while ((long)var4_3 < this.len)
        }
lbl12:
        // 1 sources

        return -1L;
    }

    public long position(Blob blob, long l) throws SerialException, SQLException {
        return this.position(blob.getBytes(0L, (int)blob.length()), l);
    }

    public int setBytes(long l, byte[] byArray) throws SerialException {
        return this.setBytes(l, byArray, 0, byArray.length);
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SerialException {
        if ((long)n2 > this.origLen) {
            throw new SerialException("Buffer is not sufficient to hold the value");
        }
        int n3 = 0;
        while (n3 < n2) {
            this.buf[(int)l + n3] = byArray[n + n3];
            ++n3;
        }
        return n3;
    }

    public OutputStream setBinaryStream(long l) throws SerialException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)((long)this.buf.length - l));
        return byteArrayOutputStream;
    }

    public void truncate(long l) throws SerialException {
        if (l > this.len) {
            throw new SerialException("Length more than what can be truncated");
        }
        this.len = l;
        this.buf = this.getBytes(0L, (int)this.len);
    }
}

