/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.Serializable;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Map;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialDatalink;
import javax.sql.rowset.serial.SerialException;
import javax.sql.rowset.serial.SerialJavaObject;
import javax.sql.rowset.serial.SerialStruct;

public class SerialArray
implements Array,
Serializable,
Cloneable {
    private Object[] elements;
    private int baseType;
    private String baseTypeName;
    private int len;

    public SerialArray(Array array, Map map) throws SerialException, SQLException {
        this.elements = (Object[])array.getArray(map);
        this.baseType = this.getBaseType();
        this.baseTypeName = this.getBaseTypeName();
        this.len = this.elements.length;
        switch (this.baseType) {
            case 2002: {
                int n = 0;
                while (n < this.len) {
                    this.elements[n] = new SerialStruct((Struct)this.elements[n], map);
                    ++n;
                }
                break;
            }
            case 2003: {
                int n = 0;
                while (n < this.len) {
                    this.elements[n] = new SerialArray((Array)this.elements[n], map);
                    ++n;
                }
                break;
            }
            case 2004: {
                int n = 0;
                while (n < this.len) {
                    this.elements[n] = new SerialBlob((Blob)this.elements[n]);
                    ++n;
                }
                break;
            }
            case 2005: {
                int n = 0;
                while (n < this.len) {
                    this.elements[n] = new SerialClob((Clob)this.elements[n]);
                    ++n;
                }
                break;
            }
            case 70: {
                int n = 0;
                while (n < this.len) {
                    this.elements[n] = new SerialDatalink((URL)this.elements[n]);
                    ++n;
                }
            }
            case 2000: {
                int n = 0;
                while (n < this.len) {
                    this.elements[n] = new SerialJavaObject((URL)this.elements[n]);
                    ++n;
                }
                break;
            }
        }
    }

    public SerialArray(Array array) throws SerialException, SQLException {
        this.elements = (Object[])array.getArray();
        this.baseType = this.getBaseType();
        this.baseTypeName = this.getBaseTypeName();
        this.len = this.elements.length;
        switch (this.baseType) {
            case 2004: {
                int n = 0;
                while (n < this.len) {
                    this.elements[n] = new SerialBlob((Blob)this.elements[n]);
                    ++n;
                }
                break;
            }
            case 2005: {
                int n = 0;
                while (n < this.len) {
                    this.elements[n] = new SerialClob((Clob)this.elements[n]);
                    ++n;
                }
                break;
            }
            case 70: {
                int n = 0;
                while (n < this.len) {
                    this.elements[n] = new SerialDatalink((URL)this.elements[n]);
                    ++n;
                }
            }
            case 2000: {
                int n = 0;
                while (n < this.len) {
                    this.elements[n] = new SerialJavaObject((URL)this.elements[n]);
                    ++n;
                }
                break;
            }
        }
    }

    public Object getArray() throws SerialException {
        Object[] objectArray = new Object[this.len];
        System.arraycopy(this.elements, 0, objectArray, 0, this.len);
        return objectArray;
    }

    public Object getArray(Map map) throws SerialException {
        Object[] objectArray = new Object[this.len];
        System.arraycopy(this.elements, 0, objectArray, 0, this.len);
        return objectArray;
    }

    public Object getArray(long l, int n) throws SerialException {
        Object[] objectArray = new Object[n];
        System.arraycopy(this.elements, (int)l, objectArray, 0, n);
        return objectArray;
    }

    public Object getArray(long l, int n, Map map) throws SerialException {
        Object[] objectArray = new Object[n];
        System.arraycopy(this.elements, (int)l, objectArray, 0, n);
        return objectArray;
    }

    public int getBaseType() throws SerialException {
        return this.baseType;
    }

    public String getBaseTypeName() throws SerialException {
        return this.baseTypeName;
    }

    public ResultSet getResultSet(long l, int n) throws SerialException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getResultSet(Map map) throws SerialException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getResultSet() throws SerialException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getResultSet(long l, int n, Map map) throws SerialException {
        throw new UnsupportedOperationException();
    }
}

