/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;
import javax.sql.rowset.serial.SerialArray;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialRef;

public abstract class BaseRowSet
implements Serializable,
Cloneable {
    public static final int UNICODE_STREAM_PARAM = 0;
    public static final int BINARY_STREAM_PARAM = 1;
    public static final int ASCII_STREAM_PARAM = 2;
    protected InputStream binaryStream;
    protected InputStream unicodeStream;
    protected InputStream asciiStream;
    protected Reader charStream;
    private String command;
    private String URL;
    private String dataSource;
    private transient String username;
    private transient String password;
    private int rowSetType;
    private boolean showDeleted;
    private int queryTimeout;
    private int maxRows;
    private int maxFieldSize;
    private int concurrency;
    private boolean readOnly;
    private boolean escapeProcessing;
    private int isolation;
    private int fetchDir;
    private int fetchSize;
    private Map map;
    private Vector listeners = new Vector();
    private Vector params;
    private String strMatchColumn = "";
    private int iMatchColumn = -1;

    protected void initParams() {
        this.params = new Vector();
    }

    public void addRowSetListener(RowSetListener rowSetListener) {
        this.listeners.add(rowSetListener);
    }

    public void removeRowSetListener(RowSetListener rowSetListener) {
        this.listeners.remove(rowSetListener);
    }

    protected void notifyCursorMoved() {
        if (!this.listeners.isEmpty()) {
            RowSetEvent rowSetEvent = new RowSetEvent((RowSet)((Object)this));
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((RowSetListener)iterator.next()).cursorMoved(rowSetEvent);
            }
        }
    }

    protected void notifyRowChanged() {
        if (!this.listeners.isEmpty()) {
            RowSetEvent rowSetEvent = new RowSetEvent((RowSet)((Object)this));
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((RowSetListener)iterator.next()).rowChanged(rowSetEvent);
            }
        }
    }

    protected void notifyRowSetChanged() {
        if (!this.listeners.isEmpty()) {
            RowSetEvent rowSetEvent = new RowSetEvent((RowSet)((Object)this));
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((RowSetListener)iterator.next()).rowSetChanged(rowSetEvent);
            }
        }
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String string) throws SQLException {
        if (string.length() == 0) {
            throw new SQLException("Invalid command string detected. Cannot be of length less than 0");
        }
        this.command = new String(string);
        this.params.clear();
    }

    public String getUrl() throws SQLException {
        return this.URL;
    }

    public void setUrl(String string) throws SQLException {
        if (string.length() == 0) {
            throw new SQLException("Invalid url string detected. Cannot be of length less than 0");
        }
        this.URL = string == null ? null : new String(string);
        this.dataSource = null;
    }

    public String getDataSourceName() {
        return this.dataSource;
    }

    public void setDataSourceName(String string) {
        this.dataSource = string == null ? null : new String(string);
        this.URL = null;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = new String(string);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = new String(string);
    }

    public void setType(int n) {
        this.rowSetType = n;
    }

    public int getType() throws SQLException {
        return this.rowSetType;
    }

    public void setConcurrency(int n) {
        this.concurrency = n;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public int getTransactionIsolation() {
        return this.isolation;
    }

    public void setTransactionIsolation(int n) {
        this.isolation = n;
    }

    public Map getTypeMap() {
        return this.map;
    }

    public void setTypeMap(Map map) {
        this.map = map;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException("Invalid max field size set. Cannot be of value: " + n);
        }
        this.maxFieldSize = n;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public void setMaxRows(int n) throws SQLException {
        this.maxRows = n;
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.escapeProcessing = bl;
    }

    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.queryTimeout = n;
    }

    public boolean getShowDeleted() throws SQLException {
        return this.showDeleted;
    }

    public void setShowDeleted(boolean bl) throws SQLException {
        this.showDeleted = bl;
    }

    public boolean getEscapeProcessing() throws SQLException {
        return this.escapeProcessing;
    }

    public void setFetchDirection(int n) throws SQLException {
        if (this.getType() == 1003 && n != 1000) {
            throw new SQLException("Invalid Fetch Direction");
        }
        this.fetchDir = n;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDir;
    }

    public void setFetchSize(int n) throws SQLException {
        this.fetchSize = n;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public int getConcurrency() throws SQLException {
        return this.concurrency;
    }

    private void checkParamIndex(int n) throws SQLException {
        if (n < 1) {
            throw new SQLException("Invalid Parameter Index");
        }
    }

    public void setNull(int n, int n2) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{null, new Integer(n2)};
        this.params.add(n - 1, objectArray);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{null, new Integer(n2), new String(string)};
        this.params.add(n - 1, objectArray);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.checkParamIndex(n);
        this.params.add(n - 1, new Boolean(bl));
    }

    public void setByte(int n, byte by) throws SQLException {
        this.checkParamIndex(n);
        this.params.add(n - 1, new Byte(by));
    }

    public void setShort(int n, short s) throws SQLException {
        this.checkParamIndex(n);
        this.params.add(n - 1, new Short(s));
    }

    public void setInt(int n, int n2) throws SQLException {
        this.checkParamIndex(n);
        this.params.add(n - 1, new Integer(n2));
    }

    public void setLong(int n, long l) throws SQLException {
        this.checkParamIndex(n);
        this.params.add(n - 1, new Long(l));
    }

    public void setFloat(int n, float f) throws SQLException {
        this.checkParamIndex(n);
        this.params.add(n - 1, new Float(f));
    }

    public void setDouble(int n, double d) throws SQLException {
        this.checkParamIndex(n);
        this.params.add(n - 1, new Double(d));
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.checkParamIndex(n);
        this.params.add(n - 1, bigDecimal);
    }

    public void setString(int n, String string) throws SQLException {
        this.checkParamIndex(n);
        this.params.add(n - 1, string);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.checkParamIndex(n);
        this.params.add(n - 1, byArray);
    }

    public void setDate(int n, Date date) throws SQLException {
        this.checkParamIndex(n);
        this.params.add(n - 1, date);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.checkParamIndex(n);
        this.params.add(n - 1, time);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.checkParamIndex(n);
        this.params.add(n - 1, timestamp);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{inputStream, new Integer(n2), new Integer(2)};
        this.params.add(n - 1, objectArray);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{inputStream, new Integer(n2), new Integer(1)};
        this.params.add(n - 1, objectArray);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{inputStream, new Integer(n2), new Integer(0)};
        this.params.add(n - 1, objectArray);
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{reader, new Integer(n2)};
        this.params.add(n - 1, objectArray);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{object, new Integer(n2), new Integer(n3)};
        this.params.add(n - 1, objectArray);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{object, new Integer(n2)};
        this.params.add(n - 1, objectArray);
    }

    public void setObject(int n, Object object) throws SQLException {
        this.checkParamIndex(n);
        this.params.add(n - 1, object);
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.checkParamIndex(n);
        this.params.add(n - 1, new SerialRef(ref));
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.checkParamIndex(n);
        this.params.add(n - 1, new SerialBlob(blob));
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.checkParamIndex(n);
        this.params.add(n - 1, new SerialClob(clob));
    }

    public void setArray(int n, Array array) throws SQLException {
        this.checkParamIndex(n);
        this.params.add(n - 1, new SerialArray(array));
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{date, calendar};
        this.params.add(n - 1, objectArray);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{time, calendar};
        this.params.add(n - 1, objectArray);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{timestamp, calendar};
        this.params.add(n - 1, objectArray);
    }

    public void clearParameters() throws SQLException {
        this.params.clear();
    }

    public Object[] getParams() throws SQLException {
        if (this.params == null) {
            throw new SQLException("Error: RowSet does not contain command parameters");
        }
        return this.params.toArray();
    }
}

