/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.ext.mssql.actions;

import net.sourceforge.sqlexplorer.IConstants;
import net.sourceforge.sqlexplorer.dbviewer.model.IDbModel;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.editors.SQLEditor;
import net.sourceforge.sqlexplorer.plugin.editors.SQLEditorInput;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;

public class CreateProcedureEdit
extends Action {
    SessionTreeNode sessionNode;
    IDbModel node;

    public CreateProcedureEdit(SessionTreeNode sessionTreeNode, IDbModel node) {
        this.sessionNode = sessionTreeNode;
        this.node = node;
    }

    public String getText() {
        return "Create a new Procedure...";
    }

    public void run() {
        try {
            String owner = this.sessionNode.getSQLConnection().getSQLMetaData().getUserName();
            String separator = System.getProperty("line.separator");
            String txt = "CREATE PROCEDURE " + this.node.getParent().toString() + "." + owner + ".<procedure>" + separator + "  @parameter1  varchar(30)" + separator + "AS" + separator + "--" + separator + "-- NAME        : " + separator + "-- DESCRIPTION : " + separator + "-- AUTHOR      " + separator + separator + "BEGIN " + separator + " /* do something */" + separator + "END" + separator;
            SQLEditorInput input = new SQLEditorInput("CREATE PROCEDURE (" + SQLExplorerPlugin.getDefault().getNextElement() + ").sql");
            input.setSessionNode(this.sessionNode);
            IWorkbenchPage page = SQLExplorerPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            SQLEditor editorPart = (SQLEditor)page.openEditor((IEditorInput)input, IConstants.SQL_EDITOR_CLASS);
            editorPart.setText(txt);
        }
        catch (Exception e) {
            SQLExplorerPlugin.error((String)"Error creating sql editor", (Throwable)e);
        }
    }
}

