/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jadclipse.ui;

import net.sf.jadclipse.CommandLine;
import net.sf.jadclipse.CommandOption;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public abstract class CommandLineOptionEditor {
    private String optionName;
    private String label;
    private PreferencePage preferencePage;
    private Composite parent;

    protected CommandLineOptionEditor() {
    }

    public CommandLineOptionEditor(String optionName, String label, Composite parent) {
        this.init(optionName, label);
        this.createControl(parent);
    }

    protected void init(String optionName, String label) {
        if (optionName == null) {
            throw new IllegalArgumentException("null option name");
        }
        this.optionName = optionName;
        this.label = label != null ? label : optionName;
    }

    protected abstract void doFillIntoGrid(Composite var1, int var2);

    protected abstract void adjustForNumColumns(int var1);

    public abstract CommandOption toOption();

    public abstract int getNumberOfControls();

    protected void createControl(Composite parent) {
        this.parent = parent;
        GridLayout layout = new GridLayout();
        layout.numColumns = this.getNumberOfControls();
        layout.makeColumnsEqualWidth = false;
        parent.setLayout((Layout)layout);
        this.doFillIntoGrid(parent, layout.numColumns);
    }

    protected void doAccept(CommandOption option) {
    }

    public PreferencePage getPreferencePage() {
        return this.preferencePage;
    }

    public void setPreferencePage(PreferencePage page) {
        this.preferencePage = page;
    }

    public void accept(CommandLine cmdLine) {
        this.doAccept(cmdLine.getOption(this.optionName));
    }

    public String getLabel() {
        return this.label;
    }

    public String getOptionName() {
        return this.optionName;
    }

    public Composite getParent() {
        return this.parent;
    }
}

