/*
 * Decompiled with CFR 0.152.
 */
package net.sf.commonclipse.preferences;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public abstract class TabbedFieldEditorPreferencePage
extends FieldEditorPreferencePage {
    private TabFolder folder;
    private int maxNumOfColumns;

    protected TabbedFieldEditorPreferencePage(int style) {
        super(style);
    }

    protected TabbedFieldEditorPreferencePage(String title, int style) {
        super(title, style);
    }

    protected TabbedFieldEditorPreferencePage(String title, ImageDescriptor image, int style) {
        super(title, image, style);
    }

    protected void addField(FieldEditor editor) {
        this.maxNumOfColumns = Math.max(this.maxNumOfColumns, editor.getNumberOfControls());
        super.addField(editor);
    }

    protected void adjustGridLayout() {
        if (this.folder != null) {
            TabItem[] items = this.folder.getItems();
            for (int j = 0; j < items.length; ++j) {
                GridLayout layout = (GridLayout)((Composite)items[j].getControl()).getLayout();
                layout.numColumns = this.maxNumOfColumns;
                layout.marginHeight = 5;
                layout.marginWidth = 5;
            }
        }
        super.adjustGridLayout();
        ((GridLayout)super.getFieldEditorParent().getLayout()).numColumns = 1;
    }

    protected Composite getFieldEditorParent() {
        if (this.folder == null || this.folder.getItemCount() == 0) {
            return super.getFieldEditorParent();
        }
        return (Composite)this.folder.getItem(this.folder.getItemCount() - 1).getControl();
    }

    public void addTab(String text) {
        if (this.folder == null) {
            this.folder = new TabFolder(super.getFieldEditorParent(), 0);
            this.folder.setLayoutData((Object)new GridData(1808));
        }
        TabItem item = new TabItem(this.folder, 0);
        item.setText(text);
        Composite currentTab = new Composite((Composite)this.folder, 0);
        GridLayout layout = new GridLayout();
        currentTab.setLayout((Layout)layout);
        currentTab.setFont(super.getFieldEditorParent().getFont());
        currentTab.setLayoutData((Object)new GridData(768));
        item.setControl((Control)currentTab);
    }
}

