/*
 * Decompiled with CFR 0.152.
 */
package net.sf.commonclipse.popup.actions;

import net.sf.commonclipse.popup.actions.JavaTypeAction;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class JavaTypeViewerAction
extends JavaTypeAction
implements IEditorActionDelegate {
    private ITextEditor editor;

    public void run(IAction action) {
        IType type = null;
        if (this.editor != null) {
            if (this.editor instanceof JavaEditor) {
                try {
                    IJavaElement element = SelectionConverter.getElementAtOffset((JavaEditor)((JavaEditor)this.editor));
                    if (element != null) {
                        type = (IType)element.getAncestor(7);
                    }
                }
                catch (JavaModelException e) {
                    // empty catch block
                }
            }
            if (type == null) {
                IWorkingCopyManager manager = JavaUI.getWorkingCopyManager();
                ICompilationUnit unit = manager.getWorkingCopy(this.editor.getEditorInput());
                type = unit.findPrimaryType();
            }
        }
        if (type != null) {
            this.runAction(action, type, new Shell());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IEditorPart activeEditor;
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (activeEditor = page.getActiveEditor()) != null && activeEditor instanceof ITextEditor) {
            this.setActiveEditor(action, activeEditor);
        }
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        if (targetEditor instanceof ITextEditor) {
            this.editor = (ITextEditor)targetEditor;
        }
    }
}

