/*
 * Decompiled with CFR 0.152.
 */
package net.sf.commonclipse;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.commonclipse.CCPluginPreferences;
import net.sf.commonclipse.Generator;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;

public final class ToStringGenerator
extends Generator {
    private static final String BUILDER_CLASS = "org.apache.commons.lang.builder.ToStringBuilder";
    private static Generator instance = new ToStringGenerator();

    private ToStringGenerator() {
    }

    public static Generator getInstance() {
        return instance;
    }

    protected String getMethodName() {
        return "toString";
    }

    protected void addImports(IType type) throws JavaModelException {
        type.getCompilationUnit().createImport(BUILDER_CLASS, null, null);
        if (CCPluginPreferences.getPreferences().useCustomToStringStyle()) {
            type.getCompilationUnit().createImport(CCPluginPreferences.getPreferences().getToStringStyleQualifiedClass(), null, null);
        }
    }

    protected String createMethod(IType type) throws JavaModelException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getJavadoc());
        buffer.append("    public String toString()\n    {\n        return new ToStringBuilder(this");
        if (CCPluginPreferences.getPreferences().useCustomToStringStyle()) {
            buffer.append(", ");
            buffer.append(CCPluginPreferences.getPreferences().getToStringStyleClassAndConstant());
        }
        buffer.append(")\n");
        if (CCPluginPreferences.getPreferences().appendSuperToToString()) {
            buffer.append(".appendSuper(super.toString())\n");
        }
        if (CCPluginPreferences.getPreferences().useJavabeanToString()) {
            buffer.append(this.buildAppenderListFromBean(type));
        } else {
            buffer.append(this.buildAppenderList(type));
        }
        buffer.append(".toString();\n}");
        return buffer.toString();
    }

    private String buildAppenderListFromBean(IType type) throws JavaModelException {
        Map getterMethods = this.buildMethodsMap(type);
        Map fields = this.buildFieldMap(type);
        Iterator iterator = getterMethods.entrySet().iterator();
        StringBuffer buffer = new StringBuffer();
        while (iterator.hasNext()) {
            IMethod method = (IMethod)iterator.next().getValue();
            String methodName = method.getElementName();
            String propertyName = this.getJavabeanProperyName(methodName);
            if (this.isExcluded(propertyName)) continue;
            IField matchingField = (IField)fields.get(propertyName);
            if (matchingField != null && propertyName.equals(matchingField.getElementName())) {
                buffer.append(this.getFieldAppender(propertyName, propertyName));
                continue;
            }
            buffer.append(this.getFieldAppender(propertyName, methodName + "()"));
        }
        return buffer.toString();
    }

    private Map buildMethodsMap(IType type) throws JavaModelException {
        HashMap<String, IMethod> getterMethods = new HashMap<String, IMethod>();
        ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
        IType[] types = hierarchy.getAllClasses();
        for (int j = 0; j < types.length; ++j) {
            IMethod[] superMethods = types[j].getMethods();
            for (int x = 0; x < superMethods.length; ++x) {
                IMethod method = superMethods[x];
                if (!this.isJavabeanGetter(method)) continue;
                getterMethods.put(method.getElementName(), method);
            }
        }
        return getterMethods;
    }

    private String getJavabeanProperyName(String methodName) {
        String propertyName = methodName.startsWith("get") ? methodName.substring(3, methodName.length()) : methodName.substring(2, methodName.length());
        if (propertyName.length() > 1 && Character.isLowerCase(propertyName.charAt(1))) {
            propertyName = Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1, propertyName.length());
        } else if (propertyName.length() == 1) {
            propertyName = propertyName.toLowerCase();
        }
        return propertyName;
    }

    private boolean isJavabeanGetter(IMethod method) throws JavaModelException {
        if (method.getNumberOfParameters() == 0 && Flags.isPublic((int)method.getFlags())) {
            String methodName = method.getElementName();
            if (methodName.length() > 3 && methodName.startsWith("get")) {
                return true;
            }
            if (methodName.length() > 2 && methodName.startsWith("is") && ("Z".equals(method.getReturnType()) || "QBoolean;".equals(method.getReturnType()))) {
                return true;
            }
        }
        return false;
    }

    private String getJavadoc() {
        return "/**\n * @see java.lang.Object#toString()\n */\n";
    }

    protected IMethod getExistingMethod(IType type) {
        return type.getMethod(this.getMethodName(), new String[0]);
    }

    protected String getFieldAppender(String fieldName, String accessor) {
        return ".append(\"" + fieldName + "\", this." + accessor + ")\n";
    }
}

