/*
 * Decompiled with CFR 0.152.
 */
package net.sf.commonclipse;

import net.sf.commonclipse.CCPluginPreferences;
import net.sf.commonclipse.Generator;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;

public final class CompareToGenerator
extends Generator {
    private static final String BUILDER_CLASS = "org.apache.commons.lang.builder.CompareToBuilder";
    private static Generator instance = new CompareToGenerator();

    private CompareToGenerator() {
    }

    public static Generator getInstance() {
        return instance;
    }

    protected String getMethodName() {
        return "compareTo";
    }

    protected String createMethod(IType type) throws JavaModelException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getJavadoc());
        String className = type.getElementName();
        buffer.append("public int compareTo(");
        if (CCPluginPreferences.getPreferences().useFinalParameters()) {
            buffer.append("final ");
        }
        buffer.append("Object object) {\n");
        buffer.append(className);
        buffer.append(" myClass = (");
        buffer.append(className);
        buffer.append(") object;\nreturn new CompareToBuilder()\n");
        if (CCPluginPreferences.getPreferences().appendSuperToCompareTo() && this.doesSuperImplementsComparable(type)) {
            buffer.append(".appendSuper(super.compareTo(object))\n");
        }
        buffer.append(this.buildAppenderList(type));
        buffer.append(".toComparison();\n}\n");
        return buffer.toString();
    }

    private boolean doesSuperImplementsComparable(IType type) throws JavaModelException {
        ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
        IType superTypes = hierarchy.getSuperclass(type);
        IType[] interfaces = hierarchy.getSuperInterfaces(superTypes);
        for (int j = 0; j < interfaces.length; ++j) {
            if (!interfaces[j].getFullyQualifiedName().equals("java.lang.Comparable")) continue;
            return true;
        }
        return false;
    }

    protected String getFieldAppender(String fieldName, String accessor) {
        return ".append(this." + fieldName + ", myClass." + fieldName + ")\n";
    }

    protected IMethod getExistingMethod(IType type) {
        return type.getMethod(this.getMethodName(), new String[]{"QObject;"});
    }

    protected void addImports(IType type) throws JavaModelException {
        type.getCompilationUnit().createImport(BUILDER_CLASS, null, null);
        this.addImplementsComparable(type);
    }

    private void addImplementsComparable(IType type) throws JavaModelException {
        IType[] interfaces = type.newSupertypeHierarchy(null).getAllInterfaces();
        int size = interfaces.length;
        for (int j = 0; j < size; ++j) {
            if (!interfaces[j].getFullyQualifiedName().equals("java.lang.Comparable")) continue;
            return;
        }
        ISourceRange nameRange = type.getNameRange();
        if (nameRange == null) {
            return;
        }
        int offset = nameRange.getOffset() + nameRange.getLength();
        IBuffer buffer = type.getCompilationUnit().getBuffer();
        String contents = buffer.getText(offset, buffer.getLength() - offset);
        int indexOfPar = contents.indexOf("{");
        int indexOfImplements = (contents = contents.substring(0, indexOfPar)).indexOf("implements");
        if (indexOfImplements > -1) {
            buffer.replace(offset + indexOfImplements + "implements".length(), 0, " Comparable,");
        } else {
            buffer.replace(offset, 0, " implements Comparable");
        }
        buffer.save(null, false);
        buffer.close();
    }

    private String getJavadoc() {
        return "/**\n * @see java.lang.Comparable#compareTo(Object)\n */\n";
    }
}

