/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.util;

import java.util.ArrayList;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XSDDOMHelper {
    public static final int LENGTH_FACET = 1;
    public static final int MIN_LENGTH_FACET = 2;
    public static final int MAX_LENGTH_FACET = 3;
    public static final int PATTERN_FACET = 4;
    public static final int ENUM_FACET = 5;
    public static final int WHITE_SPACE_FACET = 6;
    public static final int MAX_INCLUSIVE_FACET = 7;
    public static final int MAX_EXCLUSIVE_FACET = 8;
    public static final int MIN_INCLUSIVE_FACET = 9;
    public static final int MIN_EXCLUSIVE_FACET = 10;
    public static final int TOTAL_DIGITS_FACET = 11;
    public static final int FRACTION_DIGITS_FACET = 12;
    public static final int N_FACETS = 13;
    public static String[][] dataType = new String[][]{{"anySimpleType", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y"}, {"anyType", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y"}, {"anyURI", "Y", "Y", "Y", "Y", "Y", "Y", "N", "N", "N", "N", "N", "N"}, {"base64Binary", "Y", "Y", "Y", "Y", "Y", "Y", "N", "N", "N", "N", "N", "N"}, {"boolean", "N", "N", "N", "Y", "N", "Y", "N", "N", "N", "N", "N", "N"}, {"byte", "N", "N", "N", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y"}, {"date", "N", "N", "N", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "N", "N"}, {"dateTime", "N", "N", "N", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "N", "N"}, {"decimal", "N", "N", "N", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y"}, {"double", "N", "N", "N", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "N", "N"}, {"duration", "N", "N", "N", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "N", "N"}, {"ENTITY", "Y", "Y", "Y", "Y", "Y", "Y", "N", "N", "N", "N", "N", "N"}, {"ENTITIES", "Y", "Y", "Y", "N", "Y", "Y", "N", "N", "N", "N", "N", "N"}, {"float", "N", "N", "N", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "N", "N"}, {"gDay", "N", "N", "N", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "N", "N"}, {"gMonth", "N", "N", "N", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "N", "N"}, {"gMonthDay", "N", "N", "N", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "N", "N"}, {"gYear", "N", "N", "N", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "N", "N"}, {"gYearMonth", "N", "N", "N", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "N", "N"}, {"hexBinary", "Y", "Y", "Y", "Y", "Y", "Y", "N", "N", "N", "N", "N", "N"}, {"ID", "Y", "Y", "Y", "Y", "Y", "Y", "N", "N", "N", "N", "N", "N"}, {"IDREF", "Y", "Y", "Y", "Y", "Y", "Y", "N", "N", "N", "N", "N", "N"}, {"IDREFS", "Y", "Y", "Y", "N", "Y", "Y", "N", "N", "N", "N", "N", "N"}, {"int", "N", "N", "N", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y"}, {"integer", "N", "N", "N", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y"}, {"language", "Y", "Y", "Y", "Y", "Y", "Y", "N", "N", "N", "N", "N", "N"}, {"long", "N", "N", "N", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y"}, {"Name", "Y", "Y", "Y", "Y", "Y", "Y", "N", "N", "N", "N", "N", "N"}, {"NCName", "Y", "Y", "Y", "Y", "Y", "Y", "N", "N", "N", "N", "N", "N"}, {"negativeInteger", "N", "N", "N", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y"}, {"NMTOKEN", "Y", "Y", "Y", "Y", "Y", "Y", "N", "N", "N", "N", "N", "N"}, {"NMTOKENS", "Y", "Y", "Y", "N", "Y", "Y", "N", "N", "N", "N", "N", "N"}, {"nonNegativeInteger", "N", "N", "N", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y"}, {"nonPositiveInteger", "N", "N", "N", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y"}, {"normalizedString", "Y", "Y", "Y", "Y", "Y", "Y", "N", "N", "N", "N", "N", "N"}, {"NOTATION", "Y", "Y", "Y", "Y", "Y", "Y", "N", "N", "N", "N", "N", "N"}, {"positiveInteger", "N", "N", "N", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y"}, {"QName", "N", "N", "N", "Y", "Y", "Y", "N", "N", "N", "N", "N", "N"}, {"short", "N", "N", "N", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y"}, {"string", "Y", "Y", "Y", "Y", "Y", "Y", "N", "N", "N", "N", "N", "N"}, {"time", "N", "N", "N", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "N", "N"}, {"token", "Y", "Y", "Y", "Y", "Y", "Y", "N", "N", "N", "N", "N", "N"}, {"unsignedByte", "N", "N", "N", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y"}, {"unsignedInt", "N", "N", "N", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y"}, {"unsignedLong", "N", "N", "N", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y"}, {"unsignedShort", "N", "N", "N", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y"}};
    public static String XMLSchemaURI = "http://www.w3.org/2001/XMLSchema";
    public static String SIMPLE_TYPE = "Simple";
    public static String USER_SIMPLE_TYPE = "simpleType";
    public static String USER_COMPLEX_TYPE = "complexType";

    public Node getChildNode(Element parent, String childName) {
        NodeList list = null;
        if (parent != null) {
            list = parent.getChildNodes();
        }
        if (list != null) {
            int i = 0;
            while (i < list.getLength()) {
                if (list.item(i) instanceof Element && list.item(i).getLocalName().equals(childName)) {
                    return list.item(i);
                }
                ++i;
            }
        }
        return null;
    }

    public void removeDerivedByElement(Element element) {
        this.removeChild(element, "restriction");
        this.removeChild(element, "extension");
    }

    public String getBaseType(Element element) {
        Node restrictionChild = this.getChildNode(element, "restriction");
        Node extensionChild = this.getChildNode(element, "extension");
        String baseType = "";
        if (restrictionChild != null) {
            if (restrictionChild instanceof Element) {
                baseType = ((Element)restrictionChild).getAttribute("base");
            }
        } else if (extensionChild != null && extensionChild instanceof Element) {
            baseType = ((Element)extensionChild).getAttribute("base");
        }
        return baseType;
    }

    public void setDerivedByBaseType(Element element, String derivedByType, String type) {
        Document doc = element.getOwnerDocument();
        Element derivedByElement = this.getDerivedByElement(element);
        if (derivedByElement != null) {
            derivedByElement.setAttribute("base", type);
        } else {
            Element newElement = doc.createElement(derivedByType);
            newElement.setAttribute("base", type);
            element.appendChild(newElement);
        }
    }

    public void changeDerivedByType(Element element, String derivedByType, String type) {
        Document doc = element.getOwnerDocument();
        String prefix = element.getPrefix();
        prefix = prefix == null ? "" : String.valueOf(prefix) + ":";
        Element derivedByElement = this.getDerivedByElement(element);
        if (derivedByElement != null && derivedByElement.getLocalName().equals(derivedByType)) {
            return;
        }
        Element newNode = derivedByType.equals("restriction") ? doc.createElementNS(XMLSchemaURI, String.valueOf(prefix) + "restriction") : doc.createElementNS(XMLSchemaURI, String.valueOf(prefix) + "extension");
        newNode.setAttribute("base", type);
        if (derivedByElement != null) {
            if (derivedByElement.hasChildNodes()) {
                NodeList nodes = derivedByElement.getChildNodes();
                int i = 0;
                while (i < nodes.getLength()) {
                    Node node = nodes.item(i);
                    newNode.appendChild(node.cloneNode(true));
                    ++i;
                }
            }
            element.replaceChild(newNode, derivedByElement);
        } else {
            Node node;
            Element parent = (Element)element.getParentNode();
            NodeList nodes = parent.getChildNodes();
            ArrayList<Node> nodeSaveList = new ArrayList<Node>();
            int i = 0;
            while (i < nodes.getLength()) {
                node = nodes.item(i);
                nodeSaveList.add(node);
                ++i;
            }
            i = 0;
            while (i < nodeSaveList.size()) {
                node = (Node)nodeSaveList.get(i);
                parent.removeChild(node);
                ++i;
            }
            Element complexContent = doc.createElementNS(XMLSchemaURI, String.valueOf(prefix) + "complexContent");
            parent.appendChild(complexContent);
            complexContent.appendChild(newNode);
            int i2 = 0;
            while (i2 < nodeSaveList.size()) {
                Node node2 = (Node)nodeSaveList.get(i2);
                newNode.appendChild(node2.cloneNode(true));
                ++i2;
            }
            parent.appendChild(complexContent);
            XSDDOMHelper.formatChild(complexContent);
        }
    }

    public void setSimpleContentType(Element element, String type) {
        String contentTypeName = element.getLocalName();
        if (contentTypeName.equals("union")) {
            element.setAttribute("memberTypes", type);
        } else if (contentTypeName.equals("list")) {
            element.setAttribute("itemType", type);
        } else if (contentTypeName.equals("restriction")) {
            element.setAttribute("base", type);
        }
    }

    public void removeSimpleTypeContent(Element element) {
        String contentTypeName = element.getLocalName();
        if (contentTypeName.equals("union")) {
            element.removeAttribute("memberTypes");
        } else if (contentTypeName.equals("list")) {
            element.removeAttribute("itemType");
        } else if (contentTypeName.equals("restriction")) {
            element.removeAttribute("base");
        }
    }

    public String getDerivedByName(Element element) {
        Node restrictionChild = this.getChildNode(element, "restriction");
        Node extensionChild = this.getChildNode(element, "extension");
        if (restrictionChild != null) {
            return "restriction";
        }
        if (extensionChild != null) {
            return "extension";
        }
        return "";
    }

    public Element getDerivedByElement(Element element) {
        Node restrictionChild = this.getChildNode(element, "restriction");
        Node extensionChild = this.getChildNode(element, "extension");
        if (restrictionChild != null && restrictionChild instanceof Element) {
            return (Element)restrictionChild;
        }
        if (extensionChild != null && extensionChild instanceof Element) {
            return (Element)extensionChild;
        }
        return null;
    }

    public Element getDerivedByElementFromComplexType(Element element) {
        NodeList nl = element.getChildNodes();
        int j = 0;
        j = 0;
        while (j < nl.getLength()) {
            Node aNode = nl.item(j);
            if (XSDDOMHelper.inputEquals(aNode, "complexContent", false) || XSDDOMHelper.inputEquals(aNode, "simpleContent", false)) break;
            ++j;
        }
        Element derivedByNode = this.getDerivedByElement((Element)nl.item(j));
        return derivedByNode;
    }

    public Element getContentModelFromParent(Element element) {
        NodeList nl = element.getChildNodes();
        int j = 0;
        boolean modelExists = false;
        int length = nl.getLength();
        j = 0;
        while (j < length) {
            Node aNode = nl.item(j);
            if (XSDDOMHelper.inputEquals(aNode, "complexContent", false)) {
                modelExists = true;
                break;
            }
            if (XSDDOMHelper.inputEquals(aNode, "simpleContent", false)) {
                modelExists = true;
                break;
            }
            if (XSDDOMHelper.inputEquals(aNode, "sequence", false)) {
                modelExists = true;
                break;
            }
            if (XSDDOMHelper.inputEquals(aNode, "choice", false)) {
                modelExists = true;
                break;
            }
            if (XSDDOMHelper.inputEquals(aNode, "all", false)) {
                modelExists = true;
                break;
            }
            ++j;
        }
        if (!modelExists) {
            return null;
        }
        Element derivedByNode = (Element)nl.item(j);
        return derivedByNode;
    }

    public void changeContentModel(Element complexTypeElement, String contentModel, Element sequenceChoiceOrAllElement) {
        Document doc = complexTypeElement.getOwnerDocument();
        String prefix = complexTypeElement.getPrefix();
        prefix = prefix == null ? "" : String.valueOf(prefix) + ":";
        Element contentModelElement = this.getContentModelFromParent(complexTypeElement);
        if (contentModelElement.getLocalName().equals(contentModel)) {
            return;
        }
        Element newNode = doc.createElementNS(XMLSchemaURI, String.valueOf(prefix) + contentModel);
        if (contentModelElement.hasChildNodes()) {
            NodeList nodes = contentModelElement.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                if (node instanceof Element) {
                    if (node.getLocalName().equals("annotation")) {
                        if (!(XSDDOMHelper.inputEquals(contentModelElement, "sequence", false) || XSDDOMHelper.inputEquals(contentModelElement, "choice", false) || XSDDOMHelper.inputEquals(contentModelElement, "all", false))) {
                            newNode.appendChild(node.cloneNode(true));
                        }
                    } else if (node.getLocalName().equals("restriction") || node.getLocalName().equals("extension")) {
                        newNode.appendChild(node.cloneNode(true));
                        if (sequenceChoiceOrAllElement != null) {
                            node.appendChild(sequenceChoiceOrAllElement);
                        }
                    } else {
                        XSDDOMHelper.removeNodeAndWhitespace(node);
                    }
                } else {
                    newNode.appendChild(node.cloneNode(true));
                }
                ++i;
            }
        }
        complexTypeElement.replaceChild(newNode, contentModelElement);
    }

    public Element cloneElement(Element parent, Element sourceNode) {
        Document doc = parent.getOwnerDocument();
        String prefix = parent.getPrefix();
        prefix = prefix == null ? "" : String.valueOf(prefix) + ":";
        Element newNode = doc.createElementNS(XMLSchemaURI, String.valueOf(prefix) + sourceNode.getLocalName());
        if (sourceNode.hasChildNodes()) {
            NodeList nodes = sourceNode.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                newNode.appendChild(node.cloneNode(true));
                ++i;
            }
        }
        return newNode;
    }

    public boolean hasElementChildren(Element parentNode) {
        boolean hasChildrenElements = false;
        if (parentNode != null && parentNode.hasChildNodes()) {
            NodeList nodes = parentNode.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                if (nodes.item(i) instanceof Element) {
                    hasChildrenElements = true;
                    break;
                }
                ++i;
            }
        }
        return hasChildrenElements;
    }

    public void removeChild(Element node, String childName) {
        Node child = this.getChildNode(node, childName);
        if (child != null) {
            node.removeChild(child);
        }
    }

    public static boolean isFacet(Object obj) {
        return XSDDOMHelper.inputEquals(obj, "length", false) || XSDDOMHelper.inputEquals(obj, "minLength", false) || XSDDOMHelper.inputEquals(obj, "maxLength", false) || XSDDOMHelper.inputEquals(obj, "whiteSpace", false) || XSDDOMHelper.inputEquals(obj, "maxInclusive", false) || XSDDOMHelper.inputEquals(obj, "maxExclusive", false) || XSDDOMHelper.inputEquals(obj, "minInclusive", false) || XSDDOMHelper.inputEquals(obj, "minExclusive", false) || XSDDOMHelper.inputEquals(obj, "totalDigits", false) || XSDDOMHelper.inputEquals(obj, "fractionDigits", false);
    }

    public static void removeNodeAndWhitespace(Node node) {
        Node parentNode = node.getParentNode();
        Node nextElement = XSDDOMHelper.getNextElementNode(node);
        Node previousElement = XSDDOMHelper.getPreviousElementNode(node);
        Node nextSibling = node.getNextSibling();
        if (nextSibling instanceof Text) {
            parentNode.removeChild(nextSibling);
        }
        node.getPreviousSibling();
        if (parentNode != null) {
            parentNode.removeChild(node);
        }
        if (nextElement != null) {
            XSDDOMHelper.formatChild(nextElement);
        }
        if (previousElement != null) {
            XSDDOMHelper.formatChild(previousElement);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void formatChild(Node child) {
        if (!(child instanceof IDOMNode)) return;
        IDOMModel model = ((IDOMNode)child).getModel();
        try {
            model.aboutToChangeModel();
            FormatProcessorXML formatProcessor = new FormatProcessorXML();
            formatProcessor.formatNode(child);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            model.changedModel();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        model.changedModel();
    }

    public static Node getLastElementNode(Node parent) {
        Node lastChild = parent.getLastChild();
        while (!(lastChild instanceof Element) && lastChild != null) {
            lastChild = lastChild.getPreviousSibling();
        }
        return lastChild;
    }

    public static Node getNextElementNode(Node node) {
        Node next = node.getNextSibling();
        while (!(next instanceof Element) && next != null) {
            next = next.getNextSibling();
        }
        if (next instanceof Text) {
            return null;
        }
        return next;
    }

    public static Node getPreviousElementNode(Node node) {
        Node previous = node.getPreviousSibling();
        while (!(previous instanceof Element) && previous != null) {
            previous = previous.getPreviousSibling();
        }
        if (previous instanceof Text) {
            return null;
        }
        return previous;
    }

    public static void moveNode(Node referenceNode, Node nodeToMove, boolean isBefore) {
        Node parent = referenceNode.getParentNode();
        String referenceNodeNextString = "";
        String referenceNodePreviousString = "";
        if (referenceNode != null) {
            Node referenceNodeNextSibling = referenceNode.getNextSibling();
            Node referenceNodePreviousSibling = referenceNode.getPreviousSibling();
            if (referenceNodeNextSibling instanceof Text) {
                referenceNodeNextString = ((Text)referenceNodeNextSibling).getData();
            }
            if (referenceNodePreviousSibling instanceof Text) {
                referenceNodePreviousString = ((Text)referenceNodePreviousSibling).getData();
            }
        }
        Node nodeToMoveNextSibling = nodeToMove.getNextSibling();
        Node nodeToMovePreviousSibling = nodeToMove.getPreviousSibling();
        Text nodeToMoveNextText = null;
        String nodeToMoveNextString = "";
        String nodeToMovePreviousString = "";
        if (nodeToMoveNextSibling instanceof Text) {
            nodeToMoveNextText = (Text)nodeToMoveNextSibling;
            nodeToMoveNextString = ((Text)nodeToMoveNextSibling).getData();
        }
        if (nodeToMovePreviousSibling instanceof Text) {
            nodeToMovePreviousString = ((Text)nodeToMovePreviousSibling).getData();
        }
        Node lastElement = XSDDOMHelper.getLastElementNode(parent);
        Node lastElementNextSibling = lastElement.getNextSibling();
        Node lastElementPreviousSibling = lastElement.getPreviousSibling();
        String lastElementNextString = "";
        String lastElementPreviousString = "";
        if (lastElementNextSibling instanceof Text) {
            lastElementNextString = ((Text)lastElementNextSibling).getData();
        }
        if (lastElementPreviousSibling instanceof Text) {
            lastElementPreviousString = ((Text)lastElementPreviousSibling).getData();
        }
        boolean isLastElement = false;
        if (lastElement == nodeToMove) {
            isLastElement = true;
        }
        if (referenceNode != nodeToMove) {
            parent.removeChild(nodeToMove);
            if (referenceNode != null && !isBefore) {
                referenceNode = XSDDOMHelper.getNextElementNode(referenceNode);
            }
            if (referenceNode != null) {
                XSDDOMHelper.insertBefore(nodeToMove, referenceNode);
            } else {
                parent.appendChild(nodeToMove);
            }
            Node newLastElement = XSDDOMHelper.getLastElementNode(parent);
            if (referenceNode != null) {
                if (referenceNode != newLastElement && !isLastElement) {
                    XSDDOMHelper.setTextData(referenceNode, nodeToMoveNextString, nodeToMovePreviousString);
                }
                XSDDOMHelper.setTextData(nodeToMove, referenceNodeNextString, referenceNodePreviousString);
            }
            if (nodeToMoveNextText != null) {
                parent.removeChild(nodeToMoveNextText);
            }
            if (newLastElement == nodeToMove || isLastElement) {
                XSDDOMHelper.setTextData(newLastElement, lastElementNextString, lastElementPreviousString);
            }
        }
    }

    public static void setTextData(Node target, String nextText, String previousText) {
        Text textNode;
        Node parent = target.getParentNode();
        Node nextSibling = target.getNextSibling();
        Node previousSibling = target.getPreviousSibling();
        if (nextSibling instanceof Text) {
            ((Text)nextSibling).setData(nextText);
        }
        if (nextSibling == null || nextSibling instanceof Element) {
            textNode = parent.getOwnerDocument().createTextNode("");
            textNode.setData(nextText);
            if (nextSibling != null) {
                parent.insertBefore(textNode, nextSibling);
            } else {
                parent.insertBefore(textNode, XSDDOMHelper.getNextElementNode(target));
            }
        }
        if (previousSibling instanceof Text) {
            ((Text)previousSibling).setData(previousText);
        }
        if (previousSibling == null || previousSibling instanceof Element) {
            textNode = parent.getOwnerDocument().createTextNode("");
            textNode.setData(previousText);
            parent.insertBefore(textNode, target);
        }
    }

    public static void insertBefore(Node nodeToInsert, Node referenceNode) {
        Node parent = referenceNode.getParentNode();
        referenceNode.getPreviousSibling();
        parent.insertBefore(nodeToInsert, referenceNode);
    }

    public static boolean inputEquals(Object input, String tagname, boolean isRef) {
        Element element;
        if (input instanceof Element && (element = (Element)input).getLocalName().equals(tagname)) {
            boolean refPresent = element.hasAttribute("ref");
            return refPresent == isRef;
        }
        return false;
    }

    public static void updateElementToNotAnonymous(Element element) {
        NodeList children;
        if (element != null && (children = element.getChildNodes()) != null) {
            int i = 0;
            while (i < children.getLength()) {
                Node node = children.item(i);
                if (node instanceof Element && (node.getLocalName().equals("simpleType") || node.getLocalName().equals("complexType"))) {
                    XSDDOMHelper.removeNodeAndWhitespace(node);
                    i = 0;
                }
                ++i;
            }
        }
    }

    public static boolean isAttributeRef(Element ct, String attrName, String ns) {
        NodeList list = ct.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            String refValue;
            Element aChild;
            if (list.item(i) instanceof Element && (aChild = (Element)list.item(i)).getLocalName().equals("attribute") && aChild.hasAttribute("ref") && (refValue = aChild.getAttribute("ref")).equals(attrName)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

