/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.rename;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xsd.ui.internal.refactor.XSDVisitor;
import org.eclipse.wst.xsd.ui.internal.util.XSDDOMHelper;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SchemaPrefixChangeHandler {
    String newPrefix;
    XSDSchema xsdSchema;

    public SchemaPrefixChangeHandler(XSDSchema xsdSchema, String newPrefix) {
        this.xsdSchema = xsdSchema;
        this.newPrefix = newPrefix;
    }

    public void resolve() {
        XSDSchemaPrefixRenamer xsdSchemaPrefixRenamer = new XSDSchemaPrefixRenamer();
        xsdSchemaPrefixRenamer.visitSchema(this.xsdSchema);
    }

    public String getNewQName(XSDTypeDefinition comp, String value, String newXSDPrefix) {
        String qName = null;
        qName = value != null ? ((qName = newXSDPrefix) != null && qName.length() > 0 ? String.valueOf(qName) + ":" + value : value) : value;
        return qName;
    }

    class XSDSchemaPrefixRenamer
    extends XSDVisitor {
        public void visitElementDeclaration(XSDElementDeclaration element) {
            super.visitElementDeclaration(element);
            XSDTypeDefinition type = element.getType();
            if (type != null) {
                Attr typeAttr;
                Element domElement;
                String ns = type.getTargetNamespace();
                if (ns == null) {
                    ns = "";
                }
                if (ns.equals("http://www.w3.org/2001/XMLSchema") && (domElement = element.getElement()) != null && domElement instanceof IDOMNode && (typeAttr = domElement.getAttributeNode("type")) != null) {
                    element.getElement().setAttribute("type", SchemaPrefixChangeHandler.this.getNewQName(type, type.getName(), SchemaPrefixChangeHandler.this.newPrefix));
                }
            }
        }

        public void visitSimpleTypeDefinition(XSDSimpleTypeDefinition simpleType) {
            Element unionElement;
            Node unionNode;
            EList memberTypes;
            XSDDOMHelper domHelper;
            XSDSimpleTypeDefinition itemType;
            super.visitSimpleTypeDefinition(simpleType);
            XSDSimpleTypeDefinition baseType = simpleType.getBaseTypeDefinition();
            if (baseType != null) {
                Attr typeAttr;
                XSDDOMHelper domHelper2;
                Element derivedBy;
                String ns = baseType.getTargetNamespace();
                if (ns == null) {
                    ns = "";
                }
                if (ns.equals("http://www.w3.org/2001/XMLSchema") && (derivedBy = (domHelper2 = new XSDDOMHelper()).getDerivedByElement(simpleType.getElement())) != null && derivedBy instanceof IDOMNode && (typeAttr = derivedBy.getAttributeNode("base")) != null) {
                    derivedBy.setAttribute("base", SchemaPrefixChangeHandler.this.getNewQName((XSDTypeDefinition)baseType, baseType.getName(), SchemaPrefixChangeHandler.this.newPrefix));
                }
            }
            if ((itemType = simpleType.getItemTypeDefinition()) != null) {
                Attr typeAttr;
                Element listElement;
                Node listNode;
                String ns = itemType.getTargetNamespace();
                if (ns == null) {
                    ns = "";
                }
                if (ns.equals("http://www.w3.org/2001/XMLSchema") && (listNode = (domHelper = new XSDDOMHelper()).getChildNode(simpleType.getElement(), "list")) != null && listNode instanceof Element && (listElement = (Element)listNode) instanceof IDOMNode && (typeAttr = listElement.getAttributeNode("itemType")) != null) {
                    listElement.setAttribute("itemType", SchemaPrefixChangeHandler.this.getNewQName((XSDTypeDefinition)itemType, itemType.getName(), SchemaPrefixChangeHandler.this.newPrefix));
                }
            }
            if ((memberTypes = simpleType.getMemberTypeDefinitions()).size() > 0 && (unionNode = (domHelper = new XSDDOMHelper()).getChildNode(simpleType.getElement(), "union")) != null && unionNode instanceof Element && (unionElement = (Element)unionNode) instanceof IDOMNode) {
                unionElement.getAttributeNode("memberTypes");
                StringBuffer sb = new StringBuffer("");
                Iterator i = memberTypes.iterator();
                while (i.hasNext()) {
                    XSDSimpleTypeDefinition st = (XSDSimpleTypeDefinition)i.next();
                    String ns = st.getTargetNamespace();
                    if (ns == null) {
                        ns = "";
                    }
                    if (ns.equals("http://www.w3.org/2001/XMLSchema")) {
                        sb.append(SchemaPrefixChangeHandler.this.getNewQName((XSDTypeDefinition)st, st.getName(), SchemaPrefixChangeHandler.this.newPrefix));
                    } else {
                        sb.append(st.getQName((XSDConcreteComponent)SchemaPrefixChangeHandler.this.xsdSchema));
                    }
                    if (!i.hasNext()) continue;
                    sb.append(" ");
                }
                unionElement.setAttribute("memberTypes", sb.toString());
            }
        }

        public void visitAttributeDeclaration(XSDAttributeDeclaration attr) {
            super.visitAttributeDeclaration(attr);
            XSDTypeDefinition type = attr.getType();
            if (type != null) {
                Attr typeAttr;
                Element domElement;
                String ns = type.getTargetNamespace();
                if (ns == null) {
                    ns = "";
                }
                if (ns.equals("http://www.w3.org/2001/XMLSchema") && (domElement = attr.getElement()) != null && domElement instanceof IDOMNode && (typeAttr = domElement.getAttributeNode("type")) != null) {
                    attr.getElement().setAttribute("type", SchemaPrefixChangeHandler.this.getNewQName(type, type.getName(), SchemaPrefixChangeHandler.this.newPrefix));
                }
            }
        }
    }
}

