/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.actions;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.ui.actions.GlobalBuildAction;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.refactor.RefactoringMessages;
import org.eclipse.wst.xsd.ui.internal.refactor.actions.SelectionDispatchAction;
import org.eclipse.wst.xsd.ui.internal.refactor.rename.RenameComponentProcessor;
import org.eclipse.wst.xsd.ui.internal.refactor.rename.RenameRefactoringWizard;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Node;

public class RenameComponentAction
extends SelectionDispatchAction {
    private XSDNamedComponent fSelectedComponent;

    public RenameComponentAction(ISelectionProvider selectionProvider, XSDSchema schema) {
        super(selectionProvider);
        this.setSchema(schema);
    }

    protected boolean canEnable(XSDConcreteComponent selectedObject) {
        this.fSelectedComponent = null;
        if (selectedObject instanceof XSDNamedComponent) {
            XSDElementDeclaration element;
            this.fSelectedComponent = (XSDNamedComponent)selectedObject;
            if (this.fSelectedComponent instanceof XSDElementDeclaration && (element = (XSDElementDeclaration)this.fSelectedComponent).isElementDeclarationReference()) {
                this.fSelectedComponent = null;
            }
            if (this.fSelectedComponent instanceof XSDTypeDefinition) {
                XSDAttributeDeclaration element2;
                XSDTypeDefinition type = (XSDTypeDefinition)this.fSelectedComponent;
                XSDConcreteComponent parent = type.getContainer();
                if (parent instanceof XSDElementDeclaration) {
                    XSDElementDeclaration element3 = (XSDElementDeclaration)parent;
                    if (element3.getAnonymousTypeDefinition().equals(type)) {
                        this.fSelectedComponent = null;
                    }
                } else if (parent instanceof XSDAttributeDeclaration && (element2 = (XSDAttributeDeclaration)parent).getAnonymousTypeDefinition().equals(type)) {
                    this.fSelectedComponent = null;
                }
            }
        }
        return this.canRun();
    }

    protected boolean canEnable(Object selectedObject) {
        if (selectedObject instanceof XSDConcreteComponent) {
            return this.canEnable((XSDConcreteComponent)selectedObject);
        }
        if (selectedObject instanceof Node) {
            Node node = (Node)selectedObject;
            if (this.getSchema() != null) {
                XSDConcreteComponent concreteComponent = this.getSchema().getCorrespondingComponent(node);
                return this.canEnable(concreteComponent);
            }
        }
        return false;
    }

    public boolean canRun() {
        return this.fSelectedComponent != null;
    }

    public void run(ISelection selection) {
        if (this.fSelectedComponent.getName() == null) {
            this.fSelectedComponent.setName(new String());
        }
        if (this.fSelectedComponent.getSchema() == null && this.getSchema() != null) {
            this.getSchema().updateElement(true);
        }
        RenameComponentProcessor processor = new RenameComponentProcessor(this.fSelectedComponent, this.fSelectedComponent.getName());
        RenameRefactoring refactoring = new RenameRefactoring((RenameProcessor)processor);
        try {
            RenameRefactoringWizard wizard = new RenameRefactoringWizard((Refactoring)refactoring, RefactoringMessages.getString("RenameComponentWizard.defaultPageTitle"), RefactoringMessages.getString("RenameComponentWizard.inputPage.description"), null);
            RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
            op.run(XSDEditorPlugin.getShell(), wizard.getDefaultPageTitle());
            op.getInitialConditionCheckingStatus();
            RenameComponentAction.triggerBuild();
        }
        catch (InterruptedException interruptedException) {}
    }

    public static void triggerBuild() {
        if (ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding()) {
            new GlobalBuildAction(XSDEditorPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow(), 10).run();
        }
    }
}

