/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties.section;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wst.common.ui.properties.internal.provisional.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.properties.section.AbstractSection;
import org.eclipse.wst.xsd.ui.internal.properties.section.SimpleContentUnionMemberTypesDialog;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.w3c.dom.Element;

public class SimpleTypeUnionSection
extends AbstractSection {
    Text memberTypesText;
    Button button;

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.memberTypesText = this.getWidgetFactory().createText(this.composite, "");
        CLabel label = this.getWidgetFactory().createCLabel(this.composite, XSDEditorPlugin.getXSDString("_UI_LABEL_MEMBERTYPES"));
        this.button = this.getWidgetFactory().createButton(this.composite, "...", 8);
        this.memberTypesText.addListener(24, (Listener)this);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 100);
        data.right = new FormAttachment(95, 0);
        data.top = new FormAttachment((Control)this.button, 0, 0x1000000);
        this.memberTypesText.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.memberTypesText, -5);
        data.top = new FormAttachment((Control)this.button, 0, 0x1000000);
        label.setLayoutData((Object)data);
        this.button.addSelectionListener((SelectionListener)this);
        data = new FormData();
        data.left = new FormAttachment((Control)this.memberTypesText, 5);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        this.button.setLayoutData((Object)data);
    }

    public void refresh() {
        this.setListenerEnabled(false);
        Object input = this.getInput();
        if (this.isReadOnly) {
            this.composite.setEnabled(false);
        } else {
            this.composite.setEnabled(true);
        }
        this.memberTypesText.setText("");
        if (input != null) {
            XSDSimpleTypeDefinition st;
            Element unionElement;
            String memberTypes;
            Element element = null;
            if (input instanceof XSDSimpleTypeDefinition && (memberTypes = (unionElement = (Element)this.domHelper.getChildNode(element = (st = (XSDSimpleTypeDefinition)input).getElement(), "union")).getAttribute("memberTypes")) != null) {
                this.memberTypesText.setText(memberTypes);
            }
        }
        this.setListenerEnabled(true);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.button) {
            Shell shell = Display.getCurrent().getActiveShell();
            XSDSimpleTypeDefinition st = (XSDSimpleTypeDefinition)this.getInput();
            Element element = st.getElement();
            SimpleContentUnionMemberTypesDialog dialog = new SimpleContentUnionMemberTypesDialog(shell, st);
            dialog.setBlockOnOpen(true);
            dialog.create();
            int result = dialog.open();
            if (result == 0) {
                String newValue = dialog.getResult();
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_LABEL_MEMBERTYPES_CHANGE"), element);
                Element unionElement = (Element)this.domHelper.getChildNode(element, "union");
                unionElement.setAttribute("memberTypes", newValue);
                if (newValue.length() > 0) {
                    unionElement.setAttribute("memberTypes", newValue);
                } else {
                    unionElement.removeAttribute("memberTypes");
                }
                this.endRecording(unionElement);
            }
            this.refresh();
        }
    }

    public void doHandleEvent(Event event) {
        Widget cfr_ignored_0 = event.widget;
    }

    public boolean shouldUseExtraSpace() {
        return false;
    }
}

