/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties.section;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.common.ui.properties.internal.provisional.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.actions.CreateElementAction;
import org.eclipse.wst.xsd.ui.internal.actions.DOMAttribute;
import org.eclipse.wst.xsd.ui.internal.dialogs.types.xsd.XSDComponentSelectionDialog;
import org.eclipse.wst.xsd.ui.internal.dialogs.types.xsd.XSDComponentSelectionProvider;
import org.eclipse.wst.xsd.ui.internal.dialogs.types.xsd.XSDSetTypeHelper;
import org.eclipse.wst.xsd.ui.internal.properties.section.AbstractSection;
import org.eclipse.wst.xsd.ui.internal.properties.section.SimpleContentUnionMemberTypesDialog;
import org.eclipse.wst.xsd.ui.internal.util.XSDDOMHelper;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDVariety;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SimpleTypeSection
extends AbstractSection {
    CCombo varietyCombo;
    Text typesText;
    CLabel typesLabel;
    Button button;

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.varietyCombo = this.getWidgetFactory().createCCombo(this.composite, 0x800000);
        CLabel label = this.getWidgetFactory().createCLabel(this.composite, XSDEditorPlugin.getXSDString("_UI_LABEL_VARIETY"));
        List list = XSDVariety.VALUES;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            this.varietyCombo.add(((XSDVariety)iter.next()).getName());
        }
        this.varietyCombo.addSelectionListener((SelectionListener)this);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 100);
        data.right = new FormAttachment(100, -this.rightMarginSpace - 5);
        data.top = new FormAttachment(0, 0);
        this.varietyCombo.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.varietyCombo, -5);
        data.top = new FormAttachment((Control)this.varietyCombo, 0, 0x1000000);
        label.setLayoutData((Object)data);
        this.typesText = this.getWidgetFactory().createText(this.composite, "");
        this.typesLabel = this.getWidgetFactory().createCLabel(this.composite, XSDEditorPlugin.getXSDString("_UI_LABEL_MEMBERTYPES"));
        this.button = this.getWidgetFactory().createButton(this.composite, "", 8);
        this.button.setImage(XSDEditorPlugin.getXSDImage("icons/browsebutton.gif"));
        this.typesText.addListener(24, (Listener)this);
        data = new FormData();
        data.left = new FormAttachment(0, 100);
        data.right = new FormAttachment(100, -this.rightMarginSpace - 5);
        data.top = new FormAttachment((Control)this.button, 0, 0x1000000);
        this.typesText.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.typesText, -5);
        data.top = new FormAttachment((Control)this.button, 0, 0x1000000);
        this.typesLabel.setLayoutData((Object)data);
        this.button.addSelectionListener((SelectionListener)this);
        data = new FormData();
        data.left = new FormAttachment((Control)this.typesText, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.varietyCombo, 4);
        this.button.setLayoutData((Object)data);
    }

    public void refresh() {
        this.setListenerEnabled(false);
        if (this.isReadOnly) {
            this.composite.setEnabled(false);
        } else {
            this.composite.setEnabled(true);
        }
        Object input = this.getInput();
        this.varietyCombo.setText("");
        this.typesText.setText("");
        this.typesLabel.setText(XSDEditorPlugin.getXSDString("_UI_LABEL_BASE_TYPE_WITH_COLON"));
        if (input != null && input instanceof XSDSimpleTypeDefinition) {
            XSDSimpleTypeDefinition st = (XSDSimpleTypeDefinition)input;
            Element simpleTypeElement = st.getElement();
            Element element = null;
            String variety = st.getVariety().getName();
            int intVariety = st.getVariety().getValue();
            if (variety != null) {
                this.varietyCombo.setText(variety);
                if (intVariety == 0) {
                    element = (Element)this.domHelper.getChildNode(simpleTypeElement, "restriction");
                    if (element == null) {
                        this.varietyCombo.setText(XSDEditorPlugin.getXSDString("_UI_NO_TYPE"));
                    } else {
                        String result = element.getAttribute("base");
                        if (result == null) {
                            this.typesText.setText("**anonymous**");
                        } else {
                            this.typesText.setText(result);
                        }
                    }
                    this.typesLabel.setText(XSDEditorPlugin.getXSDString("_UI_LABEL_BASE_TYPE_WITH_COLON"));
                } else if (intVariety == 1) {
                    element = (Element)this.domHelper.getChildNode(simpleTypeElement, "list");
                    if (element != null) {
                        String result = element.getAttribute("itemType");
                        if (result == null) {
                            this.typesText.setText("**anonymous**");
                        } else {
                            this.typesText.setText(result);
                        }
                    }
                    this.typesLabel.setText(XSDEditorPlugin.getXSDString("_UI_LABEL_ITEM_TYPE"));
                } else if (intVariety == 2) {
                    String memberTypes;
                    Element unionElement = (Element)this.domHelper.getChildNode(simpleTypeElement, "union");
                    if (unionElement != null && (memberTypes = unionElement.getAttribute("memberTypes")) != null) {
                        this.typesText.setText(memberTypes);
                    }
                    this.typesLabel.setText(XSDEditorPlugin.getXSDString("_UI_LABEL_MEMBERTYPES"));
                }
            }
        }
        this.setListenerEnabled(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void widgetSelected(SelectionEvent e) {
        Object input = this.getInput();
        if (e.widget == this.varietyCombo) {
            if (input != null && input instanceof XSDSimpleTypeDefinition) {
                XSDSimpleTypeDefinition st = (XSDSimpleTypeDefinition)input;
                Element parent = st.getElement();
                String variety = this.varietyCombo.getText();
                if (variety.equals(XSDVariety.ATOMIC_LITERAL.getName())) {
                    this.typesLabel.setText(XSDEditorPlugin.getXSDString("_UI_LABEL_BASE_TYPE_WITH_COLON"));
                    st.setVariety(XSDVariety.ATOMIC_LITERAL);
                    new ArrayList();
                    this.addCreateElementActionIfNotExist("restriction", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_RESTRICTION"), parent, null);
                } else if (variety.equals(XSDVariety.UNION_LITERAL.getName())) {
                    this.typesLabel.setText(XSDEditorPlugin.getXSDString("_UI_LABEL_MEMBERTYPES"));
                    st.setVariety(XSDVariety.UNION_LITERAL);
                    this.addCreateElementActionIfNotExist("union", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_UNION"), parent, null);
                } else if (variety.equals(XSDVariety.LIST_LITERAL.getName())) {
                    this.typesLabel.setText(XSDEditorPlugin.getXSDString("_UI_LABEL_ITEM_TYPE"));
                    st.setVariety(XSDVariety.LIST_LITERAL);
                    this.addCreateElementActionIfNotExist("list", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_LIST"), parent, null);
                }
            }
        } else if (e.widget == this.button) {
            Shell shell = Display.getCurrent().getActiveShell();
            Element element = ((XSDConcreteComponent)input).getElement();
            XSDComponentSelectionDialog dialog = null;
            String property = "";
            Element secondaryElement = null;
            IFile currentIFile = ((IFileEditorInput)this.getActiveEditor().getEditorInput()).getFile();
            XSDComponentSelectionProvider provider = new XSDComponentSelectionProvider(currentIFile, this.xsdSchema);
            dialog = new XSDComponentSelectionDialog(shell, XSDEditorPlugin.getXSDString("_UI_LABEL_SET_TYPE"), provider);
            provider.setDialog(dialog);
            if (input instanceof XSDSimpleTypeDefinition) {
                XSDSimpleTypeDefinition st = (XSDSimpleTypeDefinition)input;
                Element simpleTypeElement = st.getElement();
                if (st.getVariety() == XSDVariety.LIST_LITERAL) {
                    Element listElement = (Element)this.domHelper.getChildNode(simpleTypeElement, "list");
                    provider.showComplexTypes(false);
                    secondaryElement = listElement;
                    property = "itemType";
                } else if (st.getVariety() == XSDVariety.ATOMIC_LITERAL) {
                    Element derivedByElement = (Element)this.domHelper.getChildNode(simpleTypeElement, "restriction");
                    if (derivedByElement == null && (derivedByElement = (Element)this.domHelper.getChildNode(simpleTypeElement, "extension")) == null) {
                        return;
                    }
                    if (derivedByElement == null) return;
                    provider.showComplexTypes(false);
                    secondaryElement = derivedByElement;
                    property = "base";
                } else {
                    if (st.getVariety() == XSDVariety.UNION_LITERAL) {
                        SimpleContentUnionMemberTypesDialog unionDialog = new SimpleContentUnionMemberTypesDialog(shell, st);
                        unionDialog.setBlockOnOpen(true);
                        unionDialog.create();
                        int result = unionDialog.open();
                        if (result != 0) return;
                        String newValue = unionDialog.getResult();
                        this.beginRecording(XSDEditorPlugin.getXSDString("_UI_LABEL_MEMBERTYPES_CHANGE"), element);
                        Element unionElement = (Element)this.domHelper.getChildNode(element, "union");
                        unionElement.setAttribute("memberTypes", newValue);
                        if (newValue.length() > 0) {
                            unionElement.setAttribute("memberTypes", newValue);
                        } else {
                            unionElement.removeAttribute("memberTypes");
                        }
                        this.endRecording(unionElement);
                        if (!this.doRefresh) return;
                        this.refresh();
                        return;
                    }
                    property = "type";
                }
            } else {
                property = "type";
            }
            this.beginRecording(XSDEditorPlugin.getXSDString("_UI_TYPE_CHANGE"), element);
            dialog.setBlockOnOpen(true);
            dialog.create();
            int result = dialog.open();
            if (result == 0) {
                if (secondaryElement == null) {
                    secondaryElement = element;
                }
                XSDSetTypeHelper helper = new XSDSetTypeHelper(currentIFile, this.xsdSchema);
                helper.setType(secondaryElement, property, dialog.getSelection());
                XSDSimpleTypeDefinition st = (XSDSimpleTypeDefinition)this.getInput();
                st.setElement(element);
                this.updateSimpleTypeFacets();
            }
            this.endRecording(element);
        }
        if (!this.doRefresh) return;
        this.refresh();
    }

    public boolean shouldUseExtraSpace() {
        return false;
    }

    protected boolean addCreateElementActionIfNotExist(String elementTag, String label, Element parent, Node relativeNode) {
        Element listNode;
        XSDSimpleTypeDefinition st = (XSDSimpleTypeDefinition)this.getInput();
        ArrayList<DOMAttribute> attributes = new ArrayList<DOMAttribute>();
        String reuseType = null;
        this.beginRecording(XSDEditorPlugin.getXSDString("_UI_LABEL_VARIETY_CHANGE"), parent);
        if (elementTag.equals("restriction")) {
            Element unionNode;
            listNode = this.getFirstChildNodeIfExists(parent, "list", false);
            if (listNode != null) {
                reuseType = listNode.getAttribute("itemType");
                XSDDOMHelper.removeNodeAndWhitespace(listNode);
            }
            if ((unionNode = this.getFirstChildNodeIfExists(parent, "union", false)) != null) {
                String memberAttr = unionNode.getAttribute("memberTypes");
                if (memberAttr != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(memberAttr);
                    reuseType = stringTokenizer.nextToken();
                }
                XSDDOMHelper.removeNodeAndWhitespace(unionNode);
            }
            if (reuseType == null) {
                reuseType = this.getBuiltInStringQName();
            }
            attributes.add(new DOMAttribute("base", reuseType));
            st.setItemTypeDefinition(null);
        } else if (elementTag.equals("list")) {
            Element unionNode;
            Element restrictionNode = this.getFirstChildNodeIfExists(parent, "restriction", false);
            if (restrictionNode != null) {
                reuseType = restrictionNode.getAttribute("base");
                XSDDOMHelper.removeNodeAndWhitespace(restrictionNode);
            }
            if ((unionNode = this.getFirstChildNodeIfExists(parent, "union", false)) != null) {
                String memberAttr = unionNode.getAttribute("memberTypes");
                if (memberAttr != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(memberAttr);
                    reuseType = stringTokenizer.nextToken();
                }
                XSDDOMHelper.removeNodeAndWhitespace(unionNode);
            }
            attributes.add(new DOMAttribute("itemType", reuseType));
        } else if (elementTag.equals("union")) {
            Element restrictionNode;
            listNode = this.getFirstChildNodeIfExists(parent, "list", false);
            if (listNode != null) {
                reuseType = listNode.getAttribute("itemType");
                XSDDOMHelper.removeNodeAndWhitespace(listNode);
            }
            if ((restrictionNode = this.getFirstChildNodeIfExists(parent, "restriction", false)) != null) {
                reuseType = restrictionNode.getAttribute("base");
                XSDDOMHelper.removeNodeAndWhitespace(restrictionNode);
            }
            attributes.add(new DOMAttribute("memberTypes", reuseType));
            st.setItemTypeDefinition(null);
        }
        if (this.getFirstChildNodeIfExists(parent, elementTag, false) == null) {
            Action action = this.addCreateElementAction(elementTag, label, attributes, parent, relativeNode);
            action.run();
        }
        st.setElement(parent);
        this.endRecording(parent);
        return true;
    }

    protected Action addCreateElementAction(String elementTag, String label, List attributes, Element parent, Node relativeNode) {
        CreateElementAction action = new CreateElementAction(label);
        action.setElementTag(elementTag);
        action.setAttributes(attributes);
        action.setParentNode(parent);
        action.setRelativeNode(relativeNode);
        return action;
    }

    protected Element getFirstChildNodeIfExists(Node parent, String elementTag, boolean isRef) {
        NodeList children = parent.getChildNodes();
        Element targetNode = null;
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child != null && child instanceof Element && XSDDOMHelper.inputEquals((Element)child, elementTag, isRef)) {
                targetNode = (Element)child;
                break;
            }
            ++i;
        }
        return targetNode;
    }

    protected String getBuiltInStringQName() {
        String prefix;
        String schemaForSchemaPrefix;
        String stringName = "string";
        if (this.getSchema() != null && (schemaForSchemaPrefix = this.getSchema().getSchemaForSchemaQNamePrefix()) != null && schemaForSchemaPrefix.length() > 0 && (prefix = this.getSchema().getSchemaForSchemaQNamePrefix()) != null && prefix.length() > 0) {
            stringName = String.valueOf(prefix) + ":" + stringName;
        }
        return stringName;
    }

    private void updateSimpleTypeFacets() {
        XSDSimpleTypeDefinition st = (XSDSimpleTypeDefinition)this.getInput();
        Element simpleTypeElement = st.getElement();
        Element derivedByElement = this.getDomHelper().getDerivedByElement(simpleTypeElement);
        if (derivedByElement != null) {
            ArrayList<Node> nodesToRemove = new ArrayList<Node>();
            NodeList childList = derivedByElement.getChildNodes();
            int length = childList.getLength();
            int i = 0;
            while (i < length) {
                Element elementChild;
                Node child = childList.item(i);
                if (!(!(child instanceof Element) || (elementChild = (Element)child).getLocalName().equals("pattern") || elementChild.getLocalName().equals("enumeration") || XSDDOMHelper.inputEquals(elementChild, "simpleType", false) || XSDDOMHelper.inputEquals(elementChild, "annotation", false) || XSDDOMHelper.inputEquals(elementChild, "attribute", false) || XSDDOMHelper.inputEquals(elementChild, "attribute", true) || XSDDOMHelper.inputEquals(elementChild, "attributeGroup", false) || XSDDOMHelper.inputEquals(elementChild, "attributeGroup", true) || XSDDOMHelper.inputEquals(elementChild, "anyAttribute", false))) {
                    nodesToRemove.add(child);
                }
                ++i;
            }
            Iterator iter = nodesToRemove.iterator();
            while (iter.hasNext()) {
                Element facetToRemove = (Element)iter.next();
                String facetName = facetToRemove.getLocalName();
                Iterator it = st.getValidFacets().iterator();
                boolean doRemove = true;
                while (it.hasNext()) {
                    String aValidFacet = (String)it.next();
                    if (!aValidFacet.equals(facetName)) continue;
                    doRemove = false;
                    break;
                }
                if (!doRemove) continue;
                XSDDOMHelper.removeNodeAndWhitespace(facetToRemove);
            }
        }
    }
}

