/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties.section;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.util.TypesHelper;
import org.eclipse.wst.xsd.ui.internal.util.ViewUtility;
import org.eclipse.wst.xsd.ui.internal.widgets.TypeSection;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

public class SimpleContentUnionMemberTypesDialog
extends Dialog
implements SelectionListener {
    XSDSimpleTypeDefinition simpleType;
    Table table;
    TypeSection typeSection;
    Button addButton;
    Button removeButton;
    org.eclipse.swt.widgets.List memberTypesList;
    private String result;

    public SimpleContentUnionMemberTypesDialog(Shell parentShell, XSDSimpleTypeDefinition simpleType) {
        super(parentShell);
        this.simpleType = simpleType;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            StringBuffer sb = new StringBuffer();
            int length = this.memberTypesList.getItemCount();
            int i = 0;
            while (i < length) {
                sb.append(this.memberTypesList.getItem(i));
                if (i < length - 1) {
                    sb.append(" ");
                }
                ++i;
            }
            this.result = sb.toString();
        }
        super.buttonPressed(buttonId);
    }

    public String getResult() {
        return this.result;
    }

    public Control createDialogArea(Composite parent) {
        Composite client = (Composite)super.createDialogArea(parent);
        this.getShell().setText("Union memberTypes");
        Label instructions = new Label(client, 16448);
        instructions.setText(XSDEditorPlugin.getXSDString("_UI_LABEL_SELECT_MEMBERTYPES"));
        Composite columnsComposite = new Composite(client, 0);
        GridLayout ccGL = new GridLayout();
        ccGL.verticalSpacing = 0;
        ccGL.horizontalSpacing = 0;
        ccGL.marginHeight = 0;
        ccGL.marginWidth = 0;
        ccGL.makeColumnsEqualWidth = true;
        ccGL.numColumns = 3;
        columnsComposite.setLayout((Layout)ccGL);
        GridData ccGD = new GridData();
        ccGD.grabExcessHorizontalSpace = true;
        ccGD.horizontalAlignment = 4;
        columnsComposite.setLayoutData((Object)ccGD);
        this.typeSection = new TypeSection(columnsComposite);
        this.typeSection.setShowUserComplexType(false);
        this.typeSection.createClient(columnsComposite);
        this.typeSection.getSimpleType().setSelection(false);
        this.typeSection.getSimpleType().addSelectionListener((SelectionListener)this);
        this.typeSection.getUserSimpleType().addSelectionListener((SelectionListener)this);
        ViewUtility.createHorizontalFiller(columnsComposite, 1);
        Label memberListLabel = new Label(columnsComposite, 16384);
        memberListLabel.setText(XSDEditorPlugin.getXSDString("_UI_LABEL_MEMBERTYPES_VALUE"));
        Composite dataComposite = new Composite(client, 0);
        GridLayout dcGL = new GridLayout();
        dcGL.verticalSpacing = 0;
        dcGL.marginHeight = 0;
        dcGL.marginWidth = 0;
        dcGL.numColumns = 3;
        dataComposite.setLayout((Layout)dcGL);
        GridData dcGD = new GridData();
        dcGD.grabExcessHorizontalSpace = true;
        dcGD.grabExcessVerticalSpace = true;
        dataComposite.setLayoutData((Object)dcGD);
        this.table = new Table(dataComposite, 68356);
        this.table.setHeaderVisible(false);
        this.table.setLinesVisible(true);
        GridData gd2 = new GridData();
        gd2.grabExcessHorizontalSpace = true;
        gd2.grabExcessVerticalSpace = true;
        gd2.horizontalAlignment = 4;
        gd2.verticalAlignment = 4;
        gd2.heightHint = 200;
        gd2.widthHint = 200;
        this.table.setLayoutData((Object)gd2);
        this.handleSetInput();
        this.table.getItemCount();
        TableColumn tc = new TableColumn(this.table, 16384);
        tc.setWidth(200);
        tc.setResizable(true);
        Composite buttonComposite = new Composite(dataComposite, 0);
        GridLayout bcGL = new GridLayout();
        bcGL.numColumns = 1;
        buttonComposite.setLayout((Layout)bcGL);
        this.addButton = new Button(buttonComposite, 8);
        this.addButton.setText(">");
        this.addButton.addSelectionListener((SelectionListener)this);
        this.removeButton = new Button(buttonComposite, 8);
        this.removeButton.setText("<");
        this.removeButton.addSelectionListener((SelectionListener)this);
        Composite listComposite = new Composite(dataComposite, 0);
        GridLayout mtGL = new GridLayout();
        mtGL.numColumns = 1;
        mtGL.marginHeight = 0;
        mtGL.marginWidth = 0;
        mtGL.horizontalSpacing = 0;
        mtGL.verticalSpacing = 0;
        listComposite.setLayout((Layout)mtGL);
        GridData mtGD = new GridData();
        mtGD.grabExcessHorizontalSpace = true;
        mtGD.grabExcessVerticalSpace = true;
        mtGD.verticalAlignment = 4;
        mtGD.horizontalAlignment = 4;
        listComposite.setLayoutData((Object)mtGD);
        this.memberTypesList = new org.eclipse.swt.widgets.List(listComposite, 2818);
        GridData mtlGD = new GridData();
        mtlGD.grabExcessHorizontalSpace = true;
        mtlGD.grabExcessVerticalSpace = true;
        mtlGD.verticalAlignment = 4;
        mtlGD.horizontalAlignment = 4;
        mtlGD.heightHint = 200;
        mtlGD.widthHint = 200;
        this.memberTypesList.setLayoutData((Object)mtlGD);
        this.initializeMemberListContent();
        return client;
    }

    private void initializeMemberListContent() {
        XSDSchema schema = this.simpleType.getSchema();
        Iterator i = this.simpleType.getMemberTypeDefinitions().iterator();
        while (i.hasNext()) {
            String name = ((XSDSimpleTypeDefinition)i.next()).getQName((XSDConcreteComponent)schema);
            if (name == null) continue;
            this.memberTypesList.add(name);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.typeSection.getSimpleType() && this.typeSection.getSimpleType().getSelection()) {
            this.populateBuiltInType();
        } else if (e.widget == this.typeSection.getUserSimpleType() && this.typeSection.getUserSimpleType().getSelection()) {
            this.populateUserSimpleType(false);
        } else if (e.widget == this.addButton) {
            String typeToAdd;
            TableItem[] items = this.table.getItems();
            int selection = this.table.getSelectionIndex();
            if (items != null && items.length > 0 && selection >= 0 && this.memberTypesList.indexOf(typeToAdd = items[selection].getData().toString()) < 0) {
                this.memberTypesList.add(items[selection].getData().toString());
            }
        } else if (e.widget == this.removeButton) {
            String[] typesToRemove = this.memberTypesList.getSelection();
            int i = 0;
            while (i < typesToRemove.length) {
                this.memberTypesList.remove(typesToRemove[i]);
                ++i;
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void handleSetInput() {
        this.populateBuiltInType();
    }

    public void populateBuiltInType() {
        this.table.removeAll();
        List items = this.getBuiltInTypeNamesList();
        int i = 0;
        while (i < items.size()) {
            TableItem item = new TableItem(this.table, 0);
            item.setText(items.get(i).toString());
            item.setImage(XSDEditorPlugin.getXSDImage("icons/XSDSimpleType.gif"));
            item.setData(items.get(i));
            ++i;
        }
    }

    public void populateUserSimpleType(boolean showAnonymous) {
        this.table.removeAll();
        if (showAnonymous) {
            TableItem anonymousItem = new TableItem(this.table, 0);
            anonymousItem.setText("**anonymous**");
            anonymousItem.setData((Object)"**anonymous**");
        }
        List items = this.getUserSimpleTypeNamesList();
        int i = 0;
        while (i < items.size()) {
            TableItem item = new TableItem(this.table, 0);
            item.setText(items.get(i).toString());
            item.setImage(XSDEditorPlugin.getXSDImage("icons/XSDSimpleType.gif"));
            item.setData(items.get(i));
            ++i;
        }
    }

    public List getBuiltInTypeNamesList() {
        TypesHelper helper = new TypesHelper(this.simpleType.getSchema());
        return helper.getBuiltInTypeNamesList();
    }

    public List getUserSimpleTypeNamesList() {
        TypesHelper helper = new TypesHelper(this.simpleType.getSchema());
        return helper.getUserSimpleTypeNamesList();
    }
}

