/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties.section;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.ui.properties.internal.provisional.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.properties.section.AbstractSection;
import org.eclipse.wst.xsd.ui.internal.refactor.rename.GlobalAttributeGroupRenamer;
import org.eclipse.wst.xsd.ui.internal.refactor.rename.GlobalAttributeRenamer;
import org.eclipse.wst.xsd.ui.internal.refactor.rename.GlobalElementRenamer;
import org.eclipse.wst.xsd.ui.internal.refactor.rename.GlobalGroupRenamer;
import org.eclipse.wst.xsd.ui.internal.refactor.rename.GlobalSimpleOrComplexTypeRenamer;
import org.eclipse.wst.xsd.ui.internal.util.XSDDOMHelper;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NameSection
extends AbstractSection {
    Text nameText;

    public void doHandleEvent(Event event) {
        if (event.widget == this.nameText) {
            Object input = this.getInput();
            String newValue = this.nameText.getText();
            if (input instanceof XSDNamedComponent) {
                XSDNamedComponent namedComponent = (XSDNamedComponent)input;
                if (newValue.length() > 0) {
                    namedComponent.setName(newValue);
                    this.doReferentialIntegrityCheck((XSDComponent)namedComponent, newValue);
                }
            } else if (input instanceof XSDAttributeDeclaration) {
                XSDAttributeDeclaration attribute = (XSDAttributeDeclaration)input;
                if (newValue.length() > 0) {
                    this.doReferentialIntegrityCheck((XSDComponent)attribute, newValue);
                    attribute.setName(newValue);
                }
            } else if (input instanceof XSDAttributeUse) {
                XSDAttributeUse attributeUse = (XSDAttributeUse)input;
                XSDAttributeDeclaration attribute = attributeUse.getAttributeDeclaration();
                if (newValue.length() > 0) {
                    this.doReferentialIntegrityCheck((XSDComponent)attribute, newValue);
                    attribute.setName(newValue);
                    attributeUse.setAttributeDeclaration(attribute);
                }
            }
        }
    }

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.nameText = this.getWidgetFactory().createText(this.composite, "");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 100);
        data.right = new FormAttachment(100, -this.rightMarginSpace - 5);
        data.top = new FormAttachment(0, 0);
        this.nameText.setLayoutData((Object)data);
        this.nameText.addListener(24, (Listener)this);
        CLabel nameLabel = this.getWidgetFactory().createCLabel(this.composite, XSDEditorPlugin.getXSDString("_UI_NAME"));
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.nameText, -5);
        data.top = new FormAttachment((Control)this.nameText, 0, 0x1000000);
        nameLabel.setLayoutData((Object)data);
    }

    public void refresh() {
        if (this.nameText.isFocusControl()) {
            return;
        }
        this.setListenerEnabled(false);
        this.nameText.setEditable(true);
        if (this.isReadOnly) {
            this.composite.setEnabled(false);
        } else {
            this.composite.setEnabled(true);
        }
        Object input = this.getInput();
        this.nameText.setText("");
        if (input != null) {
            XSDAttributeUse attributeUse;
            XSDAttributeDeclaration attribute;
            String name;
            if (input instanceof XSDComplexTypeDefinition || input instanceof XSDSimpleTypeDefinition) {
                boolean isAnonymousType;
                XSDTypeDefinition type = (XSDTypeDefinition)input;
                Element element = type.getElement();
                String name2 = element.getAttribute("name");
                if (name2 == null) {
                    name2 = "";
                }
                if (isAnonymousType = this.checkForAnonymousType(element)) {
                    this.nameText.setText("**anonymous**");
                    this.nameText.setEditable(false);
                } else {
                    this.nameText.setText(name2);
                    this.nameText.setEditable(true);
                }
            } else if (input instanceof XSDNamedComponent) {
                XSDNamedComponent namedComponent = (XSDNamedComponent)input;
                namedComponent.getElement();
                String name3 = namedComponent.getName();
                if (name3 != null) {
                    this.nameText.setText(name3);
                }
            } else if (input instanceof XSDAttributeDeclaration) {
                XSDAttributeDeclaration attribute2 = (XSDAttributeDeclaration)input;
                Element element = attribute2.getElement();
                String name4 = element.getAttribute("name");
                if (name4 != null) {
                    this.nameText.setText(name4);
                }
            } else if (input instanceof XSDAttributeUse && (name = (attribute = (attributeUse = (XSDAttributeUse)input).getAttributeDeclaration()).getName()) != null) {
                this.nameText.setText(name);
            }
        }
        this.setListenerEnabled(true);
    }

    public boolean shouldUseExtraSpace() {
        return false;
    }

    private void doReferentialIntegrityCheck(XSDComponent xsdComponent, String newValue) {
        Element element = xsdComponent.getElement();
        if (XSDDOMHelper.inputEquals(element, "element", false)) {
            if (this.validateName(newValue)) {
                XSDConcreteComponent comp;
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_ELEMENT_NAME_CHANGE"), element);
                element.setAttribute("name", newValue);
                if (xsdComponent instanceof XSDNamedComponent) {
                    ((XSDNamedComponent)xsdComponent).setName(newValue);
                }
                if (this.xsdSchema != null && (comp = this.xsdSchema.getCorrespondingComponent((Node)element)) != null && comp instanceof XSDElementDeclaration && comp.getContainer().equals(this.xsdSchema)) {
                    GlobalElementRenamer renamer = new GlobalElementRenamer((XSDNamedComponent)comp, newValue);
                    renamer.visitSchema(this.xsdSchema);
                }
                this.endRecording(element);
            }
        } else if (XSDDOMHelper.inputEquals(element, "complexType", false)) {
            if (this.validateName(newValue)) {
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_COMPLEXTYPE_NAME_CHANGE"), element);
                if (newValue.length() > 0) {
                    XSDConcreteComponent comp;
                    if (this.xsdSchema != null && (comp = this.xsdSchema.getCorrespondingComponent((Node)element)) != null && comp instanceof XSDComplexTypeDefinition && comp.getContainer().equals(this.xsdSchema)) {
                        GlobalSimpleOrComplexTypeRenamer renamer = new GlobalSimpleOrComplexTypeRenamer((XSDNamedComponent)comp, newValue);
                        renamer.visitSchema(this.xsdSchema);
                    }
                    element.setAttribute("name", newValue);
                    ((XSDNamedComponent)xsdComponent).setName(newValue);
                } else {
                    element.removeAttribute("name");
                }
                this.endRecording(element);
            }
        } else if (XSDDOMHelper.inputEquals(element, "simpleType", false)) {
            this.beginRecording(XSDEditorPlugin.getXSDString("_UI_SIMPLETYPE_NAME_CHANGE"), element);
            if (this.validateName(newValue)) {
                if (newValue.length() > 0) {
                    XSDConcreteComponent comp;
                    if (this.xsdSchema != null && (comp = this.xsdSchema.getCorrespondingComponent((Node)element)) != null && comp instanceof XSDSimpleTypeDefinition && comp.getContainer().equals(this.xsdSchema)) {
                        GlobalSimpleOrComplexTypeRenamer renamer = new GlobalSimpleOrComplexTypeRenamer((XSDNamedComponent)comp, newValue);
                        renamer.visitSchema(this.xsdSchema);
                    }
                } else {
                    element.setAttribute("name", "");
                }
            }
            this.endRecording(element);
        } else if (XSDDOMHelper.inputEquals(element, "attribute", false)) {
            XSDConcreteComponent comp;
            this.beginRecording(XSDEditorPlugin.getXSDString("_UI_ATTRIBUTE_NAME_CHANGE"), element);
            if (this.xsdSchema != null && (comp = this.xsdSchema.getCorrespondingComponent((Node)element)) != null && comp instanceof XSDAttributeDeclaration && comp.getContainer().equals(this.xsdSchema)) {
                GlobalAttributeRenamer renamer = new GlobalAttributeRenamer((XSDNamedComponent)comp, newValue);
                renamer.visitSchema(this.xsdSchema);
            }
            this.endRecording(element);
        } else if (XSDDOMHelper.inputEquals(element, "attributeGroup", false)) {
            XSDConcreteComponent comp;
            this.beginRecording(XSDEditorPlugin.getXSDString("_UI_ATTRIBUTEGROUP_NAME_CHANGE"), element);
            ((XSDNamedComponent)xsdComponent).setName(newValue);
            if (this.xsdSchema != null && (comp = this.xsdSchema.getCorrespondingComponent((Node)element)) != null && comp instanceof XSDAttributeGroupDefinition && comp.getContainer().equals(this.xsdSchema)) {
                GlobalAttributeGroupRenamer renamer = new GlobalAttributeGroupRenamer((XSDNamedComponent)comp, newValue);
                renamer.visitSchema(this.xsdSchema);
            }
            this.endRecording(element);
        } else if (XSDDOMHelper.inputEquals(element, "unique", false)) {
            if (this.validateName(newValue)) {
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_UNIQUE_NAME_CHANGE"), element);
                if (newValue.length() > 0) {
                    element.setAttribute("name", newValue);
                } else {
                    element.setAttribute("name", "");
                }
                this.endRecording(element);
            }
        } else if (XSDDOMHelper.inputEquals(element, "key", false)) {
            if (this.validateName(newValue)) {
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_KEY_NAME_CHANGE"), element);
                if (newValue.length() > 0) {
                    element.setAttribute("name", newValue);
                } else {
                    element.setAttribute("name", "");
                }
                this.endRecording(element);
            }
        } else if (XSDDOMHelper.inputEquals(element, "group", false) && this.validateName(newValue)) {
            XSDConcreteComponent comp;
            this.beginRecording(XSDEditorPlugin.getXSDString("_UI_GROUP_NAME_CHANGE"), element);
            if (this.xsdSchema != null && (comp = this.xsdSchema.getCorrespondingComponent((Node)element)) != null && comp instanceof XSDModelGroupDefinition && comp.getContainer().equals(this.xsdSchema)) {
                GlobalGroupRenamer renamer = new GlobalGroupRenamer((XSDNamedComponent)comp, newValue);
                renamer.visitSchema(this.xsdSchema);
            }
            element.setAttribute("name", newValue);
            this.endRecording(element);
        }
    }

    boolean checkForAnonymousType(Element element) {
        Node parentElement = element.getParentNode();
        boolean isAnonymous = false;
        if (parentElement != null) {
            if (XSDDOMHelper.inputEquals(element, "complexType", false)) {
                if (XSDDOMHelper.inputEquals(parentElement, "element", false)) {
                    isAnonymous = true;
                }
            } else if (XSDDOMHelper.inputEquals(element, "simpleType", false) && (XSDDOMHelper.inputEquals(parentElement, "restriction", false) || XSDDOMHelper.inputEquals(parentElement, "element", false) || XSDDOMHelper.inputEquals(parentElement, "union", false) || XSDDOMHelper.inputEquals(parentElement, "list", false) || XSDDOMHelper.inputEquals(parentElement, "attribute", false))) {
                isAnonymous = true;
            }
        }
        return isAnonymous;
    }
}

