/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties;

import java.util.ArrayList;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.properties.BasePropertySource;
import org.eclipse.wst.xsd.ui.internal.util.XSDDOMHelper;
import org.eclipse.xsd.XSDSchema;

public class XPathPropertySource
extends BasePropertySource
implements IPropertySource {
    public XPathPropertySource() {
    }

    public XPathPropertySource(Viewer viewer, XSDSchema xsdSchema) {
        super(viewer, xsdSchema);
    }

    public XPathPropertySource(XSDSchema xsdSchema) {
        super(xsdSchema);
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<TextPropertyDescriptor> list = new ArrayList<TextPropertyDescriptor>();
        TextPropertyDescriptor xpathDescriptor = new TextPropertyDescriptor((Object)"xpath", "xpath");
        list.add(xpathDescriptor);
        IPropertyDescriptor[] result = new IPropertyDescriptor[list.size()];
        list.toArray(result);
        return result;
    }

    public Object getPropertyValue(Object id) {
        String result = null;
        if (id instanceof String) {
            result = this.element.getAttribute((String)id);
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        if (value != null && value instanceof String) {
            if (XSDDOMHelper.inputEquals(this.element, "field", false)) {
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_FIELD_XPATH_CHANGE"), this.element);
            } else if (XSDDOMHelper.inputEquals(this.element, "selector", false)) {
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_SELECTOR_XPATH_CHANGE"), this.element);
            }
            this.element.setAttribute("xpath", (String)value);
            this.endRecording(this.element);
        }
        Runnable delayedUpdate = new Runnable(){

            public void run() {
                if (XPathPropertySource.this.viewer != null) {
                    XPathPropertySource.this.viewer.refresh();
                }
            }
        };
        Display.getCurrent().asyncExec(delayedUpdate);
    }
}

