/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.properties.BasePropertySource;
import org.eclipse.wst.xsd.ui.internal.properties.XSDComboBoxPropertyDescriptor;
import org.eclipse.wst.xsd.ui.internal.util.TypesHelper;
import org.eclipse.wst.xsd.ui.internal.util.XSDDOMHelper;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Element;

public class GroupRefPropertySource
extends BasePropertySource
implements IPropertySource {
    private String[] refComboValues = new String[]{""};

    public GroupRefPropertySource() {
    }

    public GroupRefPropertySource(Viewer viewer, XSDSchema xsdSchema) {
        super(viewer, xsdSchema);
    }

    public GroupRefPropertySource(XSDSchema xsdSchema) {
        super(xsdSchema);
    }

    public void setInput(Element element) {
        this.element = element;
        TypesHelper helper = new TypesHelper(this.xsdSchema);
        List items = helper.getGlobalElements();
        if (XSDDOMHelper.inputEquals(element, "group", true)) {
            items = helper.getModelGroups();
        } else if (XSDDOMHelper.inputEquals(element, "element", true)) {
            items = helper.getGlobalElements();
        }
        int size = items.size() + 1;
        this.refComboValues = new String[size];
        this.refComboValues[0] = "";
        if (items != null) {
            int i = 0;
            while (i < items.size()) {
                this.refComboValues[i + 1] = (String)items.get(i);
                ++i;
            }
        }
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<XSDComboBoxPropertyDescriptor> list = new ArrayList<XSDComboBoxPropertyDescriptor>();
        XSDComboBoxPropertyDescriptor refDescriptor = new XSDComboBoxPropertyDescriptor("ref", "ref", this.refComboValues);
        list.add(refDescriptor);
        TextPropertyDescriptor minOccursDescriptor = new TextPropertyDescriptor((Object)"minOccurs", "minOccurs");
        list.add((XSDComboBoxPropertyDescriptor)minOccursDescriptor);
        TextPropertyDescriptor maxOccursDescriptor = new TextPropertyDescriptor((Object)"maxOccurs", "maxOccurs");
        list.add((XSDComboBoxPropertyDescriptor)maxOccursDescriptor);
        IPropertyDescriptor[] result = new IPropertyDescriptor[list.size()];
        list.toArray(result);
        return result;
    }

    public Object getPropertyValue(Object id) {
        String result = null;
        if (id instanceof String) {
            result = this.element.getAttribute((String)id);
            if (result == null) {
                result = "";
            }
            return result;
        }
        return "";
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        if (value == null) {
            value = "";
        }
        if (value instanceof String) {
            String newValue = (String)value;
            String cfr_ignored_0 = (String)id;
            if (((String)id).equals("maxOccurs")) {
                String max = (String)value;
                this.element.getAttribute("minOccurs");
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_MAXOCCURS_CHANGE"), this.element);
                if (max.length() > 0) {
                    this.element.setAttribute("maxOccurs", max);
                } else {
                    this.element.removeAttribute("maxOccurs");
                }
                this.endRecording(this.element);
            } else if (((String)id).equals("minOccurs")) {
                String min = (String)value;
                this.element.getAttribute("maxOccurs");
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_MINOCCURS_CHANGE"), this.element);
                if (min.length() > 0) {
                    this.element.setAttribute("minOccurs", min);
                } else {
                    this.element.removeAttribute("minOccurs");
                }
                this.endRecording(this.element);
            } else if (((String)id).equals("ref")) {
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_GROUP_REF_CHANGE"), this.element);
                this.element.setAttribute((String)id, newValue);
                this.endRecording(this.element);
            }
        }
        if (this.viewer != null) {
            this.viewer.refresh();
        }
    }
}

