/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties;

import java.util.ArrayList;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.properties.BasePropertySource;
import org.eclipse.wst.xsd.ui.internal.properties.FixedOrDefaultTextPropertyDescriptor;
import org.eclipse.wst.xsd.ui.internal.properties.TypesPropertyDescriptor;
import org.eclipse.wst.xsd.ui.internal.properties.XSDComboBoxPropertyDescriptor;
import org.eclipse.wst.xsd.ui.internal.refactor.rename.GlobalAttributeRenamer;
import org.eclipse.wst.xsd.ui.internal.util.XSDDOMHelper;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AttributePropertySource
extends BasePropertySource
implements IPropertySource {
    private String[] useComboValues = new String[]{"", "prohibited", "optional", "required"};
    protected String[] formComboValues = new String[]{"", XSDEditorPlugin.getXSDString("_UI_COMBO_UNQUALIFIED"), XSDEditorPlugin.getXSDString("_UI_COMBO_QUALIFIED")};

    public AttributePropertySource() {
    }

    public AttributePropertySource(Viewer viewer, XSDSchema xsdSchema) {
        super(viewer, xsdSchema);
    }

    public AttributePropertySource(XSDSchema xsdSchema) {
        super(xsdSchema);
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<Object> list = new ArrayList<Object>();
        TextPropertyDescriptor nameDescriptor = new TextPropertyDescriptor((Object)"name", "name");
        list.add(nameDescriptor);
        TypesPropertyDescriptor typeDescriptor = new TypesPropertyDescriptor("type", "type", this.element, this.xsdSchema);
        list.add((Object)typeDescriptor);
        Attr fixedAttr = this.element.getAttributeNode("fixed");
        Attr defaultAttr = this.element.getAttributeNode("default");
        String str = fixedAttr != null ? "fixed" : (defaultAttr != null ? "default" : "fixed/default");
        FixedOrDefaultTextPropertyDescriptor fixedOrDefaultDescriptor = new FixedOrDefaultTextPropertyDescriptor(str, str, this.element);
        list.add((Object)fixedOrDefaultDescriptor);
        Node parentNode = this.element.getParentNode();
        if (!XSDDOMHelper.inputEquals(parentNode, "schema", false)) {
            XSDComboBoxPropertyDescriptor useDescriptor = new XSDComboBoxPropertyDescriptor("use", "use", this.useComboValues);
            list.add((Object)useDescriptor);
            XSDComboBoxPropertyDescriptor formDescriptor = new XSDComboBoxPropertyDescriptor("form", "form", this.formComboValues);
            list.add((Object)formDescriptor);
        }
        IPropertyDescriptor[] result = new IPropertyDescriptor[list.size()];
        list.toArray(result);
        return result;
    }

    public Object getPropertyValue(Object id) {
        String result = null;
        if (id instanceof String) {
            result = this.element.getAttribute((String)id);
            if (result == null) {
                result = "";
            }
            if (((String)id).equals("type")) {
                if (result.equals("")) {
                    if (this.checkForAnonymousType(this.element)) {
                        return "**anonymous**";
                    }
                    return XSDEditorPlugin.getXSDString("_UI_NO_TYPE");
                }
                return result;
            }
            return result;
        }
        return "";
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        if (value == null) {
            value = "";
        }
        if (value instanceof String && !((String)id).equals("type")) {
            if (((String)id).equals("name")) {
                XSDConcreteComponent comp;
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_ATTRIBUTE_NAME_CHANGE"), this.element);
                if (this.xsdSchema != null && (comp = this.xsdSchema.getCorrespondingComponent((Node)this.element)) != null && comp instanceof XSDAttributeDeclaration && comp.getRootContainer().equals(this.xsdSchema)) {
                    XSDAttributeDeclaration xsdAttributeDeclaration = (XSDAttributeDeclaration)comp;
                    xsdAttributeDeclaration.setName((String)value);
                    GlobalAttributeRenamer renamer = new GlobalAttributeRenamer((XSDNamedComponent)xsdAttributeDeclaration, (String)value);
                    renamer.visitSchema(this.xsdSchema);
                }
                this.element.setAttribute("name", (String)value);
                this.endRecording(this.element);
            } else if (((String)id).equals("fixed") || ((String)id).equals("default")) {
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_ATTRIBUTE_VALUE_CHANGE"), this.element);
                if (((String)value).equals("")) {
                    this.element.removeAttribute((String)id);
                } else {
                    this.element.setAttribute((String)id, (String)value);
                }
                this.endRecording(this.element);
            } else if (((String)id).equals("use")) {
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_ATTRIBUTE_USE_CHANGE"), this.element);
                if (((String)value).equals("")) {
                    this.element.removeAttribute("use");
                } else {
                    this.element.setAttribute((String)id, (String)value);
                }
                this.endRecording(this.element);
            } else if (((String)id).equals("form")) {
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_ATTRIBUTE_FORM_CHANGE"), this.element);
                if (((String)value).equals("")) {
                    this.element.removeAttribute("form");
                } else {
                    this.element.setAttribute("form", (String)value);
                }
                this.endRecording(this.element);
            }
        }
        Runnable delayedUpdate = new Runnable(){

            public void run() {
                if (AttributePropertySource.this.viewer != null) {
                    AttributePropertySource.this.viewer.refresh();
                }
            }
        };
        Display.getCurrent().asyncExec(delayedUpdate);
    }

    boolean checkForAnonymousType(Element element) {
        NodeList list = element.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "simpleType");
        return list.getLength() > 0;
    }
}

