/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.util.ViewUtility;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AnyContentPropertyDescriptor
extends PropertyDescriptor {
    Element element;

    public AnyContentPropertyDescriptor(Object id, String displayName, Element element) {
        super(id, displayName);
        this.element = element;
    }

    public CellEditor createPropertyEditor(Composite parent) {
        AnyContentDialogCellEditor editor = new AnyContentDialogCellEditor(parent);
        if (this.getValidator() != null) {
            editor.setValidator(this.getValidator());
        }
        return editor;
    }

    public class AnyContentDialogCellEditor
    extends DialogCellEditor {
        protected AnyContentDialogCellEditor(Composite parent) {
            super(parent);
        }

        protected Object openDialogBox(Control cellEditorWindow) {
            Shell shell = Display.getCurrent().getActiveShell();
            AnyContentDialog dialog = new AnyContentDialog(shell);
            dialog.setBlockOnOpen(true);
            dialog.create();
            String value = (String)this.getValue();
            int result = dialog.open();
            if (result == 0) {
                return dialog.getComment();
            }
            return value;
        }
    }

    public class AnyContentDialog
    extends Dialog {
        protected Text commentField;
        protected Button okButton;
        protected Button cancelButton;
        private String comment;

        public AnyContentDialog(Shell shell) {
            super(shell);
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 0) {
                this.comment = this.commentField.getText();
            }
            super.buttonPressed(buttonId);
        }

        public String getComment() {
            return this.comment;
        }

        public Control createDialogArea(Composite parent) {
            Composite client = (Composite)super.createDialogArea(parent);
            this.getShell().setText(AnyContentPropertyDescriptor.this.element.getLocalName());
            this.commentField = ViewUtility.createMultiTextField(client, 400, 200, true);
            WorkbenchHelp.setHelp((Control)this.commentField, (String)"org.eclipse.wst.xsd.ui.internal.xsde0210");
            this.commentField.setToolTipText(XSDEditorPlugin.getXSDString("_UI_TOOLTIP_COMMENT"));
            String initialString = (String)this.getInitialContent();
            this.commentField.setText(initialString);
            return client;
        }

        private Object getInitialContent() {
            String result = null;
            if (AnyContentPropertyDescriptor.this.element.hasChildNodes()) {
                Node node = AnyContentPropertyDescriptor.this.element.getFirstChild();
                if (node instanceof CharacterData) {
                    result = ((CharacterData)node).getData();
                }
            } else {
                result = "";
            }
            return result;
        }
    }
}

