/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.graph.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.graph.model.ModelAdapter;
import org.eclipse.wst.xsd.ui.internal.graph.model.ModelAdapterListener;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNotationDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;

public class Category
implements ModelAdapter {
    public static final int ATTRIBUTES = 1;
    public static final int ELEMENTS = 2;
    public static final int TYPES = 3;
    public static final int GROUPS = 5;
    public static final int DIRECTIVES = 6;
    public static final int NOTATIONS = 7;
    public static final int ATTRIBUTE_GROUPS = 8;
    public static final int IDENTITY_CONSTRAINTS = 9;
    public static final int ANNOTATIONS = 10;
    protected XSDSchema schema;
    protected int groupType;
    protected List listenerList = new ArrayList();

    public Category(XSDSchema schema, int groupType) {
        this.schema = schema;
        this.groupType = groupType;
    }

    public int getGroupType() {
        return this.groupType;
    }

    public XSDSchema getXSDSchema() {
        return this.schema;
    }

    public String getName() {
        String name = "";
        switch (this.groupType) {
            case 1: {
                name = XSDEditorPlugin.getXSDString("_UI_GRAPH_ATTRIBUTES");
                break;
            }
            case 7: {
                name = XSDEditorPlugin.getXSDString("_UI_GRAPH_NOTATIONS");
                break;
            }
            case 2: {
                name = XSDEditorPlugin.getXSDString("_UI_GRAPH_ELEMENTS");
                break;
            }
            case 3: {
                name = XSDEditorPlugin.getXSDString("_UI_GRAPH_TYPES");
                break;
            }
            case 5: {
                name = XSDEditorPlugin.getXSDString("_UI_GRAPH_GROUPS");
                break;
            }
            case 6: {
                name = XSDEditorPlugin.getXSDString("_UI_GRAPH_DIRECTIVES");
            }
        }
        return name;
    }

    public List getChildren() {
        List list = Collections.EMPTY_LIST;
        switch (this.groupType) {
            case 1: {
                list = this.getAttributeList();
                break;
            }
            case 7: {
                list = this.getNotations();
                break;
            }
            case 2: {
                list = this.getGlobalElements();
                break;
            }
            case 3: {
                list = this.getTypes();
                break;
            }
            case 5: {
                list = this.getGroups();
                break;
            }
            case 6: {
                list = this.getDirectives();
            }
        }
        return list;
    }

    private boolean isSameNamespace(String ns1, String ns2) {
        if (ns1 == null) {
            ns1 = "";
        }
        if (ns2 == null) {
            ns2 = "";
        }
        return ns1.equals(ns2);
    }

    protected List getGlobalElements() {
        EList elements = this.schema.getElementDeclarations();
        ArrayList<XSDElementDeclaration> list = new ArrayList<XSDElementDeclaration>();
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            XSDElementDeclaration elem = (XSDElementDeclaration)i.next();
            elem.getTargetNamespace();
            if (!this.isSameNamespace(elem.getTargetNamespace(), this.schema.getTargetNamespace())) continue;
            list.add(elem);
        }
        return list;
    }

    protected List getTypes() {
        XSDTypeDefinition td;
        EList allTypes = this.schema.getTypeDefinitions();
        ArrayList<Object> list = new ArrayList<Object>();
        Iterator i = allTypes.iterator();
        while (i.hasNext()) {
            XSDComplexTypeDefinition ct;
            td = (XSDTypeDefinition)i.next();
            if (!(td instanceof XSDComplexTypeDefinition) || !this.isSameNamespace((ct = (XSDComplexTypeDefinition)td).getTargetNamespace(), this.schema.getTargetNamespace())) continue;
            list.add(ct);
        }
        i = allTypes.iterator();
        while (i.hasNext()) {
            XSDSimpleTypeDefinition st;
            td = (XSDTypeDefinition)i.next();
            if (!(td instanceof XSDSimpleTypeDefinition) || !this.isSameNamespace((st = (XSDSimpleTypeDefinition)td).getTargetNamespace(), this.schema.getTargetNamespace())) continue;
            list.add(st);
        }
        return list;
    }

    protected List getGroups() {
        EList groups = this.schema.getModelGroupDefinitions();
        ArrayList<XSDModelGroupDefinition> list = new ArrayList<XSDModelGroupDefinition>();
        Iterator i = groups.iterator();
        while (i.hasNext()) {
            XSDModelGroupDefinition group = (XSDModelGroupDefinition)i.next();
            if (!this.isSameNamespace(group.getTargetNamespace(), this.schema.getTargetNamespace())) continue;
            list.add(group);
        }
        return list;
    }

    protected List getDirectives() {
        ArrayList list = new ArrayList();
        Iterator i = this.schema.getContents().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof XSDSchemaDirective)) continue;
            list.add(o);
        }
        return list;
    }

    protected List getAttributeList() {
        ArrayList<XSDAttributeDeclaration> attributesList = new ArrayList<XSDAttributeDeclaration>();
        Iterator iter = this.schema.getAttributeDeclarations().iterator();
        while (iter.hasNext()) {
            XSDAttributeDeclaration attr;
            Object o = iter.next();
            if (!(o instanceof XSDAttributeDeclaration) || (attr = (XSDAttributeDeclaration)o) == null) continue;
            if (attr.getTargetNamespace() != null) {
                if (attr.getTargetNamespace().equals("http://www.w3.org/2001/XMLSchema-instance") || !this.isSameNamespace(attr.getTargetNamespace(), this.schema.getTargetNamespace())) continue;
                attributesList.add(attr);
                continue;
            }
            if (!this.isSameNamespace(attr.getTargetNamespace(), this.schema.getTargetNamespace())) continue;
            attributesList.add(attr);
        }
        return attributesList;
    }

    protected List getNotations() {
        EList notations = this.schema.getNotationDeclarations();
        ArrayList<XSDNotationDeclaration> list = new ArrayList<XSDNotationDeclaration>();
        Iterator i = notations.iterator();
        while (i.hasNext()) {
            XSDNotationDeclaration notation = (XSDNotationDeclaration)i.next();
            if (!this.isSameNamespace(notation.getTargetNamespace(), this.schema.getTargetNamespace())) continue;
            list.add(notation);
        }
        return list;
    }

    public void addListener(ModelAdapterListener l) {
        this.listenerList.add(l);
    }

    public void removeListener(ModelAdapterListener l) {
        this.listenerList.remove(l);
    }

    public Object getProperty(Object modelObject, String propertyName) {
        return null;
    }

    public void firePropertyChanged(Object modelObject, String propertyName) {
        ArrayList newList = new ArrayList();
        newList.addAll(this.listenerList);
        Iterator i = newList.iterator();
        while (i.hasNext()) {
            ModelAdapterListener l = (ModelAdapterListener)i.next();
            try {
                l.propertyChanged(modelObject, propertyName);
            }
            catch (Exception exception) {}
        }
    }
}

