/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.graph.editparts;

import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.wst.xsd.ui.internal.graph.XSDChildUtility;
import org.eclipse.wst.xsd.ui.internal.graph.XSDGraphUtil;
import org.eclipse.wst.xsd.ui.internal.graph.XSDInheritanceViewer;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.ExpandableGraphNodeEditPart;
import org.eclipse.wst.xsd.ui.internal.graph.editpolicies.ComponentNameDirectEditManager;
import org.eclipse.wst.xsd.ui.internal.graph.editpolicies.SelectionHandlesEditPolicyImpl;
import org.eclipse.wst.xsd.ui.internal.graph.editpolicies.SimpleDirectEditPolicy;
import org.eclipse.wst.xsd.ui.internal.graph.figures.ExpandableGraphNodeFigure;
import org.eclipse.wst.xsd.ui.internal.graph.figures.FillLayout;
import org.eclipse.wst.xsd.ui.internal.graph.figures.GraphNodeFigure;
import org.eclipse.wst.xsd.ui.internal.graph.figures.RoundedLineBorder;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDNamedComponent;

public class RootComplexTypeDefinitionEditPart
extends ExpandableGraphNodeEditPart {
    public Label label;
    protected SimpleDirectEditPolicy simpleDirectEditPolicy = new SimpleDirectEditPolicy();

    protected GraphNodeFigure createGraphNodeFigure() {
        ExpandableGraphNodeFigure figure = new ExpandableGraphNodeFigure();
        figure.getOutlinedArea().setBorder((Border)new RoundedLineBorder(1, 6));
        figure.getOutlinedArea().setLayoutManager((LayoutManager)new FillLayout());
        figure.getOutlinedArea().setFill(true);
        if (this.getViewer() instanceof XSDInheritanceViewer) {
            figure.getOuterContentArea().getContainerLayout().setSpacing(10);
        }
        this.label = new Label();
        this.label.setFont(mediumBoldFont);
        this.label.setBorder((Border)new MarginBorder(5, 8, 5, 8));
        figure.getIconArea().add((IFigure)this.label);
        return figure;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        XSDComplexTypeDefinition ctd = (XSDComplexTypeDefinition)this.getModel();
        this.label.setText(ctd.getName() != null ? ctd.getName() : "");
        if (XSDGraphUtil.isEditable(ctd)) {
            this.figure.setForegroundColor(elementBorderColor);
            this.label.setForegroundColor(elementBorderColor);
        } else {
            this.figure.setForegroundColor(readOnlyBorderColor);
            this.label.setForegroundColor(readOnlyBorderColor);
        }
    }

    protected List getModelChildrenHelper() {
        XSDComplexTypeDefinition ct = (XSDComplexTypeDefinition)this.getModel();
        if (this.getViewer() instanceof XSDInheritanceViewer) {
            return XSDChildUtility.getImmediateDerivedTypes(ct);
        }
        return XSDChildUtility.getModelChildren(this.getModel());
    }

    protected void createEditPolicies() {
        SelectionHandlesEditPolicyImpl policy = new SelectionHandlesEditPolicyImpl();
        this.installEditPolicy("Selection Feedback", (EditPolicy)policy);
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)this.simpleDirectEditPolicy);
    }

    protected void performDirectEdit() {
        ComponentNameDirectEditManager manager = new ComponentNameDirectEditManager((GraphicalEditPart)this, this.label, (XSDNamedComponent)((XSDComplexTypeDefinition)this.getModel()));
        this.simpleDirectEditPolicy.setDelegate(manager);
        manager.show();
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit" && XSDGraphUtil.isEditable(this.getModel())) {
            this.performDirectEdit();
        }
    }
}

