/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.graph.editparts;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.RepeatableGraphNodeEditPart;
import org.eclipse.wst.xsd.ui.internal.graph.figures.ExpandableGraphNodeFigure;
import org.eclipse.wst.xsd.ui.internal.graph.figures.GraphNodeFigure;

public abstract class ExpandableGraphNodeEditPart
extends RepeatableGraphNodeEditPart
implements MouseListener,
ActionListener {
    protected boolean needToPerformDefaultExpansion = true;

    protected GraphNodeFigure createGraphNodeFigure() {
        return new ExpandableGraphNodeFigure();
    }

    protected void addGraphNodeFigureListeners() {
        this.getExpandableGraphNodeFigure().getInteractor().addMouseListener(this);
    }

    protected ExpandableGraphNodeFigure getExpandableGraphNodeFigure() {
        return (ExpandableGraphNodeFigure)this.graphNodeFigure;
    }

    public IFigure getContentPane() {
        return this.getExpandableGraphNodeFigure().getOuterContentArea();
    }

    protected boolean isDefaultExpanded() {
        return false;
    }

    protected boolean hasChildren() {
        return this.getModelChildrenHelper().size() > 0;
    }

    protected abstract List getModelChildrenHelper();

    protected List getModelChildren() {
        return this.getExpandableGraphNodeFigure().isExpanded() ? this.getModelChildrenHelper() : Collections.EMPTY_LIST;
    }

    protected void refreshChildren() {
        if (this.needToPerformDefaultExpansion && this.isDefaultExpanded()) {
            this.needToPerformDefaultExpansion = false;
            this.performExpandOrCollapseHelper();
            super.refreshChildren();
            RootEditPart root = this.getRoot();
            if (root instanceof AbstractGraphicalEditPart) {
                this.getContentPane().setVisible(true);
                IFigure rootFigure = ((AbstractGraphicalEditPart)root).getFigure();
                this.invalidateAll(rootFigure);
                rootFigure.validate();
                rootFigure.repaint();
            }
            this.getExpandableGraphNodeFigure().getInteractor().repaint();
        } else {
            super.refreshChildren();
        }
        this.getExpandableGraphNodeFigure().getInteractor().setVisible(this.hasChildren());
    }

    protected void performExpandOrCollapseHelper() {
        boolean isButtonExpanded = !this.getExpandableGraphNodeFigure().isExpanded();
        this.getExpandableGraphNodeFigure().setExpanded(isButtonExpanded);
    }

    public void doPerformExpandOrCollapse() {
        this.performExpandOrCollapse();
    }

    public boolean isExpanded() {
        return this.getExpandableGraphNodeFigure().isExpanded();
    }

    protected void performExpandOrCollapse() {
        this.performExpandOrCollapseHelper();
        boolean isButtonExpanded = this.getExpandableGraphNodeFigure().isExpanded();
        this.refreshChildren();
        RootEditPart root = this.getRoot();
        if (root instanceof AbstractGraphicalEditPart) {
            this.getContentPane().setVisible(isButtonExpanded);
            IFigure rootFigure = ((AbstractGraphicalEditPart)root).getFigure();
            this.invalidateAll(rootFigure);
            rootFigure.validate();
            rootFigure.repaint();
        }
        this.getExpandableGraphNodeFigure().getInteractor().repaint();
    }

    protected void refreshOccurenceLabel(int min, int max) {
        super.refreshOccurenceLabel(min, max);
        IFigure thisFigure = this.getFigure();
        this.invalidateAll(thisFigure);
        thisFigure.validate();
        thisFigure.repaint();
    }

    protected void invalidateAll(IFigure figure) {
        figure.invalidate();
        LayoutManager manager = figure.getLayoutManager();
        if (manager != null) {
            manager.invalidate();
        }
        Iterator i = figure.getChildren().iterator();
        while (i.hasNext()) {
            IFigure child = (IFigure)i.next();
            this.invalidateAll(child);
        }
    }

    public void mouseDoubleClicked(MouseEvent me) {
    }

    public void mousePressed(MouseEvent me) {
        me.consume();
        this.needToPerformDefaultExpansion = false;
        this.performExpandOrCollapse();
    }

    public void mouseReleased(MouseEvent me) {
    }

    public void actionPerformed(ActionEvent event) {
        this.performExpandOrCollapse();
    }
}

