/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.graph;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.ExpandableGraphNodeEditPart;

public class XSDGraphicalViewerKeyHandler
extends KeyHandler {
    private WeakReference cachedNode;
    int counter;
    private GraphicalViewer viewer;

    public XSDGraphicalViewerKeyHandler(GraphicalViewer viewer) {
        this.viewer = viewer;
    }

    private boolean acceptConnection(KeyEvent event) {
        return event.character == '/' || event.character == '?' || event.character == '\\' || event.character == '|';
    }

    private boolean acceptIntoContainer(KeyEvent event) {
        return (event.stateMask & 0x10000) != 0 && event.keyCode == 0x1000004 || event.keyCode == 0x1000004;
    }

    private boolean acceptLeaveConnection(KeyEvent event) {
        int key = event.keyCode;
        return this.getFocus() instanceof ConnectionEditPart && (key == 0x1000001 || key == 0x1000004 || key == 0x1000002 || key == 0x1000003);
    }

    private boolean acceptLeaveContents(KeyEvent event) {
        int key = event.keyCode;
        return this.getFocus() == this.getViewer().getContents() && (key == 0x1000001 || key == 0x1000004 || key == 0x1000002 || key == 0x1000003);
    }

    private boolean acceptOutOf(KeyEvent event) {
        return (event.stateMask & 0x10000) != 0 && event.keyCode == 0x1000003 || event.keyCode == 0x1000003;
    }

    private ConnectionEditPart findConnection(GraphicalEditPart node, ConnectionEditPart current, boolean forward) {
        ArrayList connections = new ArrayList(node.getSourceConnections());
        connections.addAll(node.getTargetConnections());
        if (connections.isEmpty()) {
            return null;
        }
        this.counter = forward ? ++this.counter : --this.counter;
        while (this.counter < 0) {
            this.counter += connections.size();
        }
        this.counter %= connections.size();
        return (ConnectionEditPart)connections.get(this.counter % connections.size());
    }

    private GraphicalEditPart findSibling(List siblings, Point pStart, int direction, EditPart exclude) {
        GraphicalEditPart epFinal = null;
        int distance = Integer.MAX_VALUE;
        Iterator iter = siblings.iterator();
        while (iter.hasNext()) {
            int d;
            GraphicalEditPart epCurrent = (GraphicalEditPart)iter.next();
            if (epCurrent == exclude) continue;
            IFigure figure = epCurrent.getFigure();
            Point pCurrent = this.getInterestingPoint(figure);
            figure.translateToAbsolute((Translatable)pCurrent);
            if (pStart.getPosition(pCurrent) != direction || (d = pCurrent.getDistanceOrthogonal(pStart)) >= distance) continue;
            distance = d;
            epFinal = epCurrent;
        }
        return epFinal;
    }

    Point getInterestingPoint(IFigure figure) {
        return figure.getBounds().getTopLeft();
    }

    private GraphicalEditPart getCachedNode() {
        if (this.cachedNode == null) {
            return null;
        }
        if (this.cachedNode.isEnqueued()) {
            return null;
        }
        return (GraphicalEditPart)this.cachedNode.get();
    }

    GraphicalEditPart getFocus() {
        return (GraphicalEditPart)this.getViewer().getFocusEditPart();
    }

    List getNavigationSiblings() {
        return this.getFocus().getParent().getChildren();
    }

    protected GraphicalViewer getViewer() {
        return this.viewer;
    }

    public boolean keyPressed(KeyEvent event) {
        if (event.character == ' ') {
            this.processSelect(event);
            return true;
        }
        if (this.acceptIntoContainer(event)) {
            this.navigateIntoContainer(event);
            return true;
        }
        if (this.acceptOutOf(event)) {
            this.navigateOut(event);
            return true;
        }
        if (this.acceptConnection(event)) {
            this.navigateConnections(event);
            return true;
        }
        if (this.acceptLeaveConnection(event)) {
            this.navigateOutOfConnection(event);
            return true;
        }
        if (this.acceptLeaveContents(event)) {
            this.navigateIntoContainer(event);
            return true;
        }
        switch (event.keyCode) {
            case 0x1000003: {
                return this.navigateNextSibling(event, 8);
            }
            case 0x1000004: {
                return this.navigateNextSibling(event, 16);
            }
            case 0x1000001: {
                return this.navigateNextSibling(event, 1);
            }
            case 0x1000002: {
                return this.navigateNextSibling(event, 4);
            }
            case 0x1000007: {
                return this.navigateJumpSibling(event, 8);
            }
            case 0x1000008: {
                return this.navigateJumpSibling(event, 16);
            }
            case 0x1000006: {
                return this.navigateJumpSibling(event, 4);
            }
            case 0x1000005: {
                return this.navigateJumpSibling(event, 1);
            }
        }
        return super.keyPressed(event);
    }

    private void navigateConnections(KeyEvent event) {
        GraphicalEditPart focus = this.getFocus();
        ConnectionEditPart current = null;
        GraphicalEditPart node = this.getCachedNode();
        if (focus instanceof ConnectionEditPart) {
            current = (ConnectionEditPart)focus;
            if (node == null || node != current.getSource() && node != current.getTarget()) {
                node = (GraphicalEditPart)current.getSource();
                this.counter = 0;
            }
        } else {
            node = focus;
        }
        this.setCachedNode(node);
        boolean forward = event.character == '/' || event.character == '?';
        ConnectionEditPart next = this.findConnection(node, current, forward);
        this.navigateTo((EditPart)next, event);
    }

    private void navigateIntoContainer(KeyEvent event) {
        GraphicalEditPart focus = this.getFocus();
        List childList = focus.getChildren();
        if (focus instanceof ExpandableGraphNodeEditPart && !((ExpandableGraphNodeEditPart)focus).isExpanded()) {
            ((ExpandableGraphNodeEditPart)focus).doPerformExpandOrCollapse();
        }
        Point tl = focus.getContentPane().getBounds().getTopLeft();
        int minimum = Integer.MAX_VALUE;
        GraphicalEditPart closestPart = null;
        int i = 0;
        while (i < childList.size()) {
            GraphicalEditPart ged = (GraphicalEditPart)childList.get(i);
            Rectangle childBounds = ged.getFigure().getBounds();
            int current = childBounds.x - tl.x + (childBounds.y - tl.y);
            if (current < minimum) {
                minimum = current;
                closestPart = ged;
            }
            ++i;
        }
        if (closestPart != null) {
            this.navigateTo((EditPart)closestPart, event);
        }
    }

    private boolean navigateJumpSibling(KeyEvent event, int direction) {
        return false;
    }

    private boolean navigateNextSibling(KeyEvent event, int direction) {
        GraphicalEditPart epStart = this.getFocus();
        IFigure figure = epStart.getFigure();
        Point pStart = this.getInterestingPoint(figure);
        figure.translateToAbsolute((Translatable)pStart);
        GraphicalEditPart next = this.findSibling(this.getNavigationSiblings(), pStart, direction, (EditPart)epStart);
        if (next == null) {
            return false;
        }
        this.navigateTo((EditPart)next, event);
        return true;
    }

    private void navigateOut(KeyEvent event) {
        if (this.getFocus() == null || this.getFocus() == this.getViewer().getContents() || this.getFocus().getParent() == this.getViewer().getContents()) {
            return;
        }
        EditPart parent = this.getFocus().getParent();
        if ((event.stateMask & 0x10000) != 0 && event.keyCode == 0x1000003 && parent != null && parent instanceof ExpandableGraphNodeEditPart && ((ExpandableGraphNodeEditPart)parent).isExpanded()) {
            ((ExpandableGraphNodeEditPart)parent).doPerformExpandOrCollapse();
        }
        this.navigateTo(parent, event);
    }

    private void navigateOutOfConnection(KeyEvent event) {
        GraphicalEditPart cached = this.getCachedNode();
        ConnectionEditPart conn = (ConnectionEditPart)this.getFocus();
        if (cached != null && (cached == conn.getSource() || cached == conn.getTarget())) {
            this.navigateTo((EditPart)cached, event);
        } else {
            this.navigateTo(conn.getSource(), event);
        }
    }

    void navigateTo(EditPart part, KeyEvent event) {
        if (part == null) {
            return;
        }
        if ((event.stateMask & 0x20000) != 0) {
            this.getViewer().appendSelection(part);
            this.getViewer().setFocus(part);
        } else if ((event.stateMask & 0x40000) != 0) {
            this.getViewer().setFocus(part);
        } else {
            this.getViewer().select(part);
        }
    }

    private void processSelect(KeyEvent event) {
        EditPart part = this.getViewer().getFocusEditPart();
        if ((event.stateMask & 0x40000) != 0 && part.getSelected() != 0) {
            this.getViewer().deselect(part);
        } else {
            this.getViewer().appendSelection(part);
        }
        this.getViewer().setFocus(part);
    }

    private void setCachedNode(GraphicalEditPart node) {
        this.cachedNode = node == null ? null : new WeakReference<GraphicalEditPart>(node);
    }
}

