/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.dialogs.types.xsd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.dialogs.types.common.IComponentList;
import org.eclipse.wst.xsd.ui.internal.dialogs.types.xml.XMLComponentSelectionProvider;
import org.eclipse.wst.xsd.ui.internal.dialogs.types.xml.XMLComponentSpecification;
import org.eclipse.wst.xsd.ui.internal.dialogs.types.xsd.XSDComponentFinder;
import org.eclipse.wst.xsd.ui.internal.dialogs.types.xsd.XSDComponentSelectionDialog;
import org.eclipse.wst.xsd.ui.internal.util.TypesHelper;
import org.eclipse.wst.xsd.ui.internal.util.XSDDOMHelper;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDRedefine;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.impl.XSDImportImpl;

public class XSDComponentSelectionProvider
extends XMLComponentSelectionProvider {
    private XSDComponentFinder xsdComponentFinder = new XSDComponentFinder();
    private XSDComponentSelectionDialog dialog;
    private XSDSchema schema;
    private XSDComponentLabelProvider labelProvider;
    private boolean showComplexTypes = true;

    public XSDComponentSelectionProvider(IFile file, XSDSchema schema) {
        this.xsdComponentFinder.setFile(file);
        this.schema = schema;
        this.labelProvider = new XSDComponentLabelProvider();
    }

    public void setDialog(XSDComponentSelectionDialog dialog) {
        this.dialog = dialog;
    }

    public void showComplexTypes(boolean show) {
        this.showComplexTypes = show;
    }

    public String getType(Object element) {
        return null;
    }

    public void getComponents(IComponentList list, boolean quick) {
        if (quick) {
            Iterator builtInIt = this.getBuiltInTypes().iterator();
            while (builtInIt.hasNext()) {
                XMLComponentSpecification tagItem = (XMLComponentSpecification)builtInIt.next();
                this.addDataItemToTreeNode(list, tagItem);
            }
            this.createComplexTypes(list);
            this.createSimpleTypes(list);
        } else {
            this.getComponents(list);
        }
    }

    private void getComponents(IComponentList list) {
        XMLComponentSpecification item;
        ArrayList<String> extensions = new ArrayList<String>();
        extensions.add("xsd");
        String scope = "";
        if (this.dialog != null) {
            scope = this.dialog.getSearchScope();
        }
        List comps = new ArrayList();
        if (scope.equals(XSDComponentSelectionDialog.SCOPE_ENCLOSING_PROJECT)) {
            comps = this.xsdComponentFinder.getWorkbenchResourceComponents(0);
        } else if (scope.equals(XSDComponentSelectionDialog.SCOPE_WORKSPACE)) {
            comps = this.xsdComponentFinder.getWorkbenchResourceComponents(1);
        }
        ArrayList<XMLComponentSpecification> complex = new ArrayList<XMLComponentSpecification>();
        ArrayList<XMLComponentSpecification> simple = new ArrayList<XMLComponentSpecification>();
        Iterator itemsIterator = comps.iterator();
        while (itemsIterator.hasNext()) {
            XMLComponentSpecification tagItem = (XMLComponentSpecification)itemsIterator.next();
            if (tagItem.getTagPath().equals("/schema/complexType")) {
                complex.add(tagItem);
                continue;
            }
            if (!tagItem.getTagPath().equals("/schema/simpleType")) continue;
            simple.add(tagItem);
        }
        Iterator complexIt = complex.iterator();
        Iterator simpleIt = simple.iterator();
        if (this.showComplexTypes) {
            while (complexIt.hasNext()) {
                item = (XMLComponentSpecification)complexIt.next();
                this.addDataItemToTreeNode(list, item);
            }
        }
        while (simpleIt.hasNext()) {
            item = (XMLComponentSpecification)simpleIt.next();
            this.addDataItemToTreeNode(list, item);
        }
        this.createFromImport(list);
        this.createFromInclude(list);
        this.createFromRedefine(list);
    }

    private List getBuiltInTypes() {
        ArrayList<String> items = new ArrayList<String>();
        int i = 0;
        while (i < XSDDOMHelper.dataType.length) {
            items.add(XSDDOMHelper.dataType[i][0]);
            ++i;
        }
        Iterator it = items.iterator();
        ArrayList<XMLComponentSpecification> builtInComponentSpecs = new ArrayList<XMLComponentSpecification>();
        while (it.hasNext()) {
            Object item = it.next();
            String itemString = item.toString();
            XMLComponentSpecification builtInTypeItem = new XMLComponentSpecification("BUILT_IN_SIMPLE_TYPE");
            builtInTypeItem.addAttributeInfo("name", itemString);
            builtInTypeItem.setTargetNamespace("http://www.w3.org/2001/XMLSchema");
            builtInTypeItem.setFileLocation("Built-In");
            builtInComponentSpecs.add(builtInTypeItem);
        }
        return builtInComponentSpecs;
    }

    private void createComplexTypes(IComponentList treeObjectList) {
        TypesHelper typesHelper = new TypesHelper(this.schema);
        List complexTypes = typesHelper.getUserComplexTypes();
        this.createComplexSimpleTreeObject(treeObjectList, complexTypes, true);
    }

    private void createSimpleTypes(IComponentList treeObjectList) {
        TypesHelper typesHelper = new TypesHelper(this.schema);
        List complexTypes = typesHelper.getUserSimpleTypes();
        this.createComplexSimpleTreeObject(treeObjectList, complexTypes, true);
    }

    private void createFromImport(IComponentList treeObjectList) {
        Iterator imports = this.getXSDImports().iterator();
        while (imports.hasNext()) {
            XSDImport importItem = (XSDImport)imports.next();
            if (importItem.getSchemaLocation() == null) continue;
            ((XSDImportImpl)importItem).importSchema();
            TypesHelper helper = new TypesHelper(importItem.getResolvedSchema());
            List types = helper.getUserComplexTypes();
            types.addAll(helper.getUserSimpleTypes());
            this.createComplexSimpleTreeObject(treeObjectList, types, false);
        }
    }

    private void createFromInclude(IComponentList treeObjectList) {
        Iterator imports = this.getXSDIncludes().iterator();
        while (imports.hasNext()) {
            XSDInclude includeItem = (XSDInclude)imports.next();
            if (includeItem.getSchemaLocation() == null) continue;
            TypesHelper helper = new TypesHelper(includeItem.getResolvedSchema());
            List types = helper.getUserComplexTypes();
            types.addAll(helper.getUserSimpleTypes());
            this.createComplexSimpleTreeObject(treeObjectList, types, false);
        }
    }

    private void createFromRedefine(IComponentList treeObjectList) {
        Iterator redefines = this.getXSDRedefines().iterator();
        while (redefines.hasNext()) {
            XSDRedefine redefineItem = (XSDRedefine)redefines.next();
            if (redefineItem.getSchemaLocation() == null) continue;
            TypesHelper helper = new TypesHelper(redefineItem.getResolvedSchema());
            List types = helper.getUserComplexTypes();
            types.addAll(helper.getUserSimpleTypes());
            this.createComplexSimpleTreeObject(treeObjectList, types, false);
        }
    }

    protected List getXSDImports() {
        ArrayList<XSDSchemaContent> imports = new ArrayList<XSDSchemaContent>();
        Iterator contents = this.schema.getContents().iterator();
        while (contents.hasNext()) {
            XSDSchemaContent content = (XSDSchemaContent)contents.next();
            if (!(content instanceof XSDImport)) continue;
            imports.add(content);
        }
        return imports;
    }

    protected List getXSDIncludes() {
        ArrayList<XSDSchemaContent> includes = new ArrayList<XSDSchemaContent>();
        Iterator contents = this.schema.getContents().iterator();
        while (contents.hasNext()) {
            XSDSchemaContent content = (XSDSchemaContent)contents.next();
            if (!(content instanceof XSDInclude)) continue;
            includes.add(content);
        }
        return includes;
    }

    protected List getXSDRedefines() {
        ArrayList<XSDSchemaContent> includes = new ArrayList<XSDSchemaContent>();
        Iterator contents = this.schema.getContents().iterator();
        while (contents.hasNext()) {
            XSDSchemaContent content = (XSDSchemaContent)contents.next();
            if (!(content instanceof XSDRedefine)) continue;
            includes.add(content);
        }
        return includes;
    }

    private void createComplexSimpleTreeObject(IComponentList treeObjectList, List complexTypes, boolean sameNS) {
        boolean proceed = true;
        int i = 0;
        while (i < complexTypes.size()) {
            XSDNamedComponent item = (XSDNamedComponent)complexTypes.get(i);
            if (sameNS) {
                String itemLocation = item.getSchema().getSchemaLocation();
                String currentSchemaLocation = this.schema.getSchemaLocation();
                proceed = itemLocation != null ? itemLocation.equals(currentSchemaLocation) : false;
            }
            if (proceed) {
                XMLComponentSpecification typeItem = null;
                if (this.showComplexTypes && item instanceof XSDComplexTypeDefinition) {
                    typeItem = new XMLComponentSpecification("/schema/complexType");
                    typeItem.addAttributeInfo("name", ((XSDComplexTypeDefinition)item).getName());
                } else if (item instanceof XSDSimpleTypeDefinition) {
                    typeItem = new XMLComponentSpecification("/schema/simpleType");
                    typeItem.addAttributeInfo("name", ((XSDSimpleTypeDefinition)item).getName());
                }
                if (typeItem != null) {
                    typeItem.setTargetNamespace(item.getTargetNamespace());
                    String normalizedFile = this.getNormalizedLocation(this.schema.getSchemaLocation());
                    typeItem.setFileLocation(normalizedFile);
                    this.addDataItemToTreeNode(treeObjectList, typeItem);
                }
            }
            ++i;
        }
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public String getListTitle() {
        return XSDEditorPlugin.getXSDString("_UI_LABEL_MATCHING_TYPES");
    }

    public String getNameFieldTitle() {
        return XSDEditorPlugin.getXSDString("_UI_LABEL_TYPE_NAME");
    }

    public class XSDComponentLabelProvider
    extends XMLComponentSelectionProvider.XMLComponentSelectionLabelProvider {
        public Image getImage(Object element) {
            XMLComponentSelectionProvider.XMLComponentTreeObject specification = (XMLComponentSelectionProvider.XMLComponentTreeObject)element;
            XMLComponentSpecification spec = (XMLComponentSpecification)specification.getXMLComponentSpecification().get(0);
            if (spec.getTagPath().equals("/schema/complexType")) {
                return XSDEditorPlugin.getXSDImage("icons/XSDComplexType.gif");
            }
            if (spec.getTagPath().equals("/schema/simpleType")) {
                return XSDEditorPlugin.getXSDImage("icons/XSDSimpleType.gif");
            }
            if (spec.getTagPath().equals("BUILT_IN_SIMPLE_TYPE")) {
                return XSDEditorPlugin.getXSDImage("icons/XSDSimpleType.gif");
            }
            return null;
        }
    }
}

