/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.contentmodel.util;

import java.util.StringTokenizer;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMNamespaceHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class NamespaceAttributeVisitor {
    public static final String XML_SCHEMA_INSTANCE_URI = "http://www.w3.org/2001/XMLSchema-instance";
    public String xsiPrefix = "xsi";

    public void visitXMLNamespaceAttribute(Attr attr, String namespacePrefix, String namespaceURI) {
        if (namespaceURI.equals(XML_SCHEMA_INSTANCE_URI)) {
            this.xsiPrefix = namespacePrefix;
        }
    }

    public void visitXSINoNamespaceSchemaLocationAttribute(Attr attr, String value) {
    }

    public void visitXSISchemaLocationAttribute(Attr attr, String value) {
        StringTokenizer st = new StringTokenizer(value);
        while (true) {
            String locationHint;
            String nsURI = st.hasMoreTokens() ? st.nextToken() : null;
            String string = locationHint = st.hasMoreTokens() ? st.nextToken() : null;
            if (nsURI == null || locationHint == null) break;
            this.visitXSISchemaLocationValuePair(nsURI, locationHint);
        }
    }

    public void visitXSISchemaLocationValuePair(String uri, String locationHint) {
    }

    public void visitElement(Element element) {
        NamedNodeMap map = element.getAttributes();
        int mapLength = map.getLength();
        int i = 0;
        while (i < mapLength) {
            Attr attr = (Attr)map.item(i);
            String prefix = DOMNamespaceHelper.getPrefix(attr.getName());
            String unprefixedName = DOMNamespaceHelper.getUnprefixedName(attr.getName());
            if (prefix != null && unprefixedName != null) {
                if (prefix.equals("xmlns")) {
                    this.visitXMLNamespaceAttribute(attr, unprefixedName, attr.getValue());
                } else if (prefix.equals(this.xsiPrefix) && unprefixedName.equals("schemaLocation")) {
                    this.visitXSISchemaLocationAttribute(attr, attr.getValue());
                } else if (prefix.equals(this.xsiPrefix) && unprefixedName.equals("noNamespaceSchemaLocation")) {
                    this.visitXSINoNamespaceSchemaLocationAttribute(attr, attr.getValue());
                }
            } else if (unprefixedName != null && unprefixedName.equals("xmlns")) {
                this.visitXMLNamespaceAttribute(attr, "", attr.getValue());
            }
            ++i;
        }
    }
}

