/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.catalog;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.INextCatalog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class CatalogWriter {
    private Document doc;

    public void write(ICatalog xmlCatalog, String uri) throws FileNotFoundException, IOException {
        this.visitCatalog(xmlCatalog);
        OutputStream outputStream = this.getOutputStream(uri, true);
        this.serialize(outputStream);
    }

    public void write(ICatalog catalog, OutputStream os) throws FileNotFoundException, IOException {
        if (catalog != null) {
            this.visitCatalog(catalog);
            this.serialize(os);
        }
    }

    private void visitCatalog(ICatalog xmlCatalog) {
        try {
            this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            Logger.logException(e);
        }
        if (this.doc == null) {
            return;
        }
        Element catalogElement = this.doc.createElementNS("urn:oasis:names:tc:entity:xmlns:xml:catalog", "catalog");
        this.doc.appendChild(catalogElement);
        this.processCatalogEntries(xmlCatalog, catalogElement);
        this.processNextCatalogs(xmlCatalog, catalogElement);
    }

    private void processCatalogEntries(ICatalog catalog, Element parent) {
        ICatalogEntry[] catalogEntries = catalog.getCatalogEntries();
        int i = 0;
        while (i < catalogEntries.length) {
            ICatalogEntry entry = catalogEntries[i];
            String key = entry.getKey();
            String uri = entry.getURI();
            String id = entry.getId();
            Element childElement = null;
            switch (entry.getEntryType()) {
                case 2: {
                    childElement = parent.getOwnerDocument().createElement("public");
                    if (childElement == null) break;
                    childElement.setAttribute("publicId", key);
                    childElement.setAttribute("uri", uri);
                    break;
                }
                case 3: {
                    childElement = parent.getOwnerDocument().createElement("system");
                    if (childElement == null) break;
                    childElement.setAttribute("systemId", key);
                    childElement.setAttribute("uri", uri);
                    break;
                }
                case 4: {
                    childElement = parent.getOwnerDocument().createElement("uri");
                    if (childElement == null) break;
                    childElement.setAttribute("name", key);
                    childElement.setAttribute("uri", uri);
                    break;
                }
            }
            if (childElement != null && id != null && !id.equals("")) {
                childElement.setAttribute("id", id);
            }
            String[] attributes = entry.getAttributes();
            int j = 0;
            while (j < attributes.length) {
                String attrName = attributes[j];
                if (attrName != null && !attrName.equals("")) {
                    String attrValue = entry.getAttributeValue(attrName);
                    if (childElement != null && attrValue != null) {
                        childElement.setAttribute(attrName, attrValue);
                    }
                }
                ++j;
            }
            if (childElement != null) {
                parent.appendChild(childElement);
            }
            ++i;
        }
    }

    private void processNextCatalogs(ICatalog catalog, Element parent) {
        INextCatalog[] nextCatalogs = catalog.getNextCatalogs();
        Element childElement = null;
        int i = 0;
        while (i < nextCatalogs.length) {
            INextCatalog delegate = nextCatalogs[i];
            childElement = parent.getOwnerDocument().createElement("nextCatalog");
            if (childElement != null) {
                String id;
                parent.appendChild(childElement);
                String location = delegate.getCatalogLocation();
                if (location != null) {
                    childElement.setAttribute("catalog", location);
                }
                if ((id = delegate.getId()) != null) {
                    childElement.setAttribute("id", id);
                }
            }
            ++i;
        }
    }

    private void serialize(OutputStream outputStream) throws FileNotFoundException, IOException {
        if (this.doc == null) {
            return;
        }
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            String encoding = "UTF-8";
            if (encoding != null) {
                transformer.setOutputProperty("encoding", encoding);
            }
            transformer.transform(new DOMSource(this.doc), new StreamResult(outputStream));
        }
        catch (TransformerException e) {
            Logger.logException(e);
        }
    }

    private OutputStream getOutputStream(String uri, boolean overwrite) throws FileNotFoundException, IOException {
        File parent;
        String filePath = CatalogWriter.removeProtocol(uri);
        File file = new File(filePath);
        if (file.exists() && overwrite) {
            file.delete();
        }
        if (!(parent = file.getParentFile()).exists()) {
            parent.mkdirs();
        }
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            Logger.logException(e);
        }
        FileOutputStream stream = new FileOutputStream(filePath);
        return stream;
    }

    protected static String removeProtocol(String uri) {
        int index;
        String result = uri;
        String protocol_pattenrn = ":";
        if (uri != null && (index = uri.indexOf(protocol_pattenrn)) > 2) {
            result = result.substring(index + protocol_pattenrn.length());
        }
        return result;
    }
}

