/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.navigator.internal.workingsets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.j2ee.navigator.internal.workingsets.ComponentWorkingSetDescriptor;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.wst.common.navigator.internal.plugin.WorkbenchNavigatorPlugin;
import org.eclipse.wst.common.navigator.internal.views.extensions.RegistryReader;

public class ComponentWorkingSetRegistry {
    private static final ComponentWorkingSetRegistry INSTANCE = new ComponentWorkingSetRegistry();
    private static boolean isInitialized = false;
    private static final String[] NO_DESCRIPTORS = new String[0];
    private List commonWorkingSetDescriptors = new ArrayList();

    public void init() {
        new ComponentWorkingSetRegistryReader().readRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComponentWorkingSetRegistry getInstance() {
        if (isInitialized) {
            return INSTANCE;
        }
        ComponentWorkingSetRegistry componentWorkingSetRegistry = INSTANCE;
        synchronized (componentWorkingSetRegistry) {
            if (!isInitialized) {
                INSTANCE.init();
                isInitialized = true;
            }
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCommonWorkingSetDescriptor(ComponentWorkingSetDescriptor aDesc) {
        if (aDesc == null) {
            return;
        }
        List list = this.commonWorkingSetDescriptors;
        synchronized (list) {
            boolean bValue = this.commonWorkingSetDescriptors.contains(aDesc);
            if (!bValue) {
                this.commonWorkingSetDescriptors.add(aDesc);
            }
        }
    }

    public ComponentWorkingSetDescriptor[] getComponentWorkingSetDescriptors() {
        ComponentWorkingSetDescriptor[] descriptors = new ComponentWorkingSetDescriptor[this.commonWorkingSetDescriptors.size()];
        return this.commonWorkingSetDescriptors.toArray(descriptors);
    }

    public boolean containsId(String id) {
        ComponentWorkingSetDescriptor descriptor = null;
        int x = 0;
        while (x < this.commonWorkingSetDescriptors.size()) {
            descriptor = (ComponentWorkingSetDescriptor)this.commonWorkingSetDescriptors.get(x);
            if (descriptor.getId().equals(id)) {
                return true;
            }
            ++x;
        }
        return false;
    }

    public ComponentWorkingSetDescriptor getWorkingSetDescriptor(String editPageId, String typeId) {
        ComponentWorkingSetDescriptor[] descriptors = this.getComponentWorkingSetDescriptors();
        ComponentWorkingSetDescriptor descriptor = null;
        int x = 0;
        while (x < descriptors.length) {
            descriptor = descriptors[x];
            if (descriptor.getId().equals(editPageId) && descriptor.getTypeId().equals(typeId)) {
                return descriptor;
            }
            ++x;
        }
        return null;
    }

    class ComponentWorkingSetRegistryReader
    extends RegistryReader {
        private static final String COMPONENT_WORKING_SET = "componentWorkingSet";

        ComponentWorkingSetRegistryReader() {
            super("org.eclipse.jst.j2ee.navigator.ui", COMPONENT_WORKING_SET);
        }

        protected boolean readElement(IConfigurationElement anElement) {
            if (COMPONENT_WORKING_SET.equals(anElement.getName())) {
                try {
                    ComponentWorkingSetRegistry.this.addCommonWorkingSetDescriptor(new ComponentWorkingSetDescriptor(anElement));
                    return true;
                }
                catch (WorkbenchException e) {
                    WorkbenchNavigatorPlugin.log((String)"Unable to create common working set descriptor.", (IStatus)e.getStatus());
                }
            }
            return false;
        }
    }
}

