/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emfworkbench.integration;

import java.util.HashMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.internal.emf.utilities.FeatureValueConversionException;
import org.eclipse.wst.common.internal.emf.utilities.FeatureValueConverter;
import org.eclipse.wst.common.internal.emfworkbench.integration.OwnerProvider;

public class ModifierHelper {
    private EObject owner;
    private ModifierHelper ownerHelper;
    private OwnerProvider ownerProvider;
    private Object value;
    private EStructuralFeature feature;
    private HashMap attributes;
    private boolean shouldUnsetValue = false;
    private String valueXSITypeName;
    private FeatureValueConverter featureValueConverter;
    public static final int ACTION_SET = 0;
    public static final int ACTION_UNSET = 1;
    public static final int ACTION_BOTH = 2;

    public ModifierHelper() {
    }

    public ModifierHelper(EObject anOwner, EStructuralFeature aFeature, Object aValue) {
        this.setOwner(anOwner);
        this.setFeature(aFeature);
        this.setValue(aValue);
    }

    public ModifierHelper(ModifierHelper anOwnerHelper, EStructuralFeature aFeature, Object aValue) {
        this.setOwnerHelper(anOwnerHelper);
        this.setFeature(aFeature);
        this.setValue(aValue);
    }

    public ModifierHelper(OwnerProvider anOwnerProvider, EStructuralFeature aFeature, Object aValue) {
        this.setOwnerProvider(anOwnerProvider);
        this.setFeature(aFeature);
        this.setValue(aValue);
    }

    public void addAttribute(EStructuralFeature aFeature, Object aValue) {
        if (aFeature != null && aValue != null) {
            this.getAttributes().put(aFeature, aValue);
        }
    }

    protected Object convertValue(Object newValue) {
        return this.getFeatureValueConverter().convertValue(newValue, this.getFeature());
    }

    public void doUnsetValue() {
        this.shouldUnsetValue = true;
        if (this.value != null && this.feature != null && !this.feature.isMany()) {
            this.setValue(null);
        }
    }

    public HashMap getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        return this.attributes;
    }

    protected EFactory getFactory() {
        return this.getPackage().getEFactoryInstance();
    }

    protected EPackage getPackage() {
        return ((EClassImpl)this.getFeatureType()).getEPackage();
    }

    public EStructuralFeature getFeature() {
        return this.feature;
    }

    protected EObject getFeatureType() {
        return this.getFeature().getEType();
    }

    public FeatureValueConverter getFeatureValueConverter() {
        if (this.featureValueConverter == null) {
            this.featureValueConverter = FeatureValueConverter.DEFAULT;
        }
        return this.featureValueConverter;
    }

    protected String getNewValueTypeName() {
        if (this.getValueXSITypeName() != null && this.getValueXSITypeName().length() > 0) {
            return this.getValueXSITypeName();
        }
        return ((EClass)this.getFeatureType()).getName();
    }

    public EObject getOwner() {
        if (this.owner == null) {
            OwnerProvider provider = this.getOwnerProvider();
            EObject providerOwner = null;
            if (provider != null) {
                providerOwner = provider.getOwner();
            }
            if (providerOwner == null && this.getOwnerHelper() != null) {
                providerOwner = (EObject)this.getOwnerHelper().getValue();
            }
            return providerOwner;
        }
        return this.owner;
    }

    public ModifierHelper getOwnerHelper() {
        if (this.ownerHelper == null && this.getOwnerProvider() != null && this.getOwnerProvider().getOwner() == null) {
            return this.getOwnerProvider().getOwnerHelper();
        }
        return this.ownerHelper;
    }

    public ModifierHelper primGetOwnerHelper() {
        return this.ownerHelper;
    }

    public OwnerProvider getOwnerProvider() {
        return this.ownerProvider;
    }

    public Object getValue() {
        return this.value;
    }

    public String getValueXSITypeName() {
        return this.valueXSITypeName;
    }

    public boolean isComplete() {
        boolean result = true;
        if (this.getOwnerHelper() != null) {
            result = this.getOwnerHelper().isComplete();
        }
        if (!this.mustCreateValue()) {
            result = this.getValue() != null || this.shouldUnsetValue();
        } else {
            boolean bl = result = this.getFeatureType() != null;
        }
        return result && this.getFeature() != null && (this.getOwner() != null || this.getOwnerHelper() != null);
    }

    public boolean mustCreateValue() {
        return this.getValue() == null && this.getFeature() != null && !this.shouldUnsetValue();
    }

    public void primSetValue(Object newValue) {
        this.value = newValue;
    }

    public void setFeature(EStructuralFeature newFeature) {
        this.feature = newFeature;
    }

    public void setFeatureValueConverter(FeatureValueConverter newFeatureValueConverter) {
        this.featureValueConverter = newFeatureValueConverter;
    }

    public void setOwner(EObject newOwner) {
        this.owner = newOwner;
    }

    public void setOwnerHelper(ModifierHelper newOwnerHelper) {
        this.ownerHelper = newOwnerHelper;
    }

    public void setOwnerProvider(OwnerProvider newOwnerProvider) {
        this.ownerProvider = newOwnerProvider;
    }

    public void setValue(Object newValue) {
        try {
            this.primSetValue(this.convertValue(newValue));
        }
        catch (FeatureValueConversionException featureException) {
            Logger.getLogger().logError((Throwable)featureException);
            this.primSetValue(null);
        }
    }

    public void setValueFromWidget(String newValue) {
        String data = newValue;
        if (newValue != null && newValue.length() == 0) {
            data = null;
        }
        this.setValue(data);
        if (data == null) {
            this.doUnsetValue();
        } else {
            this.shouldUnsetValue = false;
        }
    }

    public void setValueXSITypeName(String newValueXSITypeName) {
        this.valueXSITypeName = newValueXSITypeName;
    }

    public boolean shouldUnsetValue() {
        return this.shouldUnsetValue;
    }

    public EObject createNewObjectFromFeature() {
        EClass metaClass = (EClass)this.getPackage().getEClassifier(this.getNewValueTypeName());
        return this.getFactory().create(metaClass);
    }
}

