/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.navigator.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetPage;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.common.navigator.internal.provisional.views.CommonSorter;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentService;

public class CommonWorkingSetPage
extends WizardPage
implements IWorkingSetPage {
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 50;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 200;
    private Text text;
    private CheckboxTreeViewer tree;
    private IWorkingSet workingSet;
    private boolean firstCheck = false;
    private NavigatorContentService service;
    private ITreeContentProvider contentProvider;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CommonWorkingSetPage() {
        super("commonWorkingSetPage", WorkingSetMessages.getString("CommonWorkingSetPage.title"), null);
        this.setDescription(WorkingSetMessages.getString("CommonWorkingSetPage.description"));
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(256));
        this.setControl((Control)composite);
        Label label = new Label(composite, 64);
        label.setText(WorkingSetMessages.getString("CommonWorkingSetPage.workingSet.name"));
        GridData data = new GridData(772);
        label.setLayoutData((Object)data);
        label.setFont(font);
        this.text = new Text(composite, 2052);
        this.text.setLayoutData((Object)new GridData(768));
        this.text.setFont(font);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommonWorkingSetPage.this.validateInput();
            }
        });
        this.text.setFocus();
        label = new Label(composite, 64);
        label.setText(WorkingSetMessages.getString("CommonWorkingSetPage.workingSet.content"));
        data = new GridData(772);
        label.setLayoutData((Object)data);
        label.setFont(font);
        this.tree = new CheckboxTreeViewer(composite);
        this.tree.setUseHashlookup(true);
        this.service = new NavigatorContentService(null);
        this.service.addExclusion("org.eclipse.wst.common.navigator.workingsets");
        this.contentProvider = this.service.createCommonContentProvider();
        this.tree.setContentProvider((IContentProvider)this.contentProvider);
        this.tree.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider(this.service.createCommonLabelProvider(), IDEWorkbenchPlugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.tree.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.tree.setSorter((ViewerSorter)new CommonSorter(this.service));
        data = new GridData(1808);
        data.heightHint = 200;
        data.widthHint = 50;
        this.tree.getControl().setLayoutData((Object)data);
        this.tree.getControl().setFont(font);
        this.tree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                CommonWorkingSetPage.this.handleCheckStateChange(event);
            }
        });
        this.tree.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                Object element = event.getElement();
                if (!CommonWorkingSetPage.this.tree.getGrayed(element)) {
                    BusyIndicator.showWhile((Display)CommonWorkingSetPage.this.getShell().getDisplay(), (Runnable)new Runnable(this, element){
                        final /* synthetic */ 3 this$1;
                        private final /* synthetic */ Object val$element;
                        {
                            this.this$1 = var1_1;
                            this.val$element = object;
                        }

                        public void run() {
                            CommonWorkingSetPage.access$3(3.access$0(this.this$1), this.val$element, CommonWorkingSetPage.access$2(3.access$0(this.this$1)).getChecked(this.val$element), false);
                        }
                    });
                }
            }

            static /* synthetic */ CommonWorkingSetPage access$0(3 var0) {
                return var0.CommonWorkingSetPage.this;
            }
        });
        this.initializeCheckedState();
        if (this.workingSet != null) {
            this.text.setText(this.workingSet.getName());
        }
        this.setPageComplete(false);
    }

    private void findCheckedResources(List checkedResources, Object parent) {
        Object[] children = null;
        children = this.getChildren(parent);
        int i = 0;
        while (i < children.length) {
            if (this.tree.getGrayed(children[i])) {
                this.findCheckedResources(checkedResources, children[i]);
            } else if (this.tree.getChecked(children[i])) {
                checkedResources.add(children[i]);
            }
            ++i;
        }
    }

    public void finish() {
        ArrayList resources = new ArrayList(10);
        this.findCheckedResources(resources, this.tree.getInput());
        if (this.workingSet == null) {
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            this.workingSet = workingSetManager.createWorkingSet(this.getWorkingSetName(), resources.toArray(new IAdaptable[resources.size()]));
        } else {
            this.workingSet.setName(this.getWorkingSetName());
            this.workingSet.setElements(resources.toArray(new IAdaptable[resources.size()]));
        }
    }

    public IWorkingSet getSelection() {
        return this.workingSet;
    }

    private String getWorkingSetName() {
        return this.text.getText();
    }

    private void handleCheckStateChange(final CheckStateChangedEvent event) {
        new UIJob("Updating Checked State"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                Object element = event.getElement();
                boolean state = event.getChecked();
                CommonWorkingSetPage.this.tree.setGrayed(element, false);
                CommonWorkingSetPage.this.setSubtreeChecked(element, state, true);
                CommonWorkingSetPage.this.updateParentState(element);
                CommonWorkingSetPage.this.validateInput();
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void initializeCheckedState() {
        if (this.workingSet == null) {
            return;
        }
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                Object[] items = CommonWorkingSetPage.this.workingSet.getElements();
                CommonWorkingSetPage.this.tree.setCheckedElements(items);
                int i = 0;
                while (i < items.length) {
                    Object item = items[i];
                    IContainer container = null;
                    IResource resource = null;
                    if (item instanceof IContainer) {
                        container = (IContainer)item;
                    } else {
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.core.resources.IContainer");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        container = (IContainer)item.getAdapter((Class)clazz);
                    }
                    if (container != null) {
                        CommonWorkingSetPage.this.setSubtreeChecked(container, true, true);
                    }
                    if (item instanceof IResource) {
                        resource = (IResource)item;
                    } else {
                        Class<?> clazz = class$1;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.core.resources.IResource");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        resource = (IResource)item.getAdapter((Class)clazz);
                    }
                    if (resource != null && !resource.isAccessible()) {
                        IProject project = resource.getProject();
                        if (!CommonWorkingSetPage.this.tree.getChecked((Object)project)) {
                            CommonWorkingSetPage.this.tree.setGrayChecked((Object)project, true);
                        }
                    } else {
                        CommonWorkingSetPage.this.updateParentState(resource);
                    }
                    ++i;
                }
            }
        });
    }

    public void setSelection(IWorkingSet workingSet) {
        if (workingSet == null) {
            throw new IllegalArgumentException("Working set must not be null");
        }
        this.workingSet = workingSet;
        if (this.getShell() != null && this.text != null) {
            this.firstCheck = true;
            this.initializeCheckedState();
            this.text.setText(workingSet.getName());
        }
    }

    private void setSubtreeChecked(Object parent, boolean state, boolean checkExpandedState) {
        Object[] children = null;
        children = this.getChildren(parent);
        int i = children.length - 1;
        while (i >= 0) {
            Object element = children[i];
            boolean elementGrayChecked = this.tree.getGrayed(element) || this.tree.getChecked(element);
            boolean elementExpanded = this.tree.getExpandedState(element);
            if (state) {
                this.tree.setChecked(element, true);
                this.tree.setGrayed(element, false);
            } else {
                this.tree.setGrayChecked(element, false);
            }
            if (elementExpanded && (state || elementGrayChecked)) {
                this.setSubtreeChecked(element, state, true);
            }
            --i;
        }
    }

    private void updateParentState(Object element) {
        if (element == null || this.getParent(element) == null) {
            return;
        }
        Object parent = this.getParent(element);
        boolean childChecked = false;
        Object[] children = this.getChildren(parent);
        int i = children.length - 1;
        while (i >= 0) {
            if (this.tree.getChecked(children[i]) || this.tree.getGrayed(children[i])) {
                childChecked = true;
                break;
            }
            --i;
        }
        this.tree.setGrayChecked(parent, childChecked);
        this.updateParentState(parent);
    }

    private Object[] getChildren(Object parent) {
        return this.contentProvider.getChildren(parent);
    }

    private Object getParent(Object element) {
        return this.contentProvider.getParent(element);
    }

    private void validateInput() {
        String errorMessage = null;
        String newText = this.text.getText();
        if (!newText.equals(newText.trim())) {
            errorMessage = WorkingSetMessages.getString("CommonWorkingSetPage.warning.nameWhitespace");
        } else if (this.firstCheck) {
            this.firstCheck = false;
            return;
        }
        if (newText.equals("")) {
            errorMessage = WorkingSetMessages.getString("CommonWorkingSetPage.warning.nameMustNotBeEmpty");
        }
        if (!(errorMessage != null || this.workingSet != null && newText.equals(this.workingSet.getName()))) {
            IWorkingSet[] workingSets = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
            int i = 0;
            while (i < workingSets.length) {
                if (newText.equals(workingSets[i].getName())) {
                    errorMessage = WorkingSetMessages.getString("CommonWorkingSetPage.warning.workingSetExists");
                }
                ++i;
            }
        }
        if (errorMessage == null && this.tree.getCheckedElements().length == 0) {
            errorMessage = WorkingSetMessages.getString("CommonWorkingSetPage.warning.resourceMustBeChecked");
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }
}

