/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.navigator.internal.actions;

import java.util.Iterator;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.ui.actions.RefreshAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jst.common.navigator.internal.actions.ActionMessages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.BuildAction;
import org.eclipse.ui.actions.CloseResourceAction;
import org.eclipse.ui.actions.OpenResourceAction;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonActionProvider;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentService;
import org.eclipse.wst.common.navigator.internal.views.actions.CommonActionProvider;

public class ProjectMgmtActionsExtension
extends CommonActionProvider
implements ICommonActionProvider {
    private OpenResourceAction openProjectAction;
    private CloseResourceAction closeProjectAction;
    private BuildAction buildAction;
    private BuildAction rebuildAction;
    private RefreshAction refreshAction;
    private ActionContext actionContext;
    static /* synthetic */ Class class$0;

    public void init(IViewPart aViewPart, StructuredViewer aViewer, NavigatorContentService aContentService) {
        Shell shell = aViewPart.getViewSite() != null ? aViewPart.getViewSite().getShell() : null;
        this.openProjectAction = new OpenResourceAction(shell);
        this.closeProjectAction = new CloseResourceAction(shell);
        this.buildAction = new BuildAction(shell, 10);
        this.buildAction.setText(ActionMessages.BuildAction_label);
        this.rebuildAction = new BuildAction(shell, 6);
        this.rebuildAction.setText(ActionMessages.RebuildAction_label);
        this.refreshAction = new RefreshAction((IWorkbenchSite)aViewPart.getViewSite());
    }

    public void dispose() {
    }

    public boolean fillActionBars(IActionBars actionBars) {
        if (actionBars != null) {
            IStructuredSelection selection = this.getStructureSelection();
            this.setSelection(selection);
            actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.refreshAction);
            actionBars.setGlobalActionHandler(IDEActionFactory.BUILD_PROJECT.getId(), (IAction)this.buildAction);
            actionBars.setGlobalActionHandler(IDEActionFactory.REBUILD_PROJECT.getId(), (IAction)this.rebuildAction);
            actionBars.setGlobalActionHandler(IDEActionFactory.OPEN_PROJECT.getId(), (IAction)this.openProjectAction);
            actionBars.setGlobalActionHandler(IDEActionFactory.CLOSE_PROJECT.getId(), (IAction)this.closeProjectAction);
        }
        return true;
    }

    private void setSelection(IStructuredSelection selection) {
        if (selection != null) {
            this.refreshAction.selectionChanged(selection);
            this.buildAction.selectionChanged(selection);
            this.rebuildAction.selectionChanged(selection);
            this.openProjectAction.selectionChanged(selection);
            this.closeProjectAction.selectionChanged(selection);
        }
    }

    public void setActionContext(ActionContext aContext) {
        this.actionContext = aContext;
    }

    private IStructuredSelection getStructureSelection() {
        if (this.actionContext != null && !this.actionContext.getSelection().isEmpty() && this.actionContext.getSelection() instanceof IStructuredSelection) {
            return (IStructuredSelection)this.actionContext.getSelection();
        }
        return null;
    }

    public boolean fillContextMenu(IMenuManager aMenu) {
        IStructuredSelection selection = this.getStructureSelection();
        this.setSelection(selection);
        this.fillContextMenu(aMenu, selection);
        return true;
    }

    private void fillContextMenu(IMenuManager menu, IStructuredSelection selection) {
        boolean isProjectSelection = true;
        boolean hasOpenProjects = false;
        boolean hasClosedProjects = false;
        boolean hasBuilder = true;
        Iterator resources = selection.iterator();
        while (resources.hasNext() && (!hasOpenProjects || !hasClosedProjects || hasBuilder || isProjectSelection)) {
            Object next = resources.next();
            IProject project = null;
            if (next instanceof IProject) {
                project = (IProject)next;
            } else if (next instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)next;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IProject");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                project = (IProject)iAdaptable.getAdapter((Class)clazz);
            }
            if (project == null) {
                isProjectSelection = false;
                continue;
            }
            if (project.isOpen()) {
                hasOpenProjects = true;
                if (!hasBuilder || this.hasBuilder(project)) continue;
                hasBuilder = false;
                continue;
            }
            hasClosedProjects = true;
            hasBuilder = false;
        }
        if (!selection.isEmpty() && isProjectSelection && !ResourcesPlugin.getWorkspace().isAutoBuilding() && hasBuilder) {
            this.appendToGroup(menu, (IAction)this.buildAction);
        }
        if (!hasClosedProjects) {
            this.appendToGroup(menu, (IAction)this.refreshAction);
        }
        if (isProjectSelection) {
            if (hasClosedProjects) {
                this.appendToGroup(menu, (IAction)this.openProjectAction);
            }
            if (hasOpenProjects) {
                this.appendToGroup(menu, (IAction)this.closeProjectAction);
            }
        }
    }

    private boolean hasBuilder(IProject project) {
        try {
            ICommand[] commands = project.getDescription().getBuildSpec();
            if (commands.length > 0) {
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    protected void appendToGroup(IMenuManager menu, IAction action) {
        if (action.isEnabled()) {
            menu.appendToGroup("group.build", action);
        }
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

