/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.navigator.internal.actions;

import org.eclipse.jdt.ui.actions.CCPActionGroup;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonActionProvider;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentService;
import org.eclipse.wst.common.navigator.internal.views.actions.CommonActionProvider;

public class EditActionsNavigatorExtension
extends CommonActionProvider
implements ICommonActionProvider {
    private ActionFactory.IWorkbenchAction cutAction;
    private ActionFactory.IWorkbenchAction copyAction;
    private ActionFactory.IWorkbenchAction pasteAction;
    private ActionFactory.IWorkbenchAction deleteAction;
    private CCPActionGroup ccpActionGroup;

    public void init(IViewPart aViewPart, StructuredViewer aViewer, NavigatorContentService aContentService) {
        this.cutAction = ActionFactory.CUT.create(aViewPart.getViewSite().getWorkbenchWindow());
        this.copyAction = ActionFactory.COPY.create(aViewPart.getViewSite().getWorkbenchWindow());
        this.pasteAction = ActionFactory.PASTE.create(aViewPart.getViewSite().getWorkbenchWindow());
        this.deleteAction = ActionFactory.DELETE.create(aViewPart.getViewSite().getWorkbenchWindow());
        ((RetargetAction)this.cutAction).partActivated((IWorkbenchPart)aViewPart);
        ((RetargetAction)this.copyAction).partActivated((IWorkbenchPart)aViewPart);
        ((RetargetAction)this.pasteAction).partActivated((IWorkbenchPart)aViewPart);
        ((RetargetAction)this.deleteAction).partActivated((IWorkbenchPart)aViewPart);
        this.ccpActionGroup = new CCPActionGroup(aViewPart);
    }

    public void setActionContext(ActionContext aContext) {
        this.ccpActionGroup.setContext(aContext);
    }

    public boolean fillActionBars(IActionBars theActionBars) {
        this.ccpActionGroup.fillActionBars(theActionBars);
        return true;
    }

    public boolean fillContextMenu(IMenuManager aMenu) {
        if (this.deleteAction.isEnabled()) {
            aMenu.insertAfter("common-menu-edit-actions", (IAction)this.deleteAction);
        }
        if (this.pasteAction.isEnabled()) {
            aMenu.insertAfter("common-menu-edit-actions", (IAction)this.pasteAction);
        }
        if (this.copyAction.isEnabled()) {
            aMenu.insertAfter("common-menu-edit-actions", (IAction)this.copyAction);
        }
        if (this.cutAction.isEnabled()) {
            aMenu.insertAfter("common-menu-edit-actions", (IAction)this.cutAction);
        }
        return this.cutAction.isEnabled() || this.copyAction.isEnabled() || this.pasteAction.isEnabled() || this.deleteAction.isEnabled();
    }

    public void dispose() {
        this.cutAction.dispose();
        this.copyAction.dispose();
        this.pasteAction.dispose();
        this.deleteAction.dispose();
        this.ccpActionGroup.dispose();
    }
}

