/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.server.internal.ui.explorer.providers.content.impl;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wst.common.navigator.internal.provisional.views.INavigatorContentExtension;
import org.eclipse.wst.common.navigator.internal.provisional.views.INavigatorContentProvider;
import org.eclipse.wst.rdb.core.internal.ui.explorer.providers.content.virtual.VirtualNode;
import org.eclipse.wst.rdb.core.internal.ui.explorer.services.IVirtualNodeServiceFactory;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IKnownConnectionNode;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IVirtualNode;
import org.eclipse.wst.rdb.core.internal.ui.services.IDataToolsUIServiceManager;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionManager;
import org.eclipse.wst.rdb.internal.core.containment.ContainmentService;
import org.eclipse.wst.rdb.server.internal.ui.explorer.ServerExplorerViewer;
import org.eclipse.wst.rdb.server.internal.ui.explorer.content.ConnectionNodeUtil;
import org.eclipse.wst.rdb.server.internal.ui.explorer.content.ServerExplorerConfiguration;
import org.eclipse.wst.rdb.server.internal.ui.explorer.content.ServerExplorerInitializer;
import org.eclipse.wst.rdb.server.internal.ui.explorer.providers.ServerExplorerManager;
import org.eclipse.wst.rdb.server.internal.ui.explorer.providers.content.layout.IServerExplorerLayoutProviderNav;
import org.eclipse.wst.rdb.server.internal.ui.explorer.providers.content.layout.hierar.ServerExplorerHierarchicalLayoutNav;
import org.eclipse.wst.rdb.server.internal.ui.explorer.providers.content.layout.vnode.ServerExplorerVirtualNodeLayoutNav;
import org.eclipse.wst.rdb.server.internal.ui.layout.IServerExplorerLayoutExtensionProvider;
import org.eclipse.wst.rdb.server.internal.ui.services.IServerExplorerContentService;
import org.eclipse.wst.rdb.server.internal.ui.services.IServerExplorerLayoutService;
import org.eclipse.wst.rdb.server.internal.ui.services.IServerExplorerNavigationService;
import org.eclipse.wst.rdb.server.internal.ui.util.TransientEObjectUtil;
import org.eclipse.wst.rdb.server.internal.ui.util.resources.ResourceLoader;

public class ServerExplorerContentProviderNav
implements INavigatorContentProvider,
IServerExplorerContentService,
IServerExplorerLayoutService,
IServerExplorerNavigationService {
    private static final ContainmentService containmentService = RDBCorePlugin.getDefault().getContainmentService();
    private static final ResourceLoader resourceLoader = ResourceLoader.INSTANCE;
    private static final Object[] EMPTY_ELEMENT_ARRAY = new Object[0];
    private static final String KNOWN_SERVERS = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.KNOWN_SERVERS");
    private static final IVirtualNodeServiceFactory virtualNodeFactory = IDataToolsUIServiceManager.INSTANCE.getVirtualNodeServiceFactory();
    private static final ConnectionManager manager = RDBCorePlugin.getDefault().getConnectionManager();
    private INavigatorContentExtension containedExtension;
    private ServerExplorerConfiguration serverExplorerConfiguration = new ServerExplorerConfiguration();
    private IKnownConnectionNode knownServer;
    private IServerExplorerLayoutProviderNav layoutProvider;
    private ServerExplorerViewer viewer;
    private List layoutProvidersExtensionList = new LinkedList();

    private void initializeServerExplorer() {
        this.knownServer = virtualNodeFactory.makeKnownConnectionNode(KNOWN_SERVERS, KNOWN_SERVERS, null);
        ServerExplorerManager.INSTANCE.setRootKnownServerNode(this.knownServer);
        ServerExplorerManager.INSTANCE.setServerExplorerService(this);
        new ServerExplorerInitializer().loadLocalRegisteredDatabases();
        this.layoutProvider.initializeKnownServers(this.knownServer);
    }

    private void initializeLayoutExtensionProviders() {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.wst.rdb.server.ui", "serverExplorerLayoutExtension");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                try {
                    IServerExplorerLayoutExtensionProvider layout = (IServerExplorerLayoutExtensionProvider)configElements[j].createExecutableExtension("class");
                    layout.enableLayout(this.isVirtualNodeLayoutSelected() ? IServerExplorerLayoutExtensionProvider.Layout.VNODE : IServerExplorerLayoutExtensionProvider.Layout.HIERARCHICAL);
                    this.layoutProvidersExtensionList.add(layout);
                }
                catch (CoreException coreException) {}
                ++j;
            }
            ++i;
        }
    }

    private void removeServerConnection(IConnectionNode server) {
        server.shouldDisconnect(true);
    }

    private IConnectionNode[] getServers(boolean connected) {
        LinkedList<IConnectionNode> connectedServers = new LinkedList<IConnectionNode>();
        int i = 0;
        int n = this.knownServer.getChildrenArray().length;
        while (i < n) {
            IConnectionNode server = (IConnectionNode)this.knownServer.getChildrenArray()[i];
            if (server.isConnected() == connected) {
                connectedServers.add(server);
            }
            ++i;
        }
        return connectedServers.toArray(new IConnectionNode[connectedServers.size()]);
    }

    private ServerExplorerViewer getViewer() {
        return this.viewer;
    }

    public INavigatorContentExtension getContainingExtension() {
        return this.containedExtension;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof ServerExplorerViewer && this.viewer == null) {
            this.viewer = (ServerExplorerViewer)viewer;
            this.enableVirtualNodeLayout();
            this.initializeServerExplorer();
            this.initializeLayoutExtensionProviders();
        }
    }

    public boolean isServerExplorerViewer() {
        return this.viewer != null;
    }

    public Object[] getChildren(Object parentElement) {
        if (this.isServerExplorerViewer()) {
            if (parentElement instanceof IWorkspaceRoot) {
                return new Object[]{this.knownServer};
            }
            if (!(parentElement instanceof IWorkspaceRoot)) {
                if (parentElement instanceof VirtualNode && ((IVirtualNode)parentElement).hasChildren()) {
                    if (parentElement instanceof IConnectionNode && ((IConnectionNode)parentElement).shouldDisconnect()) {
                        ((IConnectionNode)parentElement).setConnected(false);
                        return EMPTY_ELEMENT_ARRAY;
                    }
                    return ((IVirtualNode)parentElement).getChildrenArray();
                }
                return this.layoutProvider.getChildren(parentElement);
            }
        }
        return EMPTY_ELEMENT_ARRAY;
    }

    public Object getParent(Object element) {
        if (this.isServerExplorerViewer()) {
            if (element instanceof IWorkspaceRoot) {
                return this.knownServer;
            }
            Object result = this.getViewer().getParent(element);
            result = result != null ? result : (element instanceof IVirtualNode ? ((IVirtualNode)element).getParent() : null);
            result = result != null ? result : containmentService.getContainer((EObject)element);
            return result;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.isServerExplorerViewer() ? !(element instanceof IConnectionNode) || ((IConnectionNode)element).getConnectionInfo().getSharedDatabase() != null : false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        ServerExplorerManager.INSTANCE.setServerExplorerService(null);
    }

    public void addNode(Object newNode) {
        this.addNode(ResourcesPlugin.getWorkspace().getRoot(), newNode);
    }

    public void addNode(Object parentNode, Object newNode) {
        if (parentNode instanceof IVirtualNode) {
            ((IVirtualNode)parentNode).addChildren(newNode);
        }
        if (this.isServerExplorerViewer()) {
            this.viewer.add(parentNode, newNode);
        }
    }

    public void addKnownServer(Object server) {
        IConnectionNode serverNode = (IConnectionNode)server;
        serverNode.setConnected(true);
        this.knownServer.addChildren((Object)serverNode);
        this.addNode(this.getKnownServerNode(), serverNode);
    }

    public void addProxyNode(Object parentNode) {
    }

    private boolean isSupported(Object parent, Object child) {
        if (parent instanceof IVirtualNode && child instanceof EObject) {
            String groupID = containmentService.getGroupId((EObject)child);
            return groupID != null && groupID.equals(((IVirtualNode)parent).getGroupID());
        }
        if (parent instanceof EObject) {
            boolean cfr_ignored_0 = child instanceof IVirtualNode;
        }
        return false;
    }

    private void loadChilds(ServerExplorerViewer viewer, Object parent) {
        viewer.expandToLevel(parent, 1);
    }

    private Object getVirtualNode(ServerExplorerViewer viewer, Object parent, String groupID) {
        if (parent != null) {
            if (parent instanceof IConnectionNode) {
                return parent;
            }
            TreeItem[] items = viewer.getServerExplorerChildren(parent);
            if (items.length != 0) {
                int i = 0;
                int n = items.length;
                while (i < n) {
                    TreeItem child = items[i];
                    Object childNode = child.getData();
                    if (childNode instanceof IVirtualNode && ((IVirtualNode)childNode).getGroupID().equals(groupID)) {
                        return (IVirtualNode)child.getData();
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    private Object getEObjectNode(ServerExplorerViewer viewer, Object parent, String name) {
        TreeItem[] items;
        if (parent != null && (items = viewer.getServerExplorerChildren(parent)).length != 0) {
            int i = 0;
            int n = items.length;
            while (i < n) {
                TreeItem child = items[i];
                Object childNode = child.getData();
                if (childNode instanceof ENamedElement && ((ENamedElement)childNode).getName().equals(name)) {
                    return childNode;
                }
                ++i;
            }
        }
        return null;
    }

    public void expandNode(EObject eObject) {
        try {
            this.expandNode(TransientEObjectUtil.getEObjectId(eObject));
        }
        catch (Exception exception) {}
    }

    public void selectAndReveal(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Iterator iterator = structuredSelection.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(object instanceof EObject)) continue;
                this.expandNode((EObject)object);
            }
        }
        this.getViewer().setSelection(selection, true);
    }

    public void expandNode(String pathToNavigate) {
        ServerExplorerViewer viewer = this.getViewer();
        try {
            List path = TransientEObjectUtil.getPathFromID(pathToNavigate);
            Iterator pathIterator = path.iterator();
            Object parent1 = ConnectionNodeUtil.getConnectionNode(manager.getConnectionInfo((String)pathIterator.next()));
            Object parent2 = null;
            while (pathIterator.hasNext()) {
                String pathString = (String)pathIterator.next();
                TransientEObjectUtil.IGroup group = TransientEObjectUtil.getGroupInfo(pathString);
                String groupID = group.getGroupId();
                String elementName = group.getElementName();
                parent2 = this.getVirtualNode(viewer, parent1, groupID);
                if (parent2 == null) {
                    this.loadChilds(viewer, parent1);
                    parent2 = this.getVirtualNode(viewer, parent1, groupID);
                    if (parent2 == null && parent1 instanceof IVirtualNode) {
                        IVirtualNode cfr_ignored_0 = (IVirtualNode)parent1;
                        Object[] children = ((IVirtualNode)parent1).getChildrenArray();
                        int i = 0;
                        int n = children.length;
                        while (i < n) {
                            Object parent4 = this.getVirtualNode(viewer, children[i], groupID);
                            if (parent4 != null) {
                                parent2 = parent4;
                                break;
                            }
                            ++i;
                        }
                    }
                } else {
                    this.loadChilds(viewer, parent2);
                    Object parent3 = this.getVirtualNode(viewer, parent2, groupID);
                    if (parent3 != null) {
                        parent2 = parent3;
                    }
                }
                parent1 = parent2;
                if (elementName != null && (parent2 = this.getEObjectNode(viewer, parent1, elementName)) == null) {
                    this.loadChilds(viewer, parent1);
                    parent2 = this.getEObjectNode(viewer, parent1, elementName);
                }
                parent1 = parent2;
            }
            viewer.selectInExplorer((ISelection)new StructuredSelection(parent1));
        }
        catch (Exception exception) {}
    }

    public IServerExplorerLayoutService getServerExplorerLayoutService() {
        return this;
    }

    public void refreshServerExplorer() {
    }

    public void updateLayout() {
    }

    public void refreshNode(Object node) {
        if (this.isServerExplorerViewer()) {
            this.viewer.refresh(node, true);
        }
    }

    public void collapseAll() {
        if (this.isServerExplorerViewer()) {
            this.viewer.collapseAll();
        }
    }

    public IConnectionNode[] getAllConnectedServers() {
        return this.getServers(true);
    }

    public IConnectionNode[] getAllDisconnectedServers() {
        return this.getServers(false);
    }

    public void disconnectServers(IConnectionNode[] servers) {
        int i = 0;
        int n = servers.length;
        while (i < n) {
            this.removeServerConnection(servers[i]);
            this.refreshNode(servers[i]);
            ++i;
        }
    }

    public void connectServer(Object server) {
        IConnectionNode serverNode = (IConnectionNode)server;
        this.refreshNode(serverNode);
    }

    public void enableVirtualNodeLayout() {
        this.layoutProvider = new ServerExplorerVirtualNodeLayoutNav(this);
        Iterator iterator = this.layoutProvidersExtensionList.iterator();
        while (iterator.hasNext()) {
            ((IServerExplorerLayoutExtensionProvider)iterator.next()).enableLayout(IServerExplorerLayoutExtensionProvider.Layout.VNODE);
        }
    }

    public void enableHierarchicalLayout() {
        this.layoutProvider = new ServerExplorerHierarchicalLayoutNav(this);
        Iterator iterator = this.layoutProvidersExtensionList.iterator();
        while (iterator.hasNext()) {
            ((IServerExplorerLayoutExtensionProvider)iterator.next()).enableLayout(IServerExplorerLayoutExtensionProvider.Layout.HIERARCHICAL);
        }
    }

    public boolean isVirtualNodeLayoutSelected() {
        return this.layoutProvider instanceof ServerExplorerVirtualNodeLayoutNav;
    }

    public boolean isHierarchicalLayoutSelected() {
        return this.layoutProvider instanceof ServerExplorerHierarchicalLayoutNav;
    }

    public IKnownConnectionNode getKnownServerNode() {
        return this.knownServer;
    }

    public void deleteServer(IConnectionNode[] servers) {
        int i = 0;
        int n = servers.length;
        while (i < n) {
            this.serverExplorerConfiguration.deleteServer(servers[i]);
            this.removeServerConnection(servers[i]);
            this.getKnownServerNode().removeChildren((Object)servers[i]);
            this.removeNode(servers[i]);
            ++i;
        }
    }

    public void reconnectServer(IConnectionNode[] servers) {
    }

    public void removeNode(Object removedChild) {
        if (this.isServerExplorerViewer()) {
            try {
                this.viewer.remove(removedChild);
            }
            catch (Throwable throwable) {}
        }
    }

    public void removeNode(Object parent, Object removedChild) {
        if (this.isServerExplorerViewer()) {
            try {
                this.viewer.remove(removedChild);
            }
            catch (Throwable throwable) {}
        }
    }

    public Object[] getServerExplorerObjectsByType(ConnectionInfo info, Class type) {
        return this.viewer.getServerExplorerObjectsByType(info, type);
    }

    public Object[] getServerExplorerObjectsByType(Object parent, Class type) {
        return this.viewer.getServerExplorerObjectsByType(parent, type);
    }

    public void expandNode(Object node, int depth) {
        while (Display.getDefault().readAndDispatch()) {
        }
        this.viewer.expandToLevel(node, depth);
    }

    public void updateSelection(ISelection selection) {
        this.viewer.updateExplorerSelection(selection);
    }
}

