/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.webservice.helper;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.j2ee.common.QName;
import org.eclipse.jst.j2ee.internal.webservices.WSDLServiceExtManager;
import org.eclipse.jst.j2ee.internal.webservices.WSDLServiceHelper;
import org.eclipse.jst.j2ee.webservice.wsclient.ComponentScopedRefs;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.jst.j2ee.webservice.wsclient.WebServicesClient;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.ComponentHandle;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class WSDLHelper {
    private ComponentHandle handle;

    public WSDLHelper(ComponentHandle aHandle) {
        this.handle = aHandle;
    }

    public String[] getPortNames(String serviceRefName, String compScopedRefName, WebServicesClient wsc, String[] exclude) {
        ServiceRef sr = this.getServiceRef(serviceRefName, compScopedRefName, wsc);
        if (sr == null) {
            return null;
        }
        String wsdlURL = this.getWSDLFileURL(sr);
        if (wsdlURL.length() == 0) {
            return null;
        }
        String serviceLocalName = this.getServiceQname(sr);
        String[] portNames = this.getPortNames(wsdlURL, serviceLocalName);
        portNames = this.trim(portNames, exclude);
        return portNames;
    }

    public String getPortNamespace(String serviceRefName, String compScopedRefName, WebServicesClient wsc) {
        ServiceRef sr = this.getServiceRef(serviceRefName, compScopedRefName, wsc);
        if (sr == null) {
            return null;
        }
        String wsdlURL = this.getWSDLFileURL(sr);
        if (wsdlURL.length() == 0) {
            return "";
        }
        String serviceLocalName = this.getServiceQname(sr);
        String namespace = this.getPortNamespace(wsdlURL, serviceLocalName);
        return namespace;
    }

    private String[] getPortNames(String wsdlURL, String serviceLocalName) {
        WSDLServiceHelper serviceHelper = WSDLServiceExtManager.getServiceHelper();
        Object targetService = this.getTargetService(wsdlURL, serviceLocalName);
        if (targetService == null) {
            return null;
        }
        Map ports = serviceHelper.getServicePorts(targetService);
        int numberOfPorts = ports.size();
        String[] portNames = new String[numberOfPorts];
        Iterator k = ports.values().iterator();
        int m = 0;
        while (m < numberOfPorts) {
            Object port = k.next();
            portNames[m] = serviceHelper.getPortName(port);
            ++m;
        }
        return portNames;
    }

    private String getPortNamespace(String wsdlURL, String serviceLocalName) {
        Object targetService = this.getTargetService(wsdlURL, serviceLocalName);
        if (targetService == null) {
            return "";
        }
        return WSDLServiceExtManager.getServiceHelper().getServiceNamespaceURI(targetService);
    }

    private Object getTargetService(String wsdlURL, String serviceLocalName) {
        WSDLServiceHelper serviceHelper = WSDLServiceExtManager.getServiceHelper();
        Object definition = this.getWSDLDefinition(wsdlURL);
        if (definition == null) {
            return null;
        }
        Object targetService = null;
        Map services = serviceHelper.getDefinitionServices(definition);
        if (!services.isEmpty()) {
            if ((serviceLocalName == null || serviceLocalName.length() == 0) && services.size() > 1) {
                return null;
            }
            if ((serviceLocalName == null || serviceLocalName.length() == 0) && services.size() == 1) {
                Iterator i = services.values().iterator();
                targetService = i.next();
            } else {
                Iterator j = services.values().iterator();
                while (j.hasNext()) {
                    Object service = j.next();
                    String serviceName = serviceHelper.getServiceLocalPart(service);
                    if (!serviceName.equals(serviceLocalName)) continue;
                    targetService = service;
                    break;
                }
            }
        }
        return targetService;
    }

    private Object getWSDLDefinition(String wsdlURL) {
        WSDLServiceHelper serviceHelper = WSDLServiceExtManager.getServiceHelper();
        return serviceHelper.getWSDLDefinition(wsdlURL);
    }

    private String getWSDLFileURL(ServiceRef sr) {
        String wsdlFileRelPath = sr.getWsdlFile();
        if (wsdlFileRelPath == null || wsdlFileRelPath.length() == 0) {
            return "";
        }
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.handle.getProject(), (String)this.handle.getName());
        if (component != null) {
            String wsdlURL;
            IVirtualFolder moduleRoot = component.getRootFolder().getFolder("/");
            IFile wsdlFile = moduleRoot.getFile(wsdlFileRelPath).getUnderlyingFile();
            if (!wsdlFile.exists()) {
                return "";
            }
            try {
                wsdlURL = wsdlFile.getLocation().toFile().toURL().toString();
            }
            catch (MalformedURLException malformedURLException) {
                return "";
            }
            if (wsdlURL == null || wsdlURL.length() == 0) {
                return "";
            }
            return wsdlURL;
        }
        return "";
    }

    private String getServiceQname(ServiceRef sr) {
        QName serviceQname = sr.getServiceQname();
        if (serviceQname == null) {
            return "";
        }
        String serviceLocalName = serviceQname.getLocalPart();
        if (serviceLocalName == null) {
            return "";
        }
        return serviceLocalName;
    }

    /*
     * Unable to fully structure code
     */
    public ServiceRef getServiceRef(String name, String compScopedRefName, WebServicesClient wsc) {
        block3: {
            if (compScopedRefName == null || compScopedRefName.length() <= 0) break block3;
            csr = this.getCompScopedRef(compScopedRefName, wsc);
            serviceRefs = csr.getServiceRefs().iterator();
            ** GOTO lbl23
        }
        serviceRefs = wsc.getServiceRefs().iterator();
        if (serviceRefs.hasNext()) ** GOTO lbl23
        csRefs = wsc.getComponentScopedRefs().iterator();
        while (csRefs.hasNext()) {
            csr = (ComponentScopedRefs)csRefs.next();
            srs = csr.getServiceRefs().iterator();
            while (srs.hasNext()) {
                sr = (ServiceRef)srs.next();
                thisName = sr.getServiceRefName();
                if (!thisName.equals(name)) continue;
                return sr;
            }
        }
        return null;
lbl-1000:
        // 1 sources

        {
            serviceRef = (ServiceRef)serviceRefs.next();
            serviceRefName = serviceRef.getServiceRefName();
            if (!serviceRefName.equals(name)) continue;
            return serviceRef;
lbl23:
            // 3 sources

            ** while (serviceRefs.hasNext())
        }
lbl24:
        // 1 sources

        return null;
    }

    private ComponentScopedRefs getCompScopedRef(String name, WebServicesClient wsc) {
        Iterator compScopedRefs = wsc.getComponentScopedRefs().iterator();
        while (compScopedRefs.hasNext()) {
            ComponentScopedRefs compScopedRef = (ComponentScopedRefs)compScopedRefs.next();
            String compScopedRefName = compScopedRef.getComponentName();
            if (!compScopedRefName.equals(name)) continue;
            return compScopedRef;
        }
        return null;
    }

    private String[] trim(String[] values, String[] exclude) {
        if (values == null || values.length == 0 || exclude == null || exclude.length == 0) {
            return values;
        }
        ArrayList<String> finalList = new ArrayList<String>();
        int i = 0;
        while (i < values.length) {
            if (!this.contains(exclude, values[i])) {
                finalList.add(values[i]);
            }
            ++i;
        }
        int finalSize = finalList.size();
        String[] finalValues = new String[finalSize];
        Object[] finalArray = finalList.toArray();
        int j = 0;
        while (j < finalSize) {
            finalValues[j] = (String)finalArray[j];
            ++j;
        }
        return finalValues;
    }

    private boolean contains(String[] values, String s) {
        if (values == null) {
            return false;
        }
        int i = 0;
        while (i < values.length) {
            if (values[i].equals(s)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

