/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.consumption.ui.command;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.xml.WSDLWriter;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.ws.internal.plugin.WebServicePlugin;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.ProgressMonitor;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.command.internal.provisional.env.core.common.StatusHandler;
import org.eclipse.wst.command.internal.provisional.env.core.context.ResourceContext;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;
import org.eclipse.wst.wsdl.internal.impl.wsdl4j.WSDLFactoryImpl;

public class CopyClientWSDLCommand
extends SimpleCommand {
    private String DESCRIPTION = "TASK_DESC_COPY_CLIENT_WSDL";
    private String LABEL = "TASK_LABEL_COPY_CLIENT_WSDL";
    private String pluginId_ = "org.eclipse.jst.ws.axis.consumption.ui";
    private MessageUtils msgUtils_ = new MessageUtils(String.valueOf(this.pluginId_) + ".plugin", (Object)this);
    private String wsdlURL_;
    private String clientWSDLPathName_;
    private WebServicesParser wsParser_;

    public CopyClientWSDLCommand() {
        this.setDescription(this.msgUtils_.getMessage(this.DESCRIPTION));
        this.setName(this.msgUtils_.getMessage(this.LABEL));
    }

    public Status execute(Environment env) {
        SimpleStatus status = new SimpleStatus("");
        Definition def = this.wsParser_.getWSDLDefinition(this.wsdlURL_);
        if (def == null) {
            status = new SimpleStatus(this.pluginId_, this.msgUtils_.getMessage("MSG_ERROR_WSDL_NO_DEFINITION", (Object[])new String[]{this.wsdlURL_}), 4);
            env.getStatusHandler().reportError((Status)status);
            return status;
        }
        Path clientWSDLPath = new Path(this.clientWSDLPathName_);
        IWorkspaceRoot workspaceRoot = FileResourceUtils.getWorkspaceRoot();
        status = this.resolveWSDL(workspaceRoot, def, (IPath)clientWSDLPath, env);
        return status;
    }

    private Status resolveWSDL(IWorkspaceRoot workspace, Definition wsdlDef, IPath wsdlPath, Environment env) {
        try {
            this.writeWSDLFile(workspace, wsdlDef, wsdlPath, env);
            Map importDefs = wsdlDef.getImports();
            Set keysSet = importDefs.keySet();
            Iterator e = keysSet.iterator();
            while (e.hasNext()) {
                Object keyName = e.next();
                Vector vector = (Vector)importDefs.get(keyName);
                int i = 0;
                while (i < vector.size()) {
                    Import importDef = (Import)vector.get(i);
                    Definition def = importDef.getDefinition();
                    String newPathString = wsdlPath.toString().substring(0, wsdlPath.toString().lastIndexOf("/") + 1);
                    if (this.isInvalidImportWSDL(importDef.getLocationURI())) {
                        return new SimpleStatus(this.pluginId_, this.msgUtils_.getMessage("MSG_ERROR_IMPORT_WSDL", (Object[])new String[]{importDef.getLocationURI()}), 4);
                    }
                    Path newPath = new Path(String.valueOf(newPathString) + importDef.getLocationURI());
                    Status status = this.resolveWSDL(workspace, def, (IPath)newPath, env);
                    if (status != null && status.getSeverity() == 4) {
                        return status;
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            return new SimpleStatus(this.pluginId_, this.msgUtils_.getMessage("MSG_ERROR_WRITE_WSDL", (Object[])new String[]{wsdlPath.toString()}), 4, (Throwable)e);
        }
        return new SimpleStatus("");
    }

    private boolean isInvalidImportWSDL(String wsdlPath) {
        return !wsdlPath.toLowerCase().startsWith("http://") && wsdlPath.indexOf("/") != -1 && !wsdlPath.startsWith("./");
    }

    private void writeWSDLFile(IWorkspaceRoot workspace, Definition wsdlDef, IPath wsdlPath, Environment env) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        WSDLWriter wsdlWriter = new WSDLFactoryImpl().newWSDLWriter();
        wsdlWriter.writeWSDL(wsdlDef, (OutputStream)baos);
        byte[] b = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(b);
        ResourceContext context = WebServicePlugin.getInstance().getResourceContext();
        FileResourceUtils.createFile((ResourceContext)context, (IPath)wsdlPath.makeAbsolute(), (InputStream)bais, (ProgressMonitor)env.getProgressMonitor(), (StatusHandler)env.getStatusHandler());
        baos.close();
        bais.close();
    }

    public void setClientWSDLPathName(String clientWSDLPathName) {
        this.clientWSDLPathName_ = clientWSDLPathName;
    }

    public void setWsdlURL(String wsdlURL) {
        this.wsdlURL_ = wsdlURL;
    }

    public void setWsParser(WebServicesParser wsParser) {
        this.wsParser_ = wsParser;
    }
}

