/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel;

import java.util.Enumeration;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.AttributeElement;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.FieldElement;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.ParameterElement;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.TypeElement;
import org.eclipse.wst.ws.internal.datamodel.BasicModel;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.datamodel.Model;

public class BeanElement
extends TypeElement {
    public static final String copyright = "(c) Copyright IBM Corporation 2000, 2002.";
    public static String STATELESS_BEAN = "10101010statelessbean10101010";
    public static String REL_METHODS = "relmethods";

    public BeanElement(String name) {
        this(name, (Model)new BasicModel("Project"), true);
    }

    public BeanElement(String name, Model model, boolean isRoot) {
        super(name, model, TypeElement.BEAN);
        if (isRoot) {
            model.setRootElement((Element)this);
        }
        this.fOwnerType = TypeElement.ROOT;
    }

    public BeanElement(ParameterElement parameterElement, String name) {
        super(name, (Element)parameterElement, "owner", "type", TypeElement.BEAN);
        this.fOwnerType = TypeElement.PARAMETER_OWNER;
    }

    public BeanElement(AttributeElement attributeElement, String name) {
        super(name, (Element)attributeElement, "owner", "type", TypeElement.BEAN);
        this.fOwnerType = TypeElement.ATTRIBUTE_OWNER;
    }

    public BeanElement(FieldElement fieldElement, String name) {
        super(name, (Element)fieldElement, "owner", "type", TypeElement.BEAN);
        this.fOwnerType = TypeElement.FIELD_OWNER;
    }

    public Enumeration getMethods() {
        return this.getElements(REL_METHODS);
    }

    public int getNumberOfMethodElements() {
        return this.getNumberOfElements(REL_METHODS);
    }

    public String getTypeName() {
        if (this.isStateLess()) {
            return String.valueOf(STATELESS_BEAN) + this.getName();
        }
        return this.getName();
    }

    public boolean isStateLess() {
        Enumeration ea = this.getElements(TypeElement.REL_ATTRIBUTES);
        Enumeration ef = this.getElements(TypeElement.REL_FIELDS);
        return !ea.hasMoreElements() && !ef.hasMoreElements();
    }
}

