/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.command.common;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.internal.earcreation.EARNatureRuntime;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.wst.command.internal.env.eclipse.EclipseLog;
import org.eclipse.wst.command.internal.provisional.env.core.common.Log;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;

public abstract class AbstractStartServer {
    private IProject project = null;
    protected IProgressMonitor monitor;
    private Log log_ = new EclipseLog();
    private MessageUtils msgUtils_ = new MessageUtils("org.eclipse.jst.ws.consumption.plugin", (Object)this);

    public void StartServer(IProject project, IServer server, IProgressMonitor monitor, boolean restart) throws CoreException {
        this.project = project;
        this.monitor = monitor;
        try {
            this.validateRemoteServerPath(server);
            if (server.getServerState() != 4) {
                if (server.getServerRestartState()) {
                    server.synchronousStop(false);
                    this.log_.log(1, 5050, (Object)this, "StartServer", (Object)("project=" + project + ", Stop command completed, restart needed"));
                    this.publishProject(server);
                    this.startProject(server);
                } else if (restart) {
                    this.publishProject(server);
                    this.restartProject(project, server);
                }
            } else {
                this.publishProject(server);
                this.startProject(server);
            }
        }
        catch (CoreException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.ws.consumption", 0, this.msgUtils_.getMessage("MSG_ERROR_SERVER"), (Throwable)e));
        }
    }

    protected void publishProject(IServer server) throws CoreException {
        this.monitor.subTask(this.msgUtils_.getMessage("PROGRESS_INFO_PUBLISHING_SERVER"));
        IStatus status = server.publish(1, this.monitor);
        if (status.getSeverity() != 0) {
            throw new CoreException(status);
        }
        this.log_.log(1, 5051, (Object)this, "publishProject", (Object)("IServer=" + server + ", Publish command completed"));
    }

    protected void startProject(IServer server) throws CoreException {
        try {
            this.monitor.subTask(this.msgUtils_.getMessage("PROGRESS_INFO_STARTING_SERVER"));
            server.synchronousStart("run", this.monitor);
            this.log_.log(1, 5052, (Object)this, "startProject", (Object)("IServer=" + server + ", Start command completed"));
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.ws.consumption", 0, this.msgUtils_.getMessage("MSG_ERROR_SERVER"), (Throwable)e));
        }
    }

    protected void restartProject(IProject project, IServer server) throws CoreException {
        try {
            this.monitor.subTask(this.msgUtils_.getMessage("PROGRESS_INFO_STARTING_SERVER"));
            EARNatureRuntime[] ears = J2EEUtils.getEARProjects((IProject)project);
            int i = 0;
            while (i < ears.length) {
                IProject earProject = ears[i].getProject();
                if (earProject != null && ServerUtil.containsModule((IServer)server, (IModule)ResourceUtils.getModule((IProject)earProject), (IProgressMonitor)this.monitor)) {
                    this.log_.log(1, 5053, (Object)this, "restartProject", (Object)("earProject=" + earProject + ", Restart project command completed"));
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.ws.consumption", 0, this.msgUtils_.getMessage("MSG_ERROR_SERVER"), (Throwable)e));
        }
    }

    public void runPreServerConfig(IServer server, IProject EARProject) {
    }

    public void runPostServerConfig(IServer server, IProject EARProject) {
    }

    protected abstract void addJarsToClassPath(IServer var1) throws CoreException;

    protected abstract void validateRemoteServerPath(IServer var1) throws CoreException;

    public void stopServer(IServer server) throws CoreException {
        if (server != null && server.getServerState() != 4) {
            server.synchronousStop(false);
        }
    }
}

