/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ejb.project.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.internal.common.operations.JARDependencyDataModel;
import org.eclipse.jst.j2ee.internal.common.operations.JARDependencyOperation;
import org.eclipse.jst.j2ee.internal.earcreation.EARNatureRuntime;
import org.eclipse.jst.j2ee.internal.ejb.project.EJBEditModel;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.AbstractEJBClientJAROperation;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.ClientJARCreationConstants;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.InvertClientJARDependencyCompoundOperation;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.operations.IOperationHandler;

public class EJBClientJARRemovalOperation
extends AbstractEJBClientJAROperation {
    protected IPath clientProjectPath;
    protected IPath ejbProjectPath;
    protected List sourceContainers;
    protected List libraryContainers;
    protected IContainer ejbSourceContainer;
    protected IPath ejbSourcePath;
    protected IPath outputPath;
    protected boolean shouldDelete = true;
    protected boolean yesToAll = false;

    public EJBClientJARRemovalOperation(IDataModel dataModel, IOperationHandler opHandler) {
        super(dataModel, opHandler);
    }

    protected void initialize() {
        super.initialize();
        this.clientProject = this.ejbNature.getDefinedEJBClientJARProject();
        this.clientProjectPath = this.clientProject.getFullPath();
        this.ejbProjectPath = this.ejbProject.getFullPath();
        this.sourceContainers = JemProjectUtilities.getSourceContainers((IProject)this.clientProject);
        this.libraryContainers = JemProjectUtilities.getLibraryContainers((IProject)this.clientProject);
        IJavaProject proj = JavaCore.create((IProject)this.clientProject);
        try {
            this.outputPath = proj.getOutputLocation().removeFirstSegments(1);
        }
        catch (JavaModelException javaModelException) {}
        this.ejbSourceContainer = this.ejbNature.getSourceFolder();
        this.ejbSourcePath = this.ejbSourceContainer.getFullPath();
        this.initializeEARNatures();
    }

    protected void addAdditionalFilesForValidateEdit(final List roFiles) throws CoreException {
        IResourceVisitor visitor = new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (resource.isDerived()) {
                    return false;
                }
                switch (resource.getType()) {
                    case 4: {
                        return true;
                    }
                    case 2: {
                        return true;
                    }
                    case 1: {
                        if (!resource.isReadOnly()) break;
                        roFiles.add(resource);
                        break;
                    }
                }
                return false;
            }
        };
        this.clientProject.accept(visitor);
    }

    protected void initializeEARNatures() {
        HashSet<EARNatureRuntime> natures = new HashSet<EARNatureRuntime>();
        natures.addAll(Arrays.asList(this.ejbNature.getReferencingEARProjects()));
        natures.addAll(Arrays.asList(J2EEProjectUtilities.getReferencingEARProjects((IProject)this.clientProject)));
        this.earNatures = natures.toArray(new EARNatureRuntime[natures.size()]);
    }

    protected void execute(IProgressMonitor aMonitor) throws CoreException, InvocationTargetException, InterruptedException {
        this.monitor = aMonitor;
        this.initialize();
        if (!this.verifyFilesInSync()) {
            this.monitor.done();
            throw new OperationCanceledException();
        }
        this.monitor.beginTask(ClientJARCreationConstants.REMOVING_CLIENT_JAR, 10);
        this.ensureEJBJARInAllEARs();
        this.updateEJBModuleJARDependencies();
        this.copyOutgoingClasspathEntries(this.clientProject, this.ejbProject, false);
        this.moveIncomingJARDependencies();
        this.updateDD();
        this.removeClientProjectFromEARs();
        this.moveFiles();
        this.addSourceContainersToClassPath();
        if (this.moveResourceMonitor.isCanceled()) {
            throw new InterruptedException();
        }
        this.deleteClientProject();
    }

    private void addSourceContainersToClassPath() throws JavaModelException {
        int x = 0;
        while (x < this.sourceContainers.size()) {
            if (this.sourceContainers.get(x) instanceof IResource) {
                IResource resource = (IResource)this.sourceContainers.get(x);
                if (this.clientProject == resource) {
                    return;
                }
                IPath srcPath = this.ejbProjectPath.append(resource.getProjectRelativePath());
                IFolder existing = this.workspace.getRoot().getFolder(srcPath);
                if (existing != null && existing.exists()) {
                    JemProjectUtilities.appendJavaClassPath((IProject)this.ejbProject, (IClasspathEntry)JavaCore.newSourceEntry((IPath)srcPath));
                }
            }
            ++x;
        }
    }

    private void updateDD() {
        ((EJBEditModel)this.editModel).getEJBJar().setEjbClientJar(null);
    }

    private void ensureEJBJARInAllEARs() {
        int i = 0;
        while (i < this.earNatures.length) {
            this.ensureEJBJARInEAR(this.earNatures[i]);
            ++i;
        }
    }

    /*
     * Exception decompiling
     */
    private void ensureEJBJARInEAR(EARNatureRuntime runtime) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 92->96)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateEJBModuleJARDependencies() throws InvocationTargetException, InterruptedException {
        JARDependencyDataModel dataModel = new JARDependencyDataModel();
        dataModel.setProperty("UpdateManifestDataModel.PROJECT_NAME", (Object)this.ejbProject.getName());
        ArrayList<String> list = new ArrayList<String>();
        list.add(String.valueOf(this.clientProject.getName()) + ".jar");
        dataModel.setProperty("UpdateManifestDataModel.CLASSPATH_LIST", list);
        dataModel.setProperty("AbstractJARDependencyDataModel.EAR_PROJECT_NAME", (Object)this.earNatures[0].getProject().getName());
        dataModel.setIntProperty("AbstractJARDependencyDataModel.JAR_MANIPULATION_TYPE", 1);
        dataModel.setProperty("AbstractJARDependencyDataModel.REFERENCED_PROJECT_NAME", (Object)this.clientProject.getName());
        JARDependencyOperation op = new JARDependencyOperation(dataModel);
        op.run(this.createSubProgressMonitor(1));
        ArchiveManifest clientMf = J2EEProjectUtilities.readManifest((IProject)this.clientProject);
        if (clientMf == null) {
            return;
        }
        String[] mfEntries = clientMf.getClassPathTokenized();
        if (mfEntries.length == 0) {
            return;
        }
        this.createSubProgressMonitor(this.earNatures.length);
        JARDependencyDataModel dataModel2 = null;
        int i = 0;
        while (i < this.earNatures.length) {
            this.normalize(mfEntries, this.earNatures[i], false);
            dataModel2 = new JARDependencyDataModel();
            dataModel2.setProperty("UpdateManifestDataModel.PROJECT_NAME", (Object)this.ejbProject.getName());
            dataModel.setProperty("UpdateManifestDataModel.CLASSPATH_LIST", list);
            dataModel2.setProperty("AbstractJARDependencyDataModel.EAR_PROJECT_NAME", (Object)this.earNatures[i].getProject().getName());
            dataModel2.setIntProperty("AbstractJARDependencyDataModel.JAR_MANIPULATION_TYPE", 0);
            JARDependencyOperation op2 = new JARDependencyOperation(dataModel2);
            op2.run(this.createSubProgressMonitor(1));
            ++i;
        }
    }

    private void moveIncomingJARDependencies() throws InvocationTargetException, InterruptedException {
        InvertClientJARDependencyCompoundOperation op = new InvertClientJARDependencyCompoundOperation(this.earNatures, this.clientProject, this.ejbProject);
        op.run(this.createSubProgressMonitor(1));
    }

    private void moveFiles() throws CoreException {
        this.moveResourceMonitor = this.createSubProgressMonitor(1);
        IResourceVisitor visitor = this.getRootResourceVisitor();
        this.clientProject.accept(visitor);
    }

    private IResourceVisitor getRootResourceVisitor() {
        return new IResourceVisitor(){
            private boolean projectIsSource;
            {
                this.projectIsSource = EJBClientJARRemovalOperation.this.sourceContainers.contains(EJBClientJARRemovalOperation.this.clientProject);
            }

            public boolean visit(IResource resource) throws CoreException {
                if (EJBClientJARRemovalOperation.this.moveResourceMonitor.isCanceled()) {
                    return false;
                }
                switch (resource.getType()) {
                    case 1: {
                        if (!resource.isDerived()) {
                            this.visitFile((IFile)resource);
                        }
                        return false;
                    }
                    case 2: {
                        return this.visitFolder((IFolder)resource);
                    }
                    case 4: {
                        return true;
                    }
                }
                return false;
            }

            private void visitFile(IFile file) throws CoreException {
                if (this.isMetaFile(file)) {
                    return;
                }
                if (this.projectIsSource) {
                    EJBClientJARRemovalOperation.this.moveFile(file, EJBClientJARRemovalOperation.this.clientProjectPath, EJBClientJARRemovalOperation.this.ejbSourcePath);
                } else {
                    EJBClientJARRemovalOperation.this.moveFile(file, EJBClientJARRemovalOperation.this.clientProjectPath, EJBClientJARRemovalOperation.this.ejbProjectPath);
                }
            }

            private boolean isMetaFile(IFile file) {
                String segment = file.getProjectRelativePath().toString();
                return ".classpath".equals(segment) || ".project".equals(segment) || ".runtime".equals(segment);
            }

            private boolean visitFolder(IFolder folder) throws CoreException {
                if (this.isSourceFolder(folder)) {
                    this.visitSourceFolder(folder);
                    return false;
                }
                if (this.isOutputFolder(folder)) {
                    return false;
                }
                if (this.isClassesFolder(folder)) {
                    this.visitClassesFolder(folder);
                    return false;
                }
                return true;
            }

            private boolean isOutputFolder(IFolder folder) {
                IPath path = folder.getProjectRelativePath();
                while (path.segmentCount() > 0 && EJBClientJARRemovalOperation.this.outputPath != null) {
                    if (path.equals((Object)EJBClientJARRemovalOperation.this.outputPath)) {
                        return true;
                    }
                    path = path.removeLastSegments(1);
                }
                return false;
            }

            private boolean isSourceFolder(IFolder folder) {
                return EJBClientJARRemovalOperation.this.sourceContainers.contains(folder);
            }

            private void visitSourceFolder(IFolder folder) throws CoreException {
                folder.accept(EJBClientJARRemovalOperation.this.getFolderResourceVisitor(folder.getFullPath(), this.computeEJBSourceFolder(folder)));
            }

            private IPath computeEJBSourceFolder(IFolder clientProjectFolder) {
                IPath clientFolderRelativePath = clientProjectFolder.getProjectRelativePath();
                return EJBClientJARRemovalOperation.this.ejbProjectPath.append(clientFolderRelativePath);
            }

            private boolean isClassesFolder(IFolder folder) {
                return EJBClientJARRemovalOperation.this.libraryContainers.contains(folder);
            }

            protected void visitClassesFolder(IFolder folder) throws CoreException {
                IPath classesPath = this.getEJBClassesPath();
                folder.accept(EJBClientJARRemovalOperation.this.getFolderResourceVisitor(folder.getFullPath(), classesPath));
            }

            private IPath getEJBClassesPath() throws CoreException {
                IFolder folder = EJBClientJARRemovalOperation.this.ejbProject.getFolder("imported_classes");
                if (!folder.exists()) {
                    folder.create(true, true, null);
                }
                JemProjectUtilities.appendJavaClassPath((IProject)EJBClientJARRemovalOperation.this.ejbProject, (IClasspathEntry)JavaCore.newLibraryEntry((IPath)folder.getFullPath(), null, null, (boolean)true));
                return folder.getFullPath();
            }
        };
    }

    private IResourceVisitor getFolderResourceVisitor(final IPath sourceRoot, final IPath destinationRoot) {
        return new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (EJBClientJARRemovalOperation.this.moveResourceMonitor.isCanceled()) {
                    return false;
                }
                switch (resource.getType()) {
                    case 1: {
                        if (!resource.isDerived() && !this.isManifest(sourceRoot, resource.getFullPath())) {
                            EJBClientJARRemovalOperation.this.moveFile((IFile)resource, sourceRoot, destinationRoot);
                        }
                        return false;
                    }
                    case 2: {
                        return true;
                    }
                }
                return false;
            }

            private boolean isManifest(IPath new_sourceRoot, IPath path) {
                String relativeURI = path.removeFirstSegments(new_sourceRoot.segmentCount()).toString();
                return "META-INF/MANIFEST.MF".equals(relativeURI);
            }
        };
    }

    private void moveFile(IFile file, IPath sourceRoot, IPath destinationRoot) throws CoreException {
        IPath filePath = file.getFullPath();
        IPath relativeFilePath = filePath.removeFirstSegments(sourceRoot.segmentCount());
        IPath newPath = destinationRoot.append(relativeFilePath);
        this.mkdirs(newPath, this.workspace.getRoot());
        IFile existing = this.workspace.getRoot().getFile(newPath);
        if (!this.yesToAll && existing.exists()) {
            String message = this.format(ClientJARCreationConstants.SHOULD_OVERWRITE, new String[]{filePath.toString(), newPath.toString()});
            int answer = 1;
            if (this.operationHandler != null) {
                answer = this.operationHandler.canContinueWithAllCheckAllowCancel(message);
            }
            switch (answer) {
                case 0: {
                    break;
                }
                case 1: {
                    this.yesToAll = true;
                    break;
                }
                case 2: {
                    return;
                }
                case 3: {
                    this.moveResourceMonitor.setCanceled(true);
                    return;
                }
            }
        }
        if (!existing.exists()) {
            file.move(newPath, true, this.moveResourceMonitor);
        } else {
            existing.setContents(file.getContents(), true, true, this.moveResourceMonitor);
        }
    }

    private void removeClientProjectFromEARs() {
        int i = 0;
        while (i < this.earNatures.length) {
            this.removeClientProjectFromEAR(this.earNatures[i]);
            ++i;
        }
    }

    /*
     * Exception decompiling
     */
    private void removeClientProjectFromEAR(EARNatureRuntime runtime) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 84->88)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void deleteClientProject() throws CoreException {
        if (this.shouldDelete) {
            this.clientProject.delete(true, true, this.createSubProgressMonitor(1));
        }
    }
}

