/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ejb.project.operations;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.internal.earcreation.EARNatureRuntime;
import org.eclipse.jst.j2ee.internal.ejb.project.EJBNatureRuntime;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.ClientJARCreationConstants;
import org.eclipse.jst.j2ee.internal.project.J2EENature;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.operations.IOperationHandler;
import org.eclipse.wst.common.internal.emfworkbench.operation.EditModelOperation;

public abstract class AbstractEJBClientJAROperation
extends EditModelOperation {
    protected static final String SERVICE_LOCATOR_JAR_NAME = "serviceLocatorMgr.jar";
    protected IProject ejbProject;
    protected IProject clientProject;
    protected IWorkspace workspace;
    protected Object validateEditContext;
    protected EARNatureRuntime[] earNatures;
    protected EJBNatureRuntime ejbNature;
    protected IOperationHandler operationHandler;
    protected IProgressMonitor monitor;
    protected IProgressMonitor moveResourceMonitor;

    public AbstractEJBClientJAROperation(IDataModel dataModel, IOperationHandler opHandler) {
        this.ejbProject = this.getEJBProject(dataModel.getStringProperty("IComponentCreationDataModelProperties.PROJECT_NAME"));
        this.operationHandler = opHandler;
        this.validateEditContext = opHandler.getContext();
    }

    public AbstractEJBClientJAROperation(IDataModel dataModel) {
        this.ejbProject = this.getEJBProject(dataModel.getStringProperty("IComponentCreationDataModelProperties.PROJECT_NAME"));
        this.operationHandler = null;
    }

    protected void initialize() {
        this.workspace = this.ejbProject.getWorkspace();
        this.ejbNature = (EJBNatureRuntime)J2EENature.getRegisteredRuntime((IProject)this.ejbProject);
        this.earNatures = this.ejbNature.getReferencingEARProjects();
    }

    protected boolean verifyFilesInSync() throws CoreException {
        if (this.verifyFilesInSync(this.ejbProject)) {
            return this.verifyFilesInSync(this.clientProject);
        }
        return false;
    }

    protected boolean verifyFilesInSync(IProject project) throws CoreException {
        if (!project.exists()) {
            return true;
        }
        if (!project.isSynchronized(2)) {
            String message = this.format(ClientJARCreationConstants.FILES_OUT_OF_SYNC, new String[]{project.getName()});
            if (this.operationHandler == null || this.operationHandler.canContinue(message)) {
                this.ejbProject.refreshLocal(2, this.createSubProgressMonitor(1));
            } else {
                return false;
            }
        }
        return true;
    }

    protected IProject getEJBProject(String aProjectName) {
        return this.getWorkspace().getRoot().getProject(aProjectName);
    }

    protected String format(String aPattern, String[] args) {
        return MessageFormat.format(aPattern, args);
    }

    protected IProgressMonitor createSubProgressMonitor(int ticks) {
        return new SubProgressMonitor(this.monitor, ticks);
    }

    protected abstract void addAdditionalFilesForValidateEdit(List var1) throws CoreException;

    protected List normalize(String[] mfEntries, EARNatureRuntime nature, boolean filterServiceLocator) {
        String jarURI = nature.getJARUri(this.ejbProject);
        if (jarURI == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> result = new ArrayList<String>(mfEntries.length);
        int i = 0;
        while (i < mfEntries.length) {
            String norm = ArchiveUtil.deriveEARRelativeURI((String)mfEntries[i], (String)jarURI);
            if (norm == null) {
                norm = mfEntries[i];
            }
            if (!SERVICE_LOCATOR_JAR_NAME.equals(norm) || !filterServiceLocator) {
                result.add(norm);
            }
            ++i;
        }
        return result;
    }

    protected void copyOutgoingClasspathEntries(IProject source, IProject target, boolean filterServiceLocator) throws JavaModelException {
        IJavaProject sourceJProject = JemProjectUtilities.getJavaProject((IProject)source);
        IJavaProject targetJProject = JemProjectUtilities.getJavaProject((IProject)target);
        IClasspathEntry[] sourceCp = sourceJProject.getRawClasspath();
        ArrayList<IClasspathEntry> targetCp = new ArrayList<IClasspathEntry>(Arrays.asList(targetJProject.getRawClasspath()));
        int i = 0;
        while (i < sourceCp.length) {
            IClasspathEntry entry = sourceCp[i];
            if (!(this.isContainedInProject(entry, source) || this.contains(targetCp, entry) || this.isServiceLocator(entry) && filterServiceLocator)) {
                targetCp.add(entry);
            }
            ++i;
        }
        IClasspathEntry[] newCp = targetCp.toArray(new IClasspathEntry[targetCp.size()]);
        targetJProject.setRawClasspath(newCp, null);
    }

    private boolean isServiceLocator(IClasspathEntry entry) {
        IPath path = entry.getPath();
        return path != null && SERVICE_LOCATOR_JAR_NAME.equals(path.lastSegment());
    }

    protected boolean isContainedInProject(IClasspathEntry entry, IProject project) {
        return !entry.getPath().isEmpty() && project.getName().equals(entry.getPath().segment(0));
    }

    protected boolean contains(List cp, IClasspathEntry entry) {
        int i = 0;
        while (i < cp.size()) {
            IClasspathEntry elmt = (IClasspathEntry)cp.get(i);
            if (elmt.getEntryKind() == entry.getEntryKind() && elmt.getPath().equals((Object)entry.getPath())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void mkdirs(IPath newPath, IWorkspaceRoot root) throws CoreException {
        if (newPath.segmentCount() <= 2) {
            return;
        }
        IPath parentPath = newPath.removeLastSegments(1);
        IFolder folder = root.getFolder(parentPath);
        if (!folder.exists()) {
            this.mkdirs(parentPath, root);
            folder.create(true, true, null);
        }
    }

    protected void cleanProject(IProject project) throws CoreException {
        if (project != null) {
            project.build(15, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
        }
    }

    protected void doDispose(IProgressMonitor new_monitor) {
        try {
            this.cleanProjects();
        }
        catch (CoreException ex) {
            Logger.getLogger().logError((Throwable)ex);
        }
        super.doDispose(new_monitor);
    }

    protected void cleanProjects() throws CoreException {
        this.cleanProject(this.ejbProject);
    }
}

