/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ejb.project;

import java.util.logging.Level;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.internal.earcreation.EARNatureRuntime;
import org.eclipse.jst.j2ee.internal.ejb.project.EJBEditModel;
import org.eclipse.jst.j2ee.internal.ejb.project.EJBNatureRuntime;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPluginResourceHandler;

public class EJBProjectResources {
    private IProject _project = null;
    private EJBEditModel _editModel = null;
    private ModuleFile _moduleFile = null;
    private EJBJar _ejbJar = null;
    private EARNatureRuntime _earNature = null;
    private static LogEntry _logEntry = null;

    public EJBProjectResources(IProject project) {
        this._project = project;
    }

    public static Logger getMsgLogger() {
        return J2EEPlugin.getPlugin().getMsgLogger();
    }

    public static LogEntry getDefaultMessage() {
        if (_logEntry == null) {
            _logEntry = new LogEntry("ejbvalidator");
        }
        _logEntry.reset();
        return _logEntry;
    }

    public void cleanup() {
        block4: {
            try {
                if (this._moduleFile != null) {
                    this._moduleFile.close();
                }
                if (this._editModel != null) {
                    this._editModel.releaseAccess(this);
                    this._editModel = null;
                }
            }
            catch (Throwable exc) {
                Logger logger = EJBProjectResources.getMsgLogger();
                if (!logger.isLoggingLevel(Level.FINER)) break block4;
                logger.write(Level.FINER, exc);
            }
        }
    }

    public EARNatureRuntime getEARNature() {
        if (this._earNature == null) {
            this._earNature = this.getEARNatureRuntime();
        }
        return this._earNature;
    }

    private EARNatureRuntime getEARNatureRuntime() {
        if (this.getProject() == null) {
            return null;
        }
        EARNatureRuntime earNature = null;
        if (!EARNatureRuntime.hasRuntime((IProject)this.getProject())) {
            return null;
        }
        earNature = EARNatureRuntime.getRuntime((IProject)this.getProject());
        return earNature;
    }

    public EJBEditModel getEditModel() {
        if (this._editModel == null) {
            EJBNatureRuntime runtime = this.getEJBNatureRuntime();
            if (runtime == null) {
                return null;
            }
            this._editModel = runtime.getEJBEditModelForRead(this);
        }
        return this._editModel;
    }

    public ModuleFile getEJBFile() {
        if (this._moduleFile == null) {
            this._moduleFile = EJBProjectResources.getEJBFile(this.getEditModel());
        }
        return this._moduleFile;
    }

    public static ModuleFile getEJBFile(EJBEditModel model) {
        EARFile ejbFile;
        block18: {
            Logger logger = EJBProjectResources.getMsgLogger();
            ejbFile = null;
            if (model == null) {
                if (logger.isLoggingLevel(Level.FINE)) {
                    LogEntry entry = EJBProjectResources.getDefaultMessage();
                    entry.setSourceIdentifier("EJBProjectResources.getEJBFile(EJBEditModel)");
                    entry.setText(J2EEPluginResourceHandler.getString((String)"Cannot_load_EJBFile_because_EJBEditModel_is_null_UI_"));
                    logger.write(Level.FINE, (Object)entry);
                }
                return null;
            }
            try {
                EJBNatureRuntime ejbNature = model.getEJBNature();
                if (ejbNature == null) {
                    if (logger.isLoggingLevel(Level.FINE)) {
                        LogEntry entry = EJBProjectResources.getDefaultMessage();
                        entry.setSourceIdentifier("EJBProjectResources.getEJBFile(EJBEditModel)");
                        entry.setText(J2EEPluginResourceHandler.getString((String)"Cannot_load_EJBFile_because_EJBNatureRuntime_is_null_UI_"));
                        logger.write(Level.FINE, (Object)entry);
                    }
                    return null;
                }
                IFolder metaFolder = ejbNature.getMetaFolder();
                if (metaFolder == null || !metaFolder.exists()) {
                    if (logger.isLoggingLevel(Level.SEVERE)) {
                        LogEntry entry = EJBProjectResources.getDefaultMessage();
                        entry.setSourceIdentifier("EJBProjectResources.getEJBFile(EJBEditModel)");
                        entry.setMessageTypeIdentifier(J2EEPluginResourceHandler.getString((String)"WARNING_METAFOLDER_MISSING_UI_"));
                        String metaFolderName = metaFolder == null ? "META-INF" : metaFolder.getName();
                        entry.setTokens(new String[]{metaFolderName, ejbNature.getProject().getName(), ejbNature.getProject().getName()});
                        logger.write(Level.SEVERE, (Object)entry);
                    }
                    return null;
                }
                IResource ejb_jar_xml = metaFolder.findMember("ejb-jar.xml");
                if (ejb_jar_xml == null || !ejb_jar_xml.exists()) {
                    if (logger.isLoggingLevel(Level.SEVERE)) {
                        LogEntry entry = EJBProjectResources.getDefaultMessage();
                        entry.setSourceIdentifier("EJBProjectResources.getEJBFile(EJBEditModel)");
                        entry.setMessageTypeIdentifier(J2EEPluginResourceHandler.getString((String)"WARNING_FILE_MISSING_UI_"));
                        String ejbJarID = ejb_jar_xml == null ? "ejb-jar.xml" : ejb_jar_xml.getName();
                        entry.setTokens(new String[]{ejbJarID, ejbNature.getProject().getName()});
                        logger.write(Level.SEVERE, (Object)entry);
                    }
                    return null;
                }
                try {
                    EARFile earFile;
                    EARFile ejbJarFile = null;
                    try {
                        ejbJarFile = null;
                    }
                    catch (NullPointerException exc) {
                        if (logger.isLoggingLevel(Level.FINE)) {
                            logger.write(Level.FINE, (Exception)exc);
                        }
                        return null;
                    }
                    if (ejbJarFile == null) {
                        if (logger.isLoggingLevel(Level.FINE)) {
                            LogEntry entry = EJBProjectResources.getDefaultMessage();
                            entry.setSourceIdentifier("EJBProjectResources.getEJBFile(EJBEditModel)");
                            entry.setText(J2EEPluginResourceHandler.getString((String)"Cannot_load_EJBFile_because_ejbNature.asEJBJarFile()_returns_null_UI_"));
                            logger.write(Level.FINE, (Object)entry);
                        }
                        return null;
                    }
                    ejbFile = ejbJarFile;
                    ejbFile = earFile = ejbJarFile.getEARFile();
                    if (earFile != null) {
                        ejbJarFile.close();
                    }
                }
                catch (Exception exception) {}
            }
            catch (Throwable exc) {
                ejbFile = null;
                if (!logger.isLoggingLevel(Level.FINER)) break block18;
                logger.write(Level.FINER, exc);
            }
        }
        return ejbFile;
    }

    public EJBJar getEJBJar() {
        if (this._ejbJar == null) {
            this._ejbJar = EJBProjectResources.getEJBJar(this.getEditModel());
        }
        return this._ejbJar;
    }

    public EJBNatureRuntime getEJBNature() {
        return EJBNatureRuntime.getRuntime(this.getProject());
    }

    private EJBNatureRuntime getEJBNatureRuntime() {
        if (this.getProject() == null) {
            return null;
        }
        EJBNatureRuntime ejbNature = null;
        if (!EJBNatureRuntime.hasRuntime(this.getProject())) {
            return null;
        }
        ejbNature = EJBNatureRuntime.getRuntime(this.getProject());
        return ejbNature;
    }

    public IProject getProject() {
        return this._project;
    }

    public static EJBJar getEJBJar(EJBEditModel model) {
        EJBJar ejbJar;
        block11: {
            Logger logger = EJBProjectResources.getMsgLogger();
            ejbJar = null;
            if (model == null) {
                if (logger.isLoggingLevel(Level.FINE)) {
                    LogEntry entry = EJBProjectResources.getDefaultMessage();
                    entry.setSourceIdentifier(J2EEPluginResourceHandler.getString((String)"EJBProjectResources.getEJBJar(EJBEditModel)_UI_"));
                    entry.setText(J2EEPluginResourceHandler.getString((String)"Cannot_load_EJBJar_because_model_is_null_UI_"));
                    logger.write(Level.FINE, (Object)entry);
                }
                return null;
            }
            try {
                EJBNatureRuntime ejbNature = model.getEJBNature();
                if (ejbNature == null) {
                    if (logger.isLoggingLevel(Level.FINE)) {
                        LogEntry entry = EJBProjectResources.getDefaultMessage();
                        entry.setSourceIdentifier("EJBProjectResources.getEJBJar(EJBEditModel)");
                        entry.setText(J2EEPluginResourceHandler.getString((String)"Cannot_load_EJBFile_because_EJBNatureRuntime_is_null_UI_"));
                        logger.write(Level.FINE, (Object)entry);
                    }
                    return null;
                }
                if (!ejbNature.isBinaryProject()) {
                    IFolder metaFolder = ejbNature.getMetaFolder();
                    if (metaFolder == null || !metaFolder.exists()) {
                        if (logger.isLoggingLevel(Level.WARNING)) {
                            LogEntry entry = EJBProjectResources.getDefaultMessage();
                            entry.setSourceIdentifier("EJBProjectResources.getEJBJar(EJBEditModel)");
                            entry.setMessageTypeIdentifier(J2EEPluginResourceHandler.getString((String)"WARNING_METAFOLDER_MISSING_UI_"));
                            String metaName = metaFolder == null ? "ejbModule" : metaFolder.getName();
                            entry.setTokens(new String[]{metaName, ejbNature.getProject().getName(), ejbNature.getProject().getName()});
                            logger.write(Level.WARNING, (Object)entry);
                        }
                        return null;
                    }
                    IResource ejb_jar_xml = metaFolder.findMember("ejb-jar.xml");
                    if (ejb_jar_xml == null || !ejb_jar_xml.exists()) {
                        if (logger.isLoggingLevel(Level.WARNING)) {
                            LogEntry entry = EJBProjectResources.getDefaultMessage();
                            entry.setSourceIdentifier("EJBProjectResources.getEJBJar(EJBEditModel)");
                            entry.setMessageTypeIdentifier(J2EEPluginResourceHandler.getString((String)"WARNING_FILE_MISSING_UI_"));
                            entry.setTokens(new String[]{"ejb-jar.xml", ejbNature.getProject().getName()});
                            logger.write(Level.WARNING, (Object)entry);
                        }
                        return null;
                    }
                }
                ejbJar = model.getEJBJar();
            }
            catch (Throwable exc) {
                ejbJar = null;
                if (!logger.isLoggingLevel(Level.FINER)) break block11;
                logger.write(Level.FINER, exc);
            }
        }
        return ejbJar;
    }
}

