/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.internal.plugin;

import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.internal.boot.PlatformURLConnection;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.internal.ejb.archiveoperations.IEJBArchiveTransformationOperation;
import org.eclipse.jst.j2ee.internal.ejb.impl.EJBJarResourceFactory;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPluginResourceHandler;
import org.eclipse.wst.common.componentcore.internal.impl.WTPResourceFactoryRegistry;
import org.eclipse.wst.common.frameworks.internal.WTPPlugin;
import org.eclipse.wst.common.internal.emf.resource.FileNameResourceFactoryRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class EjbPlugin
extends WTPPlugin
implements ResourceLocator {
    private static EjbPlugin inst;
    protected final IPath iconsFolder = new Path(Platform.getBundle((String)"org.eclipse.jst.j2ee.ejb").getEntry("icons").getPath());
    public static final String PLUGIN_ID = "org.eclipse.jst.j2ee.ejb";
    private static IPath location;

    public EjbPlugin() {
        if (inst == null) {
            inst = this;
        }
    }

    public static EjbPlugin getDefault() {
        return inst;
    }

    public URL getBaseURL() {
        return this.getBundle().getEntry("/");
    }

    public Object getImage(String key) {
        return J2EEPlugin.getImageURL((String)key, (Bundle)this.getBundle());
    }

    public static IPath getInstallLocation() {
        if (location == null) {
            URL url = EjbPlugin.getInstallURL();
            try {
                String installLocation = ((PlatformURLConnection)url.openConnection()).getURLAsLocal().getFile();
                location = new Path(installLocation);
            }
            catch (IOException e) {
                Logger.getLogger().logWarning(String.valueOf(J2EEPluginResourceHandler.getString((String)"Install_Location_Error_", (Object[])new Object[]{url})) + e);
            }
        }
        return location;
    }

    public static URL getInstallURL() {
        return EjbPlugin.getDefault().getBundle().getEntry("/");
    }

    public static EjbPlugin getPlugin() {
        return inst;
    }

    public static IPath getPluginLocation(String pluginId) {
        Platform.getExtensionRegistry();
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle != null) {
            try {
                IPath installPath = new Path(bundle.getEntry("/").toExternalForm()).removeTrailingSeparator();
                String installStr = Platform.asLocalURL((URL)new URL(installPath.toString())).getFile();
                return new Path(installStr);
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public static IStatus createErrorStatus(String aMessage, Throwable exception) {
        return EjbPlugin.createErrorStatus(0, aMessage, exception);
    }

    public static IStatus newOperationFailedStatus(String aMessage, Throwable exception) {
        return EjbPlugin.createStatus(4, 76, aMessage, exception);
    }

    public static IStatus createStatus(int severity, int aCode, String aMessage, Throwable exception) {
        return new Status(severity, PLUGIN_ID, aCode, aMessage, exception);
    }

    public String getString(String key) {
        return Platform.getResourceString((Bundle)this.getBundle(), (String)key);
    }

    public String getString(String key, Object[] substitutions) {
        return MessageFormat.format(this.getString(key), substitutions);
    }

    public String getPluginID() {
        return PLUGIN_ID;
    }

    public static IStatus createErrorStatus(int aCode, String aMessage, Throwable exception) {
        return EjbPlugin.createStatus(4, aCode, aMessage, exception);
    }

    public IEJBArchiveTransformationOperation getExtendedArchiveOperation() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint pct = registry.getExtensionPoint("org.eclipse.jst.j2ee", "PreAndPostArchiveOperation");
        IExtension[] extension = pct.getExtensions();
        int l = 0;
        while (l < extension.length) {
            IExtension config = extension[l];
            IConfigurationElement[] cElems = config.getConfigurationElements();
            int i = 0;
            while (i < cElems.length) {
                IConfigurationElement d = cElems[i];
                if (d.getName().equals("operation")) {
                    try {
                        return (IEJBArchiveTransformationOperation)d.createExecutableExtension("run");
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                ++i;
            }
            ++l;
        }
        return null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        EJBJarResourceFactory.register((FileNameResourceFactoryRegistry)WTPResourceFactoryRegistry.INSTANCE);
    }

    public String getString(String key, boolean translate) {
        return this.getString(key);
    }

    public String getString(String key, Object[] substitutions, boolean translate) {
        return this.getString(key, substitutions);
    }
}

