/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.wizard.page;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.util.SocketUtil;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ProgressUtil;
import org.eclipse.wst.server.ui.internal.SWTUtil;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.viewers.ServerTypeComposite;
import org.eclipse.wst.server.ui.internal.wizard.page.ElementCreationCache;

public class NewManualServerComposite
extends Composite {
    protected IWizardHandle2 wizard;
    private ServerTypeComposite serverTypeComposite;
    protected Label runtimeLabel;
    protected Combo runtimeCombo;
    protected IRuntime[] runtimes;
    protected IRuntime runtime;
    protected IServerWorkingCopy server;
    protected ServerSelectionListener listener;
    protected String host;
    protected IModuleType moduleType;
    protected ElementCreationCache cache = new ElementCreationCache();

    public NewManualServerComposite(Composite parent, IWizardHandle2 wizard, IModuleType moduleType, ServerSelectionListener listener) {
        super(parent, 0);
        this.wizard = wizard;
        this.listener = listener;
        this.moduleType = moduleType;
        this.createControl();
        wizard.setMessage("", 3);
    }

    protected void createControl() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = SWTUtil.convertHorizontalDLUsToPixels(this, 4);
        layout.verticalSpacing = SWTUtil.convertVerticalDLUsToPixels(this, 4);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.setFont(this.getParent().getFont());
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        whs.setHelp((Control)this, "org.eclipse.wst.server.ui.swns0000");
        this.serverTypeComposite = new ServerTypeComposite(this, 0, this.moduleType, new ServerTypeComposite.ServerTypeSelectionListener(){

            public void serverTypeSelected(IServerType type2) {
                NewManualServerComposite.this.handleTypeSelection(type2);
            }
        });
        this.serverTypeComposite.setIncludeIncompatibleVersions(true);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        this.serverTypeComposite.setLayoutData(data);
        whs.setHelp((Control)this.serverTypeComposite, "org.eclipse.wst.server.ui.swns0006");
        this.runtimeLabel = new Label((Composite)this, 0);
        this.runtimeLabel.setText(Messages.wizNewServerRuntime);
        this.runtimeCombo = new Combo((Composite)this, 8);
        data = new GridData(768);
        this.runtimeCombo.setLayoutData((Object)data);
        this.runtimeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    NewManualServerComposite.this.runtime = NewManualServerComposite.this.runtimes[NewManualServerComposite.this.runtimeCombo.getSelectionIndex()];
                    if (NewManualServerComposite.this.server != null) {
                        NewManualServerComposite.this.server.setRuntime(NewManualServerComposite.this.runtime);
                        NewManualServerComposite.this.listener.runtimeSelected(NewManualServerComposite.this.runtime);
                    }
                }
                catch (Exception exception) {}
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Dialog.applyDialogFont((Control)this);
    }

    public void setHost(String host) {
        this.host = host;
        if (this.serverTypeComposite == null) {
            return;
        }
        if (host == null) {
            this.serverTypeComposite.setHost(true);
        } else if (SocketUtil.isLocalhost((String)host)) {
            this.serverTypeComposite.setHost(true);
        } else {
            this.serverTypeComposite.setHost(false);
        }
        if (this.server != null) {
            this.server.setHost(host);
            ServerUtil.setServerDefaultName((IServerWorkingCopy)this.server);
        }
    }

    protected void loadServerImpl(final IServerType serverType) {
        this.server = null;
        if (serverType == null) {
            return;
        }
        this.server = this.cache.getCachedServer(serverType, this.host);
        if (this.server != null) {
            this.server.setHost(this.host);
            ServerUtil.setServerDefaultName((IServerWorkingCopy)this.server);
            this.runtime = this.server.getRuntime();
            return;
        }
        final CoreException[] ce = new CoreException[1];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) {
                try {
                    try {
                        monitor = ProgressUtil.getMonitorFor(monitor);
                        int ticks = 200;
                        monitor.beginTask(NLS.bind((String)Messages.loadingTask, (Object)serverType.getName()), ticks);
                        NewManualServerComposite.this.server = NewManualServerComposite.this.cache.getServer(serverType, NewManualServerComposite.this.host, ProgressUtil.getSubMonitorFor(monitor, 200));
                        if (NewManualServerComposite.this.server != null) {
                            NewManualServerComposite.this.server.setHost(NewManualServerComposite.this.host);
                            ServerUtil.setServerDefaultName((IServerWorkingCopy)NewManualServerComposite.this.server);
                            if (serverType.hasRuntime() && NewManualServerComposite.this.server.getRuntime() == null) {
                                NewManualServerComposite.this.server.setRuntime(NewManualServerComposite.this.runtime);
                                if (NewManualServerComposite.this.server.getServerType().hasServerConfiguration()) {
                                    ((Server)NewManualServerComposite.this.server).importConfiguration(NewManualServerComposite.this.runtime, null);
                                }
                            }
                        }
                    }
                    catch (CoreException cex) {
                        ce[0] = cex;
                    }
                    catch (Throwable t) {
                        Trace.trace(Trace.SEVERE, "Error creating element", t);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_6 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_7 = null;
                }
                monitor.done();
            }
        };
        try {
            this.wizard.run(true, false, runnable);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error with runnable", e);
        }
        if (ce[0] != null) {
            this.wizard.setMessage(ce[0].getLocalizedMessage(), 3);
        } else if (this.server == null) {
            this.wizard.setMessage(Messages.wizErrorServerCreationError, 3);
        }
    }

    protected IRuntime getDefaultRuntime() {
        if (this.runtimes == null || this.runtimes.length == 0) {
            return null;
        }
        if (this.runtimes != null) {
            int size = this.runtimes.length;
            int i = 0;
            while (i < size) {
                if (!this.runtimes[i].isStub()) {
                    return this.runtimes[i];
                }
                ++i;
            }
        }
        return this.runtimes[0];
    }

    protected void updateRuntimeCombo(IServerType serverType) {
        int i;
        this.runtime = null;
        if (serverType == null || !serverType.hasRuntime()) {
            if (this.runtimeLabel != null) {
                this.runtimeLabel.setEnabled(false);
                this.runtimeCombo.setItems(new String[0]);
                this.runtimeCombo.setEnabled(false);
                this.runtimeLabel.setVisible(false);
                this.runtimeCombo.setVisible(false);
            }
            return;
        }
        IRuntimeType runtimeType = serverType.getRuntimeType();
        this.runtimes = ServerUIPlugin.getRuntimes(runtimeType);
        if (this.server != null && SocketUtil.isLocalhost((String)this.server.getHost()) && this.runtimes != null) {
            ArrayList<IRuntime> runtimes2 = new ArrayList<IRuntime>();
            int size = this.runtimes.length;
            i = 0;
            while (i < size) {
                IRuntime runtime2 = this.runtimes[i];
                if (!runtime2.isStub()) {
                    runtimes2.add(runtime2);
                }
                ++i;
            }
            this.runtimes = new IRuntime[runtimes2.size()];
            runtimes2.toArray(this.runtimes);
        }
        if (this.runtimes.length == 0) {
            try {
                IRuntimeWorkingCopy runtimeWC = runtimeType.createRuntime(null, null);
                ServerUtil.setRuntimeDefaultName((IRuntimeWorkingCopy)runtimeWC);
                this.runtimes = new IRuntime[1];
                this.runtimes[0] = runtimeWC;
            }
            catch (Exception e) {
                Trace.trace(Trace.SEVERE, "Couldn't create runtime", e);
            }
        }
        int size = this.runtimes.length;
        String[] items = new String[size];
        i = 0;
        while (i < size) {
            items[i] = this.runtimes[i].getName();
            ++i;
        }
        this.runtime = this.getDefaultRuntime();
        if (this.runtimeCombo != null) {
            this.runtimeCombo.setItems(items);
            if (this.runtimes.length > 0) {
                i = 0;
                while (i < size) {
                    if (this.runtimes[i].equals(this.runtime)) {
                        this.runtimeCombo.select(i);
                    }
                    ++i;
                }
            }
            this.runtimeCombo.setEnabled(size > 1);
            this.runtimeLabel.setEnabled(size > 1);
            this.runtimeLabel.setVisible(size > 1);
            this.runtimeCombo.setVisible(size > 1);
        }
    }

    protected void handleTypeSelection(IServerType serverType) {
        IRuntimeType runtimeType;
        boolean wrong = false;
        if (serverType != null && this.moduleType != null && !ServerUtil.isSupportedModule((IModuleType[])(runtimeType = serverType.getRuntimeType()).getModuleTypes(), (IModuleType)this.moduleType)) {
            serverType = null;
            wrong = true;
        }
        this.updateRuntimeCombo(serverType);
        if (wrong) {
            this.wizard.setMessage(NLS.bind((String)Messages.errorVersionLevel, (Object[])new Object[]{this.moduleType.getName(), this.moduleType.getVersion()}), 3);
        } else if (serverType == null) {
            this.wizard.setMessage("", 3);
        } else {
            this.wizard.setMessage(null, 0);
            this.loadServerImpl(serverType);
        }
        this.listener.serverSelected((IServerAttributes)this.server);
        this.wizard.update();
    }

    public void setVisible(boolean visible) {
        Control[] c;
        super.setVisible(visible);
        if (visible) {
            this.handleTypeSelection(null);
        }
        if ((c = this.getChildren()) != null) {
            int size = c.length;
            int i = 0;
            while (i < size) {
                if (c[i] != null && c[i] instanceof ServerTypeComposite) {
                    c[i].setVisible(visible);
                }
                ++i;
            }
        }
        if (visible) {
            this.handleTypeSelection(this.serverTypeComposite.getSelectedServerType());
        }
    }

    public IRuntime getRuntime() {
        return this.runtime;
    }

    public IServerWorkingCopy getServer() {
        return this.server;
    }

    public static interface ServerSelectionListener {
        public void serverSelected(IServerAttributes var1);

        public void runtimeSelected(IRuntime var1);
    }

    public static interface IWizardHandle2 {
        public void run(boolean var1, boolean var2, IRunnableWithProgress var3) throws InterruptedException, InvocationTargetException;

        public void update();

        public void setMessage(String var1, int var2);
    }
}

