/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.ui.internal.EclipseUtil;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.wizard.TaskWizard;
import org.eclipse.wst.server.ui.internal.wizard.TaskWizardPage;
import org.eclipse.wst.server.ui.internal.wizard.page.WorkspaceRunnableAdapter;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class TaskWizard
implements IWizard {
    private static final byte FINISH = 2;
    private static final byte CANCEL = 3;
    private List pages;
    private boolean addingPages;
    private Map fragmentData = new HashMap();
    protected TaskModel taskModel;
    private IWizardContainer container = null;
    private boolean needsProgressMonitor = false;
    private boolean forcePreviousAndNextButtons = false;
    private boolean isHelpAvailable = false;
    private Image defaultImage = null;
    private RGB titleBarColor = null;
    private String windowTitle = null;
    private IDialogSettings dialogSettings = null;
    private WizardFragment rootFragment;
    private WizardFragment currentFragment;

    public TaskWizard(String title, WizardFragment rootFragment) {
        this(title, rootFragment, null);
        this.setWindowTitle(title);
    }

    public TaskWizard(String title, WizardFragment rootFragment, TaskModel taskModel) {
        if (title != null) {
            this.setWindowTitle(title);
        }
        this.rootFragment = rootFragment;
        this.taskModel = taskModel;
        if (taskModel == null) {
            this.taskModel = new TaskModel();
        }
        this.setNeedsProgressMonitor(true);
        this.setForcePreviousAndNextButtons(true);
    }

    public void setTaskModel(TaskModel taskModel) {
        this.taskModel = taskModel;
    }

    public TaskModel getTaskModel() {
        return this.taskModel;
    }

    public void setRootFragment(WizardFragment rootFragment) {
        this.rootFragment = rootFragment;
    }

    public WizardFragment getRootFragment() {
        return this.rootFragment;
    }

    public boolean performCancel() {
        final List list = this.getAllWizardFragments();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        TaskWizard.this.executeTask((WizardFragment)iterator.next(), (byte)3, monitor);
                    }
                }
                catch (CoreException ce) {
                    throw new InvocationTargetException(ce);
                }
            }
        };
        Throwable t = null;
        try {
            if (this.getContainer() != null) {
                this.getContainer().run(true, true, runnable);
            } else {
                runnable.run((IProgressMonitor)new NullProgressMonitor());
            }
            return true;
        }
        catch (InvocationTargetException te) {
            t = te.getCause();
        }
        catch (Exception e) {
            t = e;
        }
        Trace.trace(Trace.SEVERE, "Error cancelling task wizard", t);
        if (t instanceof CoreException) {
            EclipseUtil.openError(t.getLocalizedMessage(), ((CoreException)t).getStatus());
        } else {
            EclipseUtil.openError(t.getLocalizedMessage());
        }
        return false;
    }

    public boolean performFinish() {
        if (this.currentFragment != null) {
            this.currentFragment.exit();
        }
        final WizardFragment cFragment = this.currentFragment;
        final List list = this.getAllWizardFragments();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                int index = list.indexOf(cFragment);
                while (index > 0 && index < list.size() - 1) {
                    WizardFragment fragment = (WizardFragment)list.get(++index);
                    try {
                        Display.getDefault().syncExec(new Runnable(this, fragment){
                            final /* synthetic */ 2 this$1;
                            private final /* synthetic */ WizardFragment val$fragment;
                            {
                                this.this$1 = var1_1;
                                this.val$fragment = wizardFragment;
                            }

                            public void run() {
                                this.val$fragment.enter();
                                this.val$fragment.exit();
                            }
                        });
                    }
                    catch (Exception e) {
                        Trace.trace(Trace.WARNING, "Could not enter/exit page", e);
                    }
                }
                if (TaskWizard.this.useJob()) {
                    class FinishWizardJob
                    extends Job {
                        final /* synthetic */ 2 this$1;
                        private final /* synthetic */ List val$list;

                        public FinishWizardJob(2 var1_1, List list) {
                            super(2.access$0(var1_1).getJobTitle());
                            this.this$1 = var1_1;
                            this.val$list = list;
                        }

                        public boolean belongsTo(Object family) {
                            return "org.eclipse.wst.server.ui.family".equals(family);
                        }

                        public IStatus run(IProgressMonitor monitor2) {
                            try {
                                Iterator<E> iterator = this.val$list.iterator();
                                while (iterator.hasNext()) {
                                    2.access$0(this.this$1).executeTask((WizardFragment)iterator.next(), (byte)2, monitor2);
                                }
                            }
                            catch (CoreException ce) {
                                Trace.trace(Trace.SEVERE, "Error finishing wizard job", ce);
                                return new Status(4, "org.eclipse.wst.server.ui", 0, ce.getLocalizedMessage(), null);
                            }
                            return new Status(0, "org.eclipse.wst.server.ui", 0, "", null);
                        }
                    }
                    FinishWizardJob job = new FinishWizardJob(this, list);
                    job.setUser(true);
                    job.schedule();
                } else {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        TaskWizard.this.executeTask((WizardFragment)iterator.next(), (byte)2, monitor);
                    }
                }
            }

            static /* synthetic */ TaskWizard access$0(2 var0) {
                return var0.TaskWizard.this;
            }
        };
        Throwable t = null;
        try {
            if (this.getContainer() != null) {
                this.getContainer().run(true, true, (IRunnableWithProgress)new WorkspaceRunnableAdapter(runnable));
            } else {
                runnable.run((IProgressMonitor)new NullProgressMonitor());
            }
            return true;
        }
        catch (InvocationTargetException te) {
            Trace.trace(Trace.SEVERE, "Error finishing task wizard", te);
            t = te.getCause();
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error finishing task wizard 2", e);
            t = e;
        }
        if (t instanceof CoreException) {
            EclipseUtil.openError(t.getLocalizedMessage(), ((CoreException)t).getStatus());
        } else {
            EclipseUtil.openError(t.getLocalizedMessage());
        }
        return false;
    }

    public void addPage(IWizardPage page) {
        this.pages.add(page);
        page.setWizard((IWizard)this);
    }

    protected void executeTask(WizardFragment fragment, byte type, IProgressMonitor monitor) throws CoreException {
        if (fragment == null) {
            return;
        }
        if (type == 2) {
            fragment.performFinish(monitor);
        } else if (type == 3) {
            fragment.performCancel(monitor);
        }
    }

    protected WizardFragment getCurrentWizardFragment() {
        return this.currentFragment;
    }

    protected void switchWizardFragment(WizardFragment newFragment) {
        int newIndex;
        List list = this.getAllWizardFragments();
        int oldIndex = list.indexOf(this.currentFragment);
        if (oldIndex == (newIndex = list.indexOf(newFragment))) {
            return;
        }
        if (this.currentFragment != null) {
            this.currentFragment.exit();
        }
        oldIndex = oldIndex < newIndex ? ++oldIndex : --oldIndex;
        while (oldIndex != newIndex) {
            WizardFragment fragment = (WizardFragment)list.get(oldIndex);
            fragment.enter();
            fragment.exit();
            if (oldIndex < newIndex) {
                ++oldIndex;
                continue;
            }
            --oldIndex;
        }
        this.currentFragment = newFragment;
        this.currentFragment.enter();
    }

    private List getAllWizardFragments() {
        ArrayList<WizardFragment> list = new ArrayList<WizardFragment>();
        list.add(this.rootFragment);
        this.addSubWizardFragments(this.rootFragment, list);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            WizardFragment fragment = (WizardFragment)iterator.next();
            if (this.taskModel.equals(fragment.getTaskModel())) continue;
            fragment.setTaskModel(this.taskModel);
        }
        return list;
    }

    private void addSubWizardFragments(WizardFragment fragment, List list) {
        Iterator iterator = fragment.getChildFragments().iterator();
        while (iterator.hasNext()) {
            WizardFragment child = (WizardFragment)iterator.next();
            list.add(child);
            this.addSubWizardFragments(child, list);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addPages() {
        if (this.addingPages) {
            return;
        }
        try {
            try {
                this.addingPages = true;
                this.pages = new ArrayList();
                Iterator iterator = this.getAllWizardFragments().iterator();
                while (iterator.hasNext()) {
                    WizardFragment fragment = (WizardFragment)iterator.next();
                    TaskWizardPage page = this.getFragmentData(fragment);
                    if (!fragment.hasComposite()) continue;
                    if (page != null) {
                        this.addPage((IWizardPage)page);
                        continue;
                    }
                    TaskWizardPage page2 = new TaskWizardPage(fragment);
                    this.fragmentData.put(fragment, page2);
                    this.addPage((IWizardPage)page2);
                }
            }
            catch (Exception e) {
                Trace.trace(Trace.SEVERE, "Error adding fragments to wizard", e);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.addingPages = false;
            throw throwable;
        }
        {
            Object var5_8 = null;
            this.addingPages = false;
            return;
        }
    }

    private TaskWizardPage getFragmentData(WizardFragment fragment) {
        try {
            TaskWizardPage page = (TaskWizardPage)this.fragmentData.get(fragment);
            if (page != null) {
                return page;
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error getting fragment data", e);
        }
        return null;
    }

    protected void updatePages() {
        this.addPages();
    }

    public boolean canFinish() {
        int i = 0;
        while (i < this.pages.size()) {
            if (!((IWizardPage)this.pages.get(i)).isPageComplete()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void createPageControls(Composite pageContainer) {
        int i = 0;
        while (i < this.pages.size()) {
            IWizardPage page = (IWizardPage)this.pages.get(i);
            page.createControl(pageContainer);
            ++i;
        }
    }

    public void dispose() {
        int i = 0;
        while (i < this.pages.size()) {
            ((IWizardPage)this.pages.get(i)).dispose();
            ++i;
        }
        if (this.defaultImage != null) {
            this.defaultImage.dispose();
            this.defaultImage = null;
        }
    }

    public IWizardContainer getContainer() {
        return this.container;
    }

    public Image getDefaultPageImage() {
        return this.defaultImage;
    }

    public IDialogSettings getDialogSettings() {
        return this.dialogSettings;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        int index = this.pages.indexOf(page);
        if (index == this.pages.size() - 1 || index == -1) {
            return null;
        }
        return (IWizardPage)this.pages.get(index + 1);
    }

    public IWizardPage getPage(String name) {
        int i = 0;
        while (i < this.pages.size()) {
            IWizardPage page = (IWizardPage)this.pages.get(i);
            String pageName = page.getName();
            if (pageName.equals(name)) {
                return page;
            }
            ++i;
        }
        return null;
    }

    public int getPageCount() {
        return this.pages.size();
    }

    public IWizardPage[] getPages() {
        return this.pages.toArray(new IWizardPage[this.pages.size()]);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        int index = this.pages.indexOf(page);
        if (index == 0 || index == -1) {
            return null;
        }
        return (IWizardPage)this.pages.get(index - 1);
    }

    public IWizardPage getStartingPage() {
        if (this.pages.size() == 0) {
            return null;
        }
        return (IWizardPage)this.pages.get(0);
    }

    public RGB getTitleBarColor() {
        return this.titleBarColor;
    }

    public String getWindowTitle() {
        return this.windowTitle;
    }

    public boolean isHelpAvailable() {
        return this.isHelpAvailable;
    }

    public boolean needsPreviousAndNextButtons() {
        return this.forcePreviousAndNextButtons || this.pages.size() > 1;
    }

    public boolean needsProgressMonitor() {
        return this.needsProgressMonitor;
    }

    public void setContainer(IWizardContainer wizardContainer) {
        this.container = wizardContainer;
    }

    public void setDialogSettings(IDialogSettings settings) {
        this.dialogSettings = settings;
    }

    public void setNeedsProgressMonitor(boolean b) {
        this.needsProgressMonitor = b;
    }

    public void setForcePreviousAndNextButtons(boolean b) {
        this.forcePreviousAndNextButtons = b;
    }

    public void setWindowTitle(String title) {
        this.windowTitle = title;
    }

    protected boolean useJob() {
        return false;
    }

    protected String getJobTitle() {
        return this.getWindowTitle();
    }
}

