/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import java.util.ArrayList;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.viewers.AbstractTreeContentProvider;

public class ServerTypeTreeContentProvider
extends AbstractTreeContentProvider {
    public static final byte STYLE_VENDOR = 1;
    public static final byte STYLE_VERSION = 2;
    public static final byte STYLE_MODULE_TYPE = 3;
    public static final byte STYLE_TYPE = 4;
    protected boolean localhost = true;
    protected IModuleType moduleType;
    protected boolean includeIncompatibleVersions;

    public ServerTypeTreeContentProvider(byte style, IModuleType moduleType) {
        super(style, false);
        this.moduleType = moduleType;
        this.fillTree();
    }

    public void fillTree() {
        this.clean();
        ArrayList<IServerType> list = new ArrayList<IServerType>();
        IServerType[] serverTypes = ServerCore.getServerTypes();
        if (serverTypes != null) {
            int size = serverTypes.length;
            int i = 0;
            while (i < size) {
                IServerType serverType = serverTypes[i];
                if (this.include(serverType)) {
                    IRuntimeType runtimeType;
                    int order = this.getServerOrder(serverType);
                    if (order > this.initialSelectionOrder) {
                        this.initialSelection = serverType;
                        this.initialSelectionOrder = order;
                    }
                    if (this.style == 0) {
                        list.add(serverType);
                    } else if (this.style != 3) {
                        try {
                            runtimeType = serverType.getRuntimeType();
                            AbstractTreeContentProvider.TreeElement ele = null;
                            if (this.style == 1) {
                                ele = this.getOrCreate(list, runtimeType.getVendor());
                            } else if (this.style == 2) {
                                ele = this.getOrCreate(list, runtimeType.getVersion());
                            } else if (this.style == 4) {
                                ele = this.getOrCreate(list, runtimeType.getName());
                            }
                            ele.contents.add(serverType);
                            this.elementToParentMap.put(serverType, ele);
                        }
                        catch (Exception e) {
                            Trace.trace(Trace.WARNING, "Error in server configuration content provider", e);
                        }
                    } else {
                        runtimeType = serverType.getRuntimeType();
                        IModuleType[] moduleTypes = runtimeType.getModuleTypes();
                        if (moduleTypes != null) {
                            int size2 = moduleTypes.length;
                            int j = 0;
                            while (j < size2) {
                                IModuleType mb = moduleTypes[j];
                                if (mb != null) {
                                    AbstractTreeContentProvider.TreeElement ele = this.getOrCreate(list, mb.getName());
                                    AbstractTreeContentProvider.TreeElement ele2 = this.getOrCreate(ele.contents, String.valueOf(mb.getName()) + "/" + mb.getVersion(), mb.getVersion());
                                    ele2.contents.add(serverType);
                                    this.elementToParentMap.put(serverType, ele2);
                                    this.elementToParentMap.put(ele2, ele);
                                }
                                ++j;
                            }
                        }
                    }
                }
                ++i;
            }
        }
        this.elements = list.toArray();
    }

    protected boolean include(IServerType serverType) {
        IRuntimeType runtimeType = serverType.getRuntimeType();
        if (runtimeType == null) {
            return false;
        }
        String moduleTypeId = null;
        if (this.moduleType != null) {
            moduleTypeId = this.moduleType.getId();
        }
        if (this.includeIncompatibleVersions) {
            if (!ServerUtil.isSupportedModule((IModuleType[])runtimeType.getModuleTypes(), (String)moduleTypeId, null)) {
                return false;
            }
        } else {
            String moduleVersion = null;
            if (this.moduleType != null) {
                moduleVersion = this.moduleType.getVersion();
            }
            if (!ServerUtil.isSupportedModule((IModuleType[])runtimeType.getModuleTypes(), (String)moduleTypeId, (String)moduleVersion)) {
                return false;
            }
        }
        return this.localhost || serverType.supportsRemoteHosts();
    }

    protected boolean checkForNonStubEnvironmentRuntime(IServerType serverType) {
        IRuntimeType runtimeType = serverType.getRuntimeType();
        IRuntime[] runtimes = ServerUIPlugin.getRuntimes(runtimeType);
        if (runtimes == null || runtimes.length == 0) {
            return false;
        }
        int size = runtimes.length;
        int i = 0;
        while (i < size) {
            if (!runtimes[i].isStub()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setLocalhost(boolean local) {
        this.localhost = local;
        this.fillTree();
    }

    public void setIncludeIncompatibleVersions(boolean b) {
        this.includeIncompatibleVersions = b;
        this.fillTree();
    }

    private int getServerOrder(IServerType serverType) {
        return 0;
    }
}

