/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import java.util.Iterator;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerTree;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.view.servers.DeleteAction;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleServer;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleSloshAction;
import org.eclipse.wst.server.ui.internal.view.servers.MonitorServerAction;
import org.eclipse.wst.server.ui.internal.view.servers.MonitorServerPortAction;
import org.eclipse.wst.server.ui.internal.view.servers.OpenAction;
import org.eclipse.wst.server.ui.internal.view.servers.PublishAction;
import org.eclipse.wst.server.ui.internal.view.servers.RestartAction;
import org.eclipse.wst.server.ui.internal.view.servers.RestartModuleAction;
import org.eclipse.wst.server.ui.internal.view.servers.ServerTableViewer;
import org.eclipse.wst.server.ui.internal.view.servers.ServersViewDropAdapter;
import org.eclipse.wst.server.ui.internal.view.servers.StartAction;
import org.eclipse.wst.server.ui.internal.view.servers.StopAction;
import org.eclipse.wst.server.ui.internal.view.servers.SwitchServerLocationAction;
import org.eclipse.wst.server.ui.internal.view.servers.UpdateStatusAction;

public class ServersView
extends ViewPart {
    protected Tree treeTable;
    protected ServerTableViewer tableViewer;
    protected Action[] actions;
    protected MenuManager restartMenu;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void createPartControl(Composite parent) {
        this.treeTable = new Tree(parent, 66308);
        this.treeTable.setHeaderVisible(true);
        this.treeTable.setLinesVisible(false);
        this.treeTable.setLayoutData((Object)new GridData(1808));
        this.treeTable.setFont(parent.getFont());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.treeTable, "org.eclipse.wst.server.ui.svcp0000");
        TreeColumn column = new TreeColumn(this.treeTable, 4);
        column.setText(Messages.viewServer);
        column.setWidth(200);
        column = new TreeColumn(this.treeTable, 4);
        column.setText(Messages.viewStatus);
        column.setWidth(200);
        column = new TreeColumn(this.treeTable, 4);
        column.setText(Messages.viewSync);
        column.setWidth(200);
        this.tableViewer = new ServerTableViewer(this, this.treeTable);
        this.initializeActions((ISelectionProvider)this.tableViewer);
        this.treeTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                try {
                    TreeItem item = ServersView.this.treeTable.getSelection()[0];
                    Object data = item.getData();
                    if (!(data instanceof IServer)) {
                        return;
                    }
                    IServer server = (IServer)data;
                    ServerUIPlugin.editServer(server);
                }
                catch (Exception e) {
                    Trace.trace((int)Trace.SEVERE, (String)"Could not open server", (Throwable)e);
                }
            }
        });
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        final Shell shell = this.treeTable.getShell();
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ServersView.this.fillContextMenu(shell, mgr);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)parent);
        this.treeTable.setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.tableViewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        this.initDragAndDrop();
    }

    protected void selectServerProcess(Object process) {
        IViewPart part;
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (part = page.findView("org.eclipse.debug.ui.DebugView")) != null) {
            Viewer viewer;
            IDebugView view;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.ui.IDebugView");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((view = (IDebugView)part.getAdapter((Class)clazz)) != null && (viewer = view.getViewer()) != null) {
                viewer.setSelection((ISelection)new StructuredSelection(process));
            }
        }
    }

    public void initializeActions(ISelectionProvider provider) {
        Shell shell = this.getSite().getShell();
        StartAction debugAction = new StartAction(shell, provider, "debug", "debug");
        debugAction.setToolTipText(Messages.actionDebugToolTip);
        debugAction.setText(Messages.actionDebug);
        debugAction.setImageDescriptor(ImageResource.getImageDescriptor("IMG_ELCL_START_DEBUG"));
        debugAction.setHoverImageDescriptor(ImageResource.getImageDescriptor("IMG_CLCL_START_DEBUG"));
        debugAction.setDisabledImageDescriptor(ImageResource.getImageDescriptor("IMG_DLCL_START_DEBUG"));
        StartAction runAction = new StartAction(shell, provider, "start", "run");
        runAction.setToolTipText(Messages.actionStartToolTip);
        runAction.setText(Messages.actionStart);
        runAction.setImageDescriptor(ImageResource.getImageDescriptor("IMG_ELCL_START"));
        runAction.setHoverImageDescriptor(ImageResource.getImageDescriptor("IMG_CLCL_START"));
        runAction.setDisabledImageDescriptor(ImageResource.getImageDescriptor("IMG_DLCL_START"));
        StartAction profileAction = new StartAction(shell, provider, "profile", "profile");
        profileAction.setToolTipText(Messages.actionProfileToolTip);
        profileAction.setText(Messages.actionProfile);
        profileAction.setImageDescriptor(ImageResource.getImageDescriptor("IMG_ELCL_START_PROFILE"));
        profileAction.setHoverImageDescriptor(ImageResource.getImageDescriptor("IMG_CLCL_START_PROFILE"));
        profileAction.setDisabledImageDescriptor(ImageResource.getImageDescriptor("IMG_DLCL_START_PROFILE"));
        this.restartMenu = new MenuManager(Messages.actionRestart);
        RestartAction restartAction = new RestartAction(shell, provider, "restartDebug", "debug");
        restartAction.setToolTipText(Messages.actionDebugToolTip);
        restartAction.setText(Messages.actionDebug);
        restartAction.setImageDescriptor(ImageResource.getImageDescriptor("IMG_ELCL_START_DEBUG"));
        restartAction.setHoverImageDescriptor(ImageResource.getImageDescriptor("IMG_CLCL_START_DEBUG"));
        restartAction.setDisabledImageDescriptor(ImageResource.getImageDescriptor("IMG_DLCL_START_DEBUG"));
        this.restartMenu.add((IAction)restartAction);
        restartAction = new RestartAction(shell, provider, "restartRun", "run");
        restartAction.setToolTipText(Messages.actionRestartToolTip);
        restartAction.setText(Messages.actionStart);
        restartAction.setImageDescriptor(ImageResource.getImageDescriptor("IMG_ELCL_START"));
        restartAction.setHoverImageDescriptor(ImageResource.getImageDescriptor("IMG_CLCL_START"));
        restartAction.setDisabledImageDescriptor(ImageResource.getImageDescriptor("IMG_DLCL_START"));
        this.restartMenu.add((IAction)restartAction);
        restartAction = new RestartAction(shell, provider, "restartProfile", "profile");
        restartAction.setToolTipText(Messages.actionRestartToolTip);
        restartAction.setText(Messages.actionProfile);
        restartAction.setImageDescriptor(ImageResource.getImageDescriptor("IMG_ELCL_START_PROFILE"));
        restartAction.setHoverImageDescriptor(ImageResource.getImageDescriptor("IMG_CLCL_START_PROFILE"));
        restartAction.setDisabledImageDescriptor(ImageResource.getImageDescriptor("IMG_DLCL_START_PROFILE"));
        this.restartMenu.add((IAction)restartAction);
        restartAction = new RestartAction(shell, provider, "restart");
        restartAction.setToolTipText(Messages.actionRestartToolTip);
        restartAction.setText(Messages.actionRestart);
        restartAction.setImageDescriptor(ImageResource.getImageDescriptor("IMG_ELCL_RESTART"));
        restartAction.setHoverImageDescriptor(ImageResource.getImageDescriptor("IMG_CLCL_RESTART"));
        restartAction.setDisabledImageDescriptor(ImageResource.getImageDescriptor("IMG_DLCL_RESTART"));
        StopAction stopAction = new StopAction(shell, provider, "stop");
        stopAction.setToolTipText(Messages.actionStopToolTip);
        stopAction.setText(Messages.actionStop);
        stopAction.setImageDescriptor(ImageResource.getImageDescriptor("IMG_ELCL_STOP"));
        stopAction.setHoverImageDescriptor(ImageResource.getImageDescriptor("IMG_CLCL_STOP"));
        stopAction.setDisabledImageDescriptor(ImageResource.getImageDescriptor("IMG_DLCL_STOP"));
        PublishAction publishAction = new PublishAction(shell, provider, "publish");
        publishAction.setToolTipText(Messages.actionPublishToolTip);
        publishAction.setText(Messages.actionPublish);
        publishAction.setImageDescriptor(ImageResource.getImageDescriptor("IMG_ELCL_PUBLISH"));
        publishAction.setHoverImageDescriptor(ImageResource.getImageDescriptor("IMG_CLCL_PUBLISH"));
        publishAction.setDisabledImageDescriptor(ImageResource.getImageDescriptor("IMG_DLCL_PUBLISH"));
        ModuleSloshAction addModuleAction = new ModuleSloshAction(shell, provider, "modules");
        addModuleAction.setToolTipText(Messages.actionModifyModulesToolTip);
        addModuleAction.setText(Messages.actionModifyModules);
        addModuleAction.setImageDescriptor(ImageResource.getImageDescriptor("IMG_ETOOL_MODIFY_MODULES"));
        addModuleAction.setHoverImageDescriptor(ImageResource.getImageDescriptor("IMG_CTOOL_MODIFY_MODULES"));
        addModuleAction.setDisabledImageDescriptor(ImageResource.getImageDescriptor("IMG_DTOOL_MODIFY_MODULES"));
        this.actions = new Action[7];
        this.actions[0] = debugAction;
        this.actions[1] = runAction;
        this.actions[2] = profileAction;
        this.actions[3] = restartAction;
        this.actions[4] = stopAction;
        this.actions[5] = publishAction;
        this.actions[6] = addModuleAction;
        IToolBarManager cm = this.getViewSite().getActionBars().getToolBarManager();
        int i = 0;
        while (i < this.actions.length - 1) {
            cm.add((IAction)this.actions[i]);
            ++i;
        }
    }

    protected void fillContextMenu(Shell shell, IMenuManager menu) {
        IServer server = null;
        IModule[] module = null;
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (!selection.isEmpty()) {
            Iterator iterator = selection.iterator();
            Object obj = iterator.next();
            if (obj instanceof IServer) {
                server = (IServer)obj;
            }
            if (obj instanceof ModuleServer) {
                ModuleServer ms = (ModuleServer)obj;
                server = ms.server;
                module = ms.module;
            }
            if (iterator.hasNext()) {
                server = null;
                module = null;
            }
        }
        MenuManager newMenu = new MenuManager(Messages.actionNew);
        ServerTree.fillNewContextMenu(null, (ISelection)selection, (IMenuManager)newMenu);
        menu.add((IContributionItem)newMenu);
        if (server != null) {
            menu.add((IAction)new OpenAction(server));
            if (server.getServerState() == 0) {
                menu.add((IAction)new UpdateStatusAction(server));
            }
            menu.add((IContributionItem)new Separator());
            menu.add((IAction)new DeleteAction(shell, server));
            menu.add((IContributionItem)new Separator());
            int i = 0;
            while (i < this.actions.length - 1) {
                if (i == 3) {
                    menu.add((IContributionItem)this.restartMenu);
                } else {
                    menu.add((IAction)this.actions[i]);
                }
                ++i;
            }
            if (server.getServerType() != null) {
                final MenuManager menuManager = new MenuManager(Messages.actionMonitor);
                final IServer server2 = server;
                final Shell shell2 = shell;
                menuManager.addMenuListener(new IMenuListener(){

                    public void menuAboutToShow(IMenuManager manager) {
                        ServerPort[] ports;
                        menuManager.removeAll();
                        Class<?> clazz = class$1;
                        if (clazz == null) {
                            try {
                                clazz = class$1 = Class.forName("org.eclipse.wst.server.core.model.ServerDelegate");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (server2.getAdapter((Class)clazz) != null && (ports = server2.getServerPorts(null)) != null) {
                            int size = ports.length;
                            int i = 0;
                            while (i < size) {
                                if (!ports[i].isAdvanced()) {
                                    menuManager.add((IAction)new MonitorServerPortAction(shell2, server2, ports[i]));
                                }
                                ++i;
                            }
                        }
                        menuManager.add((IAction)new MonitorServerAction(shell2, server2));
                    }
                });
                menuManager.add((IAction)new MonitorServerAction(shell, server));
                menu.add((IContributionItem)menuManager);
            }
            menu.add((IAction)new SwitchServerLocationAction(server));
        }
        if (server != null && module != null) {
            menu.add((IContributionItem)new Separator());
            RestartModuleAction action = new RestartModuleAction(server, module);
            menu.add((IAction)action);
        }
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.actions[6]);
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("additions-end"));
    }

    public void setFocus() {
        if (this.treeTable != null) {
            this.treeTable.setFocus();
        }
    }

    protected void initDragAndDrop() {
        int ops = 1;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getInstance(), ResourceTransfer.getInstance(), FileTransfer.getInstance()};
        this.tableViewer.addDropSupport(ops | 0x10, transfers, (DropTargetListener)new ServersViewDropAdapter((Viewer)this.tableViewer));
    }
}

