/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IProjectProperties;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.Module;
import org.eclipse.wst.server.ui.ServerUIUtil;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.SWTUtil;

public class RuntimeTargetComposite {
    protected IProject project;
    protected IProjectProperties props;
    protected IRuntime currentRuntime;
    protected IRuntime newRuntime;
    protected IRuntime[] targets;
    protected String[] items;
    protected List childProjects;
    protected boolean setChildren = true;
    protected int offset = 0;

    protected RuntimeTargetComposite(Composite parent, IProject project) {
        this.project = project;
        this.props = ServerCore.getProjectProperties((IProject)project);
        this.currentRuntime = this.props.getRuntimeTarget();
        if (this.currentRuntime == null) {
            this.offset = 1;
        }
        IModule projectModule = ServerUtil.getModules((IProject)project)[0];
        this.childProjects = new ArrayList();
        if (projectModule != null) {
            ArrayList<IModule> children = new ArrayList<IModule>();
            IModule[] child = ((Module)projectModule).getChildModules(null);
            if (child != null) {
                int size = child.length;
                int i = 0;
                while (i < size) {
                    children.add(child[i]);
                    ++i;
                }
                int a = 0;
                while (a < children.size()) {
                    IModule module = (IModule)children.get(a);
                    IModule[] child2 = ((Module)module).getChildModules(null);
                    if (child2 != null) {
                        size = child2.length;
                        int i2 = 0;
                        while (i2 < size) {
                            children.add(child2[i2]);
                            ++i2;
                        }
                    }
                    ++a;
                }
            }
            Iterator iterator = children.iterator();
            while (iterator.hasNext()) {
                IModule module = (IModule)iterator.next();
                if (module.getProject() == null) continue;
                this.childProjects.add(module);
            }
        }
        this.createContents(parent);
    }

    protected void createContents(final Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.runtimeTargetCombo);
        GridData data = new GridData(256);
        label.setLayoutData((Object)data);
        final Combo combo = new Combo(parent, 12);
        data = new GridData(768);
        data.horizontalSpan = 2;
        combo.setLayoutData((Object)data);
        int sel = this.updateRuntimes();
        combo.setItems(this.items);
        if (this.items.length == 0) {
            combo.setEnabled(false);
        } else {
            combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int select = combo.getSelectionIndex();
                    RuntimeTargetComposite.this.newRuntime = RuntimeTargetComposite.this.offset > 0 && select == 0 ? null : RuntimeTargetComposite.this.targets[select - RuntimeTargetComposite.this.offset];
                }
            });
            if (sel >= 0) {
                combo.select(sel);
                if (this.offset == 0 || sel > 0) {
                    this.newRuntime = this.targets[sel - this.offset];
                }
            } else {
                combo.select(0);
            }
        }
        final IModule projectModule = ServerUtil.getModules((IProject)this.project)[0];
        Button newButton = SWTUtil.createButton(parent, Messages.runtimeTargetNewRuntime);
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String currentRuntime2 = combo.getText();
                String type = null;
                String version = null;
                if (projectModule != null) {
                    IModuleType mt = projectModule.getModuleType();
                    type = mt.getId();
                    version = mt.getVersion();
                }
                if (ServerUIUtil.showNewRuntimeWizard(parent.getShell(), type, version)) {
                    int sel2 = RuntimeTargetComposite.this.updateRuntimes();
                    combo.setItems(RuntimeTargetComposite.this.items);
                    combo.setText(currentRuntime2);
                    if (combo.getSelectionIndex() == -1) {
                        combo.select(sel2);
                    }
                }
            }
        });
        if (!this.childProjects.isEmpty()) {
            final Button includeChildren = new Button(parent, 32);
            includeChildren.setText(Messages.runtimeTargetChildren);
            data = new GridData();
            data.horizontalSpan = 2;
            includeChildren.setLayoutData((Object)data);
            includeChildren.setSelection(true);
            includeChildren.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    RuntimeTargetComposite.this.setChildren = includeChildren.getSelection();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        } else {
            new Label(parent, 0);
            new Label(parent, 0);
        }
        Link prefLink = new Link(parent, 0);
        data = new GridData(128);
        data.horizontalSpan = 2;
        prefLink.setLayoutData((Object)data);
        prefLink.setText(Messages.runtimeTargetRuntimePreferences);
        prefLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String currentRuntime2 = combo.getText();
                if (RuntimeTargetComposite.showRuntimePreferencePage(parent.getShell())) {
                    int sel2 = RuntimeTargetComposite.this.updateRuntimes();
                    combo.setItems(RuntimeTargetComposite.this.items);
                    combo.setText(currentRuntime2);
                    if (combo.getSelectionIndex() == -1) {
                        combo.select(sel2);
                    }
                }
            }
        });
    }

    protected static boolean showRuntimePreferencePage(Shell shell) {
        PreferenceManager manager = PlatformUI.getWorkbench().getPreferenceManager();
        IPreferenceNode node = manager.find("org.eclipse.wst.server.ui.preferencePage").findSubNode("org.eclipse.wst.server.ui.runtime.preferencePage");
        PreferenceManager manager2 = new PreferenceManager();
        manager2.addToRoot(node);
        final PreferenceDialog dialog = new PreferenceDialog(shell, manager2);
        final boolean[] result = new boolean[1];
        BusyIndicator.showWhile((Display)shell.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                dialog.create();
                if (dialog.open() == 0) {
                    result[0] = true;
                }
            }
        });
        return result[0];
    }

    protected int updateRuntimes() {
        IModule pm = ServerUtil.getModules((IProject)this.project)[0];
        if (pm != null) {
            IModuleType mt = pm.getModuleType();
            this.targets = ServerUtil.getRuntimes((String)mt.getId(), (String)mt.getVersion());
        }
        this.items = new String[0];
        int sel = -1;
        if (this.targets != null) {
            int size = this.targets.length;
            this.items = new String[size + this.offset];
            if (this.offset > 0) {
                this.items[0] = Messages.runtimeTargetNone;
                sel = 0;
            }
            int i = 0;
            while (i < size) {
                IRuntime target = this.targets[i];
                this.items[i + this.offset] = target.getName();
                if (target.equals(this.currentRuntime)) {
                    sel = i;
                }
                ++i;
            }
        }
        return sel;
    }

    public IRuntime getSelectedRuntime() {
        return this.newRuntime;
    }

    public boolean hasChanged() {
        if (!this.childProjects.isEmpty()) {
            return true;
        }
        if (this.newRuntime == null) {
            return false;
        }
        return !this.newRuntime.equals(this.currentRuntime);
    }

    public void apply(IProgressMonitor monitor) throws CoreException {
        if (this.newRuntime == null || !this.newRuntime.equals(this.props.getRuntimeTarget())) {
            this.props.setRuntimeTarget(this.newRuntime, monitor);
        }
        if (this.setChildren) {
            Iterator iterator = this.childProjects.iterator();
            while (iterator.hasNext()) {
                IModule module = (IModule)iterator.next();
                IProject proj = module.getProject();
                this.props = ServerCore.getProjectProperties((IProject)proj);
                if (this.newRuntime != null && this.newRuntime.equals(this.props.getRuntimeTarget())) continue;
                this.props.setRuntimeTarget(this.newRuntime, monitor);
            }
        }
    }
}

