/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.initParser;

import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jem.internal.proxy.common.AmbiguousMethodException;
import org.eclipse.jem.internal.proxy.common.MethodHelper;
import org.eclipse.jem.internal.proxy.initParser.EvaluationException;
import org.eclipse.jem.internal.proxy.initParser.Expression;
import org.eclipse.jem.internal.proxy.initParser.Field;
import org.eclipse.jem.internal.proxy.initParser.MessageArgument;
import org.eclipse.jem.internal.proxy.initParser.Statement;

public class Message
extends Expression {
    protected boolean trailingPeriod = false;
    protected Method fMethod;
    public Expression receiver;
    public String message;
    public boolean argsClosed = false;
    public boolean insideArgsOpenedParen = false;
    public boolean insideArgsClosedParen = false;
    protected boolean isComplete = false;
    public ArrayList arguments = new ArrayList(2);

    public Message(Expression aReceiver, char[] token, ClassLoader aClassLoader) {
        this.receiver = aReceiver;
        this.message = new String(token);
        this.fClassLoader = aClassLoader;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public Object evaluate() throws Exception {
        this.cacheMethod();
        Object[] args = new Object[this.arguments.size()];
        Iterator itr = this.arguments.iterator();
        int i = 0;
        while (i < this.arguments.size()) {
            Expression anExpression = (Expression)itr.next();
            args[i] = anExpression.evaluate();
            ++i;
        }
        Object receiverValue = this.receiver.evaluate();
        try {
            return this.fMethod.invoke(receiverValue, args);
        }
        catch (Exception e) {
            throw new EvaluationException(e);
        }
    }

    protected void cacheMethod() throws Exception {
        if (this.fMethod == null) {
            Class[] argTypes = new Class[this.arguments.size()];
            Iterator itr = this.arguments.iterator();
            int i = 0;
            while (i < argTypes.length) {
                argTypes[i] = this.getEvaluationTypeClass((Expression)itr.next());
                ++i;
            }
            try {
                this.fMethod = MethodHelper.findCompatibleMethod((Class)this.getEvaluationTypeClass(this.receiver), (String)this.message, (Class[])argTypes);
            }
            catch (NoSuchMethodException e) {
                throw new EvaluationException(e);
            }
            catch (AmbiguousMethodException e) {
                throw new EvaluationException(e);
            }
        }
    }

    public Class getTypeClass() throws Exception {
        this.cacheMethod();
        return this.fMethod.getReturnType();
    }

    protected String getTypeClassName() {
        return "";
    }

    public Expression push(char[] token, char tokenDelimiter) {
        if (this.argsClosed && !this.trailingPeriod && tokenDelimiter == '.' && token.length == 0) {
            this.trailingPeriod = true;
            return this;
        }
        if (this.trailingPeriod && tokenDelimiter == '.') {
            return new Field(this, token, this.fClassLoader);
        }
        if (this.trailingPeriod && tokenDelimiter == '(') {
            return new Message(this, token, this.fClassLoader);
        }
        if (this.argsClosed && (tokenDelimiter == ',' || tokenDelimiter == ')')) {
            this.isComplete = true;
            return this;
        }
        if (!this.argsClosed) {
            Expression openArgument;
            if (this.arguments.size() > 0 && !(openArgument = (Expression)this.arguments.get(this.arguments.size() - 1)).isComplete()) {
                openArgument.push(token, tokenDelimiter);
                if (openArgument.isComplete() && tokenDelimiter == ')') {
                    this.argsClosed = true;
                }
                return this;
            }
            Expression newArgument = null;
            if (!this.insideArgsOpenedParen && tokenDelimiter == '(') {
                this.insideArgsOpenedParen = true;
                newArgument = new Statement(this.fClassLoader).push(token, tokenDelimiter);
                newArgument = new MessageArgument(newArgument);
                this.arguments.add(newArgument);
            }
            if (newArgument == null && (token.length > 0 || tokenDelimiter == '\"' || tokenDelimiter == '\'' || tokenDelimiter == '(')) {
                newArgument = new Statement(this.fClassLoader).push(token, tokenDelimiter);
                newArgument = new MessageArgument(newArgument);
                this.arguments.add(newArgument);
            }
            if (!this.insideArgsOpenedParen && tokenDelimiter == ')') {
                this.argsClosed = true;
                return this;
            }
            if (this.insideArgsOpenedParen && tokenDelimiter == ')') {
                this.insideArgsClosedParen = true;
                return this;
            }
            if (tokenDelimiter == ',' || tokenDelimiter == ' ') {
                return this;
            }
        }
        if (this.message.length() == 0) {
            this.message = new String(token);
            return this;
        }
        return this;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write("Msg Name=\"");
        if (this.message != null) {
            writer.write(this.message);
        } else {
            writer.write("UNNAMED");
        }
        writer.write("\" Rcv=(");
        if (this.receiver != null) {
            writer.write(this.receiver.toString());
        } else {
            writer.write("NONE");
        }
        writer.write(41);
        if (this.arguments != null) {
            writer.write("Args(");
            Iterator iter = this.arguments.iterator();
            int i = 1;
            while (iter.hasNext()) {
                writer.write(new Integer(i).toString());
                writer.write(40);
                writer.write(iter.next().toString());
                writer.write("),");
            }
            writer.write(41);
        }
        return writer.toString();
    }

    public boolean isPrimitive() throws Exception {
        this.cacheMethod();
        return this.fMethod.getReturnType().isPrimitive();
    }
}

