/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.initParser;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jem.internal.proxy.common.AmbiguousMethodException;
import org.eclipse.jem.internal.proxy.common.MethodHelper;
import org.eclipse.jem.internal.proxy.initParser.ArrayArguments;
import org.eclipse.jem.internal.proxy.initParser.CannotProcessInnerClassesException;
import org.eclipse.jem.internal.proxy.initParser.EvaluationException;
import org.eclipse.jem.internal.proxy.initParser.Expression;
import org.eclipse.jem.internal.proxy.initParser.Field;
import org.eclipse.jem.internal.proxy.initParser.Message;
import org.eclipse.jem.internal.proxy.initParser.MessageArgument;
import org.eclipse.jem.internal.proxy.initParser.Statement;
import org.eclipse.jem.internal.proxy.initParser.Static;

public class Constructor
extends Expression {
    public boolean argsOpened = false;
    public boolean argsClosed = false;
    public boolean trailingPeriod = false;
    public ArrayList arguments = new ArrayList(2);
    public Static type;
    protected boolean fIsComplete;
    public boolean insideArgsOpenedParen = false;
    public boolean insideArgsClosedParen = false;
    public boolean isString = false;
    public java.lang.reflect.Constructor ctor;

    public Constructor(ClassLoader aClassLoader) {
        this.fClassLoader = aClassLoader;
    }

    public boolean isComplete() {
        return this.fIsComplete;
    }

    public Object evaluate() throws Exception {
        if (this.type.isArray()) {
            if (this.arguments.size() > 0) {
                this.type.setArrayArguments(this.arguments);
            }
            Object result = this.type.evaluate();
            return result;
        }
        this.cacheCtor();
        Object[] args = new Object[this.arguments.size()];
        Iterator itr = this.arguments.iterator();
        int i = 0;
        while (i < this.arguments.size()) {
            Expression anExpression = (Expression)itr.next();
            args[i] = anExpression.evaluate();
            ++i;
        }
        try {
            return this.ctor.newInstance(args);
        }
        catch (Exception e) {
            throw new EvaluationException(e);
        }
    }

    public Class getTypeClass() throws Exception {
        if (this.type.isArray() && this.arguments.size() > 0) {
            this.type.setArrayArguments(this.arguments);
        }
        return this.type.getTypeClass();
    }

    protected String getTypeClassName() {
        return this.type.getTypeClassName();
    }

    private void cacheCtor() throws Exception {
        if (this.ctor == null) {
            Class[] argTypes = new Class[this.arguments.size()];
            Iterator itr = this.arguments.iterator();
            int i = 0;
            while (i < argTypes.length) {
                argTypes[i] = this.getEvaluationTypeClass((Expression)itr.next());
                ++i;
            }
            try {
                this.ctor = MethodHelper.findCompatibleConstructor((Class)this.getEvaluationTypeClass(this), (Class[])argTypes);
            }
            catch (NoSuchMethodException e) {
                throw new EvaluationException(e);
            }
            catch (AmbiguousMethodException e) {
                throw new EvaluationException(e);
            }
        }
    }

    protected boolean isDelimiterOpened(char token) {
        return this.type.isArray() ? token == '{' : token == '(';
    }

    protected boolean isDelimiterClosed(char token) {
        return this.type.isArray() ? token == '}' : token == ')';
    }

    public Expression push(char[] token, char tokenDelimiter) {
        if (this.argsClosed && !this.trailingPeriod && tokenDelimiter == '.' && token.length == 0) {
            this.trailingPeriod = true;
            return this;
        }
        if (this.trailingPeriod && tokenDelimiter == '.') {
            return new Field(this, token, this.fClassLoader);
        }
        if (this.trailingPeriod && tokenDelimiter == '(') {
            return new Message(this, token, this.fClassLoader);
        }
        if (this.type == null) {
            switch (tokenDelimiter) {
                case '.': {
                    this.type = new Static(token, tokenDelimiter, this.fClassLoader);
                    this.type.setClassLoader(this.fClassLoader);
                    return this;
                }
                case '(': {
                    this.type = new Static(token, tokenDelimiter, this.fClassLoader);
                    this.type.setClassLoader(this.fClassLoader);
                    this.argsOpened = true;
                    return this;
                }
                case '[': {
                    this.type = new Static(token, tokenDelimiter, this.fClassLoader, true);
                    return this;
                }
                case '{': {
                    if (this.type == null || !this.type.isArray()) break;
                    this.argsOpened = true;
                }
            }
            return null;
        }
        if (this.type != null && this.type.isArray() && (this.type.isProcessingArrayDimension || tokenDelimiter == '[')) {
            this.type.push(token, tokenDelimiter);
            return this;
        }
        if (!(this.type.isArray() || this.type.getTypeClass() != null || tokenDelimiter != '.' && tokenDelimiter != '[')) {
            this.type.push(token, tokenDelimiter);
            return this;
        }
        if (!this.type.isArray()) {
            if (this.type.getTypeClass() == null && !this.argsOpened && this.isDelimiterOpened(tokenDelimiter)) {
                this.argsOpened = true;
                this.insideArgsOpenedParen = true;
                this.type.push(token, ' ');
                return this;
            }
        } else if (!this.argsOpened && this.isDelimiterOpened(tokenDelimiter)) {
            this.argsOpened = true;
            this.insideArgsOpenedParen = true;
            return this;
        }
        if (this.argsClosed && tokenDelimiter == ')') {
            this.fIsComplete = true;
            return this;
        }
        if (this.argsClosed && tokenDelimiter == '{') {
            throw new CannotProcessInnerClassesException();
        }
        if (this.argsOpened) {
            Expression lastArgument;
            Expression openArgument = null;
            if (this.arguments.size() > 0 && !(openArgument = (Expression)this.arguments.get(this.arguments.size() - 1)).isComplete()) {
                openArgument.push(token, tokenDelimiter);
                if (openArgument.isComplete() && this.isDelimiterClosed(tokenDelimiter)) {
                    this.argsClosed = true;
                }
                return this;
            }
            Expression newArgument = null;
            if (tokenDelimiter == '{' || tokenDelimiter == '(') {
                this.insideArgsOpenedParen = true;
                newArgument = new Statement(this.fClassLoader).push(token, tokenDelimiter);
                if (newArgument instanceof ArrayArguments) {
                    ((ArrayArguments)newArgument).setType(this.type);
                }
                newArgument = new MessageArgument(newArgument);
                this.arguments.add(newArgument);
            }
            if (token.length > 0 || tokenDelimiter == '\"' || tokenDelimiter == '\'' || tokenDelimiter == '-') {
                newArgument = new Statement(this.fClassLoader).push(token, tokenDelimiter);
                newArgument = new MessageArgument(newArgument);
                this.arguments.add(newArgument);
            }
            if (!this.insideArgsOpenedParen || this.argumentsAreComplete() && this.isDelimiterClosed(tokenDelimiter)) {
                this.argsClosed = true;
                return this;
            }
            if (this.insideArgsOpenedParen && this.isDelimiterClosed(tokenDelimiter)) {
                this.insideArgsClosedParen = true;
                return this;
            }
            if (tokenDelimiter == ',' || tokenDelimiter == ' ') {
                if (this.argsClosed) {
                    this.fIsComplete = true;
                }
                return this;
            }
            if (this.argsOpened && this.isDelimiterClosed(tokenDelimiter) && this.arguments.size() == 0) {
                this.argsClosed = true;
                return this;
            }
            if (tokenDelimiter == ')' && newArgument == null && (lastArgument = (Expression)this.arguments.get(this.arguments.size() - 1)).isComplete()) {
                this.argsClosed = true;
                return this;
            }
            return newArgument;
        }
        return this;
    }

    protected boolean argumentsAreComplete() {
        if (this.arguments.size() == 0) {
            return true;
        }
        return ((Expression)this.arguments.get(this.arguments.size() - 1)).isComplete();
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write("Constructor \"");
        if (this.type != null) {
            writer.write(this.type.typeWriter.toString());
        } else {
            writer.write("UNTYPED");
        }
        int i = 0;
        while (i < this.arguments.size()) {
            writer.write(" Arg(");
            writer.write("" + (i + 1));
            writer.write(") = ");
            writer.write(this.arguments.get(i).toString());
            ++i;
        }
        return writer.toString();
    }

    public boolean isPrimitive() {
        return false;
    }
}

