/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.ui.internal.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.wst.wsi.ui.internal.WSIUIPlugin;

public class ValidationWizardLogPage
extends WizardNewFileCreationPage {
    public static final String WSI_LOG_EXTENSION = "wsimsg";
    protected String filename;

    public ValidationWizardLogPage(IStructuredSelection selection, String filename) {
        super("ValidationWizardLogPage", selection);
        this.filename = filename;
        this.setTitle(WSIUIPlugin.getResourceString("_UI_WIZARD_V_SELECT_LOG_FILENAME_HEADING"));
        this.setDescription(WSIUIPlugin.getResourceString("_UI_WIZARD_V_SELECT_LOG_FILENAME_EXPL"));
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        super.setFileName(this.filename);
        this.setPageComplete(this.validatePage());
    }

    public IFile getFile() {
        String fileName = this.getFileName();
        String fileExtension = new Path(fileName).getFileExtension();
        if (fileExtension == null) {
            fileName = fileName.concat(".wsimsg");
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(fileName));
    }

    protected boolean validatePage() {
        String fileExtension = new Path(this.getFileName()).getFileExtension();
        if (fileExtension != null && fileExtension.compareTo(WSI_LOG_EXTENSION) != 0) {
            this.setErrorMessage(WSIUIPlugin.getResourceString("_ERROR_INVALID_LOG_FILE_EXTENSION"));
            return false;
        }
        if (this.getContainerFullPath() != null && !this.getContainerFullPath().isEmpty() && this.getFileName().compareTo("") != 0) {
            Path fullPath = fileExtension != null ? new Path(String.valueOf(this.getContainerFullPath().toString()) + '/' + this.getFileName()) : new Path(String.valueOf(this.getContainerFullPath().toString()) + '/' + this.getFileName() + "." + WSI_LOG_EXTENSION);
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)fullPath);
            this.setErrorMessage(null);
            if (resource != null) {
                this.setMessage(WSIUIPlugin.getResourceString("_WARNING_FILE_ALREADY_EXISTS"));
            } else {
                this.setMessage(null);
            }
            return true;
        }
        return super.validatePage();
    }
}

